/*
  ͻ
                                                                          
                                Desk Scene                                
                                                                          
                         by Christopher D. Watkins                        
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "math.h"
#include "defs.h"

typedef char name[33];

FILE *textdiskfile;
name filename;

Word xresolution  = 1024;
Word yresolution  = 768;
Byte numberofframes  = 1;

void writeheader()
{
  fprintf(textdiskfile,"ͻ\n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                              Desk  Scene                               \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"                       by Christopher D. Watkins                        \n");
  fprintf(textdiskfile,"                                                                        \n");
  fprintf(textdiskfile,"ͼ\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"STATS\n");
  fprintf(textdiskfile,"   XRES    = %d\n",xresolution);
  fprintf(textdiskfile,"   YRES    = %d\n",yresolution);
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"FRAMES\n");
  fprintf(textdiskfile,"   NUMBER  = %d\n",numberofframes);
}

void writestudio()
{
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENVIRONMENT\n");
  fprintf(textdiskfile,"   LOCLWGT =    0.750    0.750    0.750\n");
  fprintf(textdiskfile,"   REFLWGT =    0.250    0.250    0.250\n");
  fprintf(textdiskfile,"   TRANWGT =    0.950    0.950    0.950\n");
  fprintf(textdiskfile,"   MINWGT  =    0.030    0.030    0.030\n");
  fprintf(textdiskfile,"   MAXWGT  =    1.000    1.000    1.000\n");
  fprintf(textdiskfile,"   RDEPTH  =    5\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMPS\n");
  fprintf(textdiskfile,"   REFLAMP = FALSE\n");
  fprintf(textdiskfile,"   LAMPREF =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   DISTEFF =    0.300\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"OBSERVER\n");
  fprintf(textdiskfile,"   FLENGTH =    1.400\n");
  fprintf(textdiskfile,"   OBSPOS  =    0.000 -295.000  290.000\n");
  fprintf(textdiskfile,"   ROTATE  =    0.000\n");
  fprintf(textdiskfile,"   TILT    =   28.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = MATTEWALL\n");
  fprintf(textdiskfile,"   TEXTURE = SHEETROCK\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.300    0.300    0.300\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.700    0.700    0.700\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =    0.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = BLACKFELT\n");
  fprintf(textdiskfile,"   TEXTURE = SHEETROCK\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.350    0.350    0.350\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   GLOSS   =    0.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = CHROME\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.800    0.800    0.800\n");
  fprintf(textdiskfile,"   GLOSS   =   40.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = BRASS\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.300    0.300    0.300\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.600    0.500    0.250\n");
  fprintf(textdiskfile,"   GLOSS   =   30.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = MIRROR\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.700    0.700    0.700\n");
  fprintf(textdiskfile,"   GLOSS   =   40.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = ITALIANMARBLE\n");
  fprintf(textdiskfile,"   TEXTURE = MARBLE\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.600    0.600    0.600\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =   10.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = OAKWOOD\n");
  fprintf(textdiskfile,"   TEXTURE = WOOD\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.200    0.200    0.200\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.700    0.400    0.300\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.100    0.100    0.100\n");
  fprintf(textdiskfile,"   GLOSS   =    5.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.000    0.000    0.000\n");
  fprintf(textdiskfile,"   INDEX   =    1.000\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"MATERIAL\n");
  fprintf(textdiskfile,"   TYPE    = REDGLASS\n");
  fprintf(textdiskfile,"   TEXTURE = SMOOTH\n");
  fprintf(textdiskfile,"   AMBRFL  =    0.050    0.050    0.050\n");
  fprintf(textdiskfile,"   DIFRFL  =    0.050    0.050    0.050\n");
  fprintf(textdiskfile,"   SPCRFL  =    0.300    0.200    0.200\n");
  fprintf(textdiskfile,"   GLOSS   =   70.000\n");
  fprintf(textdiskfile,"   TRANS   =    0.900    0.800    0.800\n");
  fprintf(textdiskfile,"   INDEX   =    1.510\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"GROUND\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
}

void make()
{
  writestudio();
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ end wall }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -300.000  300.000    0.000\n");
  fprintf(textdiskfile,"   V1      =  600.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000    0.000  400.000\n");
  fprintf(textdiskfile,"   MATL    = MATTEWALL\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ left wall }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -300.000 -300.000    0.000\n");
  fprintf(textdiskfile,"   V1      =    0.000  600.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000    0.000  400.000\n");
  fprintf(textdiskfile,"   MATL    = MATTEWALL\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ right wall }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     =  300.000  300.000    0.000\n");
  fprintf(textdiskfile,"   V1      =    0.000 -600.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000    0.000  400.000\n");
  fprintf(textdiskfile,"   MATL    = MATTEWALL\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ ceiling }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -300.000  300.000  400.000\n");
  fprintf(textdiskfile,"   V1      =  600.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000 -600.000    0.000\n");
  fprintf(textdiskfile,"   MATL    = MATTEWALL\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ back wall }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     =  300.000 -300.000  400.000\n");
  fprintf(textdiskfile,"   V1      = -600.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000  600.000    0.000\n");
  fprintf(textdiskfile,"   MATL    = MATTEWALL\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ table }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"BOX\n");
  fprintf(textdiskfile,"   LOC     = -150.000 -100.000   80.000\n");
  fprintf(textdiskfile,"   V1      =  300.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000  200.000    0.000\n");
  fprintf(textdiskfile,"   V3      =    0.000    0.000   20.000\n");
  fprintf(textdiskfile,"   MATL    = ITALIANMARBLE\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ table stand }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"BOX\n");
  fprintf(textdiskfile,"   LOC     = -125.000  -75.000    0.000\n");
  fprintf(textdiskfile,"   V1      =  250.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000  150.000    0.000\n");
  fprintf(textdiskfile,"   V3      =    0.000    0.000   80.000\n");
  fprintf(textdiskfile,"   MATL    = ITALIANMARBLE\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ brass orb on table }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SPHERE\n");
  fprintf(textdiskfile,"   LOC     = -120.000  70.000  130.000\n");
  fprintf(textdiskfile,"   RADIUS  =   30.000\n");
  fprintf(textdiskfile,"   MATL    = BRASS\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ glass orb and base on table }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CYLINDER\n");
  fprintf(textdiskfile,"   BASELOC = -115.000  -65.000  100.000\n");
  fprintf(textdiskfile,"   BASERAD =   15.000\n");
  fprintf(textdiskfile,"   APEXLOC = -115.000  -65.000  125.000\n");
  fprintf(textdiskfile,"   MATL    = CHROME\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"CIRCLE\n");
  fprintf(textdiskfile,"   LOC     = -115.000  -65.000  125.000\n");
  fprintf(textdiskfile,"   V1      =    1.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000    1.000    0.000\n");
  fprintf(textdiskfile,"   RADIUS  =   15.000\n");
  fprintf(textdiskfile,"   MATL    = BLACKFELT\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"SPHERE\n");
  fprintf(textdiskfile,"   LOC     = -115.000  -65.000  160.000\n");
  fprintf(textdiskfile,"   RADIUS  =   35.000\n");
  fprintf(textdiskfile,"   MATL    = REDGLASS\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ wooden pyramid on table }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PYRAMID\n");
  fprintf(textdiskfile,"   LOC     =  100.000   50.000  100.000\n");
  fprintf(textdiskfile,"   V1      =   45.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000   45.000    0.000\n");
  fprintf(textdiskfile,"   HEIGHT  =  135.000\n");
  fprintf(textdiskfile,"   MATL    = OAKWOOD\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ chrome box on table }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"BOX\n");
  fprintf(textdiskfile,"   LOC     =   70.000  -70.000  100.000\n");
  fprintf(textdiskfile,"   V1      =   70.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000   40.000    0.000\n");
  fprintf(textdiskfile,"   V3      =    0.000    0.000   40.000\n");
  fprintf(textdiskfile,"   MATL    = CHROME\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ mirror on wall }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"PARALLELOGRAM\n");
  fprintf(textdiskfile,"   LOC     = -150.000  280.000  130.000\n");
  fprintf(textdiskfile,"   V1      =  300.000    0.000    0.000\n");
  fprintf(textdiskfile,"   V2      =    0.000    0.000  150.000\n");
  fprintf(textdiskfile,"   MATL    = MIRROR\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"{ lamps on ceiling }\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =  -100.000  -65.000  395.000\n");
  fprintf(textdiskfile,"   RADIUS  =   25.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.600    0.600    0.550\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"LAMP\n");
  fprintf(textdiskfile,"   LOC     =  100.000  -65.000  395.000\n");
  fprintf(textdiskfile,"   RADIUS  =   25.000\n");
  fprintf(textdiskfile,"   INTENS  =    0.600    0.600    0.550\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"\n");
  fprintf(textdiskfile,"ENDFRAME\n");
}

void main()
{
  strcpy(filename,"DESK.RT");
  clrscr();
  printf("Generating %s File\n",filename);
  printf("\n");
  printf("By Christopher D. Watkins\n");
  printf("\n");
  printf("\n");
  printf("Writing %d frames\n",numberofframes);
  textdiskfile=fopen(filename, "wt");
  writeheader();
  make();
  fclose(textdiskfile);
}