/*_______________________________________________________________

func-003.c

Function:  This program demonstrates how to generate sounds.

Compatibility:  The software uses the default text mode.

Remarks:  This program is intended as a framework upon which
software can be developed.  In its current form, the program
turns on the speaker, emits a tone, and turns off the speaker
on each occasion a sound is desired.  Rising or falling tones
are generated as a stairstepping action.  In order to
produce a smooth slide (such as a siren, for example), simply
modify this program so that the speaker is left on while
you manipulate the sound frequency (hertz).  The current
timing loops have been tested on an IBM PC.  You may wish to
slow down the loops if you are using a faster computer, such
as an XT, AT, or PS/2.

Copyright 1988 Lee Adams and TAB BOOKS Inc.

_________________________________________________________________


I N C L U D E    F I L E S                                       */

#include <dos.h>                   /* supports port manipulation */
#include <process.h>                  /* supports exit() routine */

/*_______________________________________________________________


D E C L A R A T I O N S                                          */

int hz=100;
void noise(int hertz,int duration);

/*_______________________________________________________________


M A I N    R O U T I N E                                         */

main(){

for (hz=50;hz<=1600;hz+=50)                     /* a rising tone */
noise(hz,5000);

for (hz=1;hz<=20000;hz++);                              /* pause */

for (hz=2000;hz>=250;hz-=50)                   /* a falling tone */
noise(hz,5000);

for (hz=1;hz<=6000;hz++);                               /* pause */

noise(40,30000);                                /* a single tone */

exit(0);}                                     /* end the program */

/*______________________________________________________________


SUBROUTINE: GENERATE A SOUND

Enter with frequency, expressed as hertz in the range
40 to 4660.  A comfortable frequency range for the human
ear is 40 to 2400.  Enter with duration, expressed as an
integer to be used in a simple for...next delay loop.            */

void noise(int hertz,int duration){
int t1=1,high_byte=0,low_byte=0;
short count=0;unsigned char old_port=0,new_port=0;

if (hertz<40) return;       /* avoid math overflow for int count */
if (hertz>4660) return;     /* avoid math underflow for low_byte */

count=1193180L/hertz;                   /* determine timer count */
high_byte=count/256;low_byte=count-(high_byte*256);

outportb(0x43,0xB6);                  /* prep the timer register */
outportb(0x42,low_byte);                    /* send the low byte */
outportb(0x42,high_byte);                  /* send the high byte */

old_port=inportb(0x61);         /* store the existing port value */
new_port=(old_port | 0x03);  /* use OR to set bits 0 and 1 to on */
outportb(0x61,new_port);                  /* turn on the speaker */
for (t1=1;t1<=duration;t1++);                            /* wait */
outportb(0x61,old_port);                 /* turn off the speaker */

return;}                                     /* return to caller */

/*_______________________________________________________________


End of source code                                               */



