/*** MODEM_IO.C ***/

#include <stdio.h>
#include <stdlib.h>
#include "pcl4c.h"
#include "ascii.h"
#include "term.cfg"
#include "modem_io.h"

#define FALSE 0
#define TRUE !FALSE
#define ONE_SECOND 18

/* NOTE: Requires AT COMMAND SET for all functions in this file */

#if AT_COMMAND_SET

#include <string.h>
#include <ctype.h>
#include "term_io.h"

int  BreakTest(void);

/*** send string to modem & get echo ***/

int SendTo(
  int  Port,       /* port to talk to */
  char *String)    /* string to send to modem */
{int i;
 char c;
 int Code;
 SioRxFlush(Port);
 SioDelay(ONE_SECOND/4);
 for(i=0;i<strlen(String);i++)
    {/* User BREAK ? */
     if(BreakTest()) return(FALSE);
     /* fetch character */
     c = toupper( String[i] );
     switch(c)
        {case '!':
            /* replace ! with carriage return */
            c = CR;
            break;
         case '~':
            /* delay 1/2 second */
            SioDelay(ONE_SECOND/2);
            c = ' ';
            break;
         case ' ':
            /* delay 1/4 second */
            SioDelay(ONE_SECOND/4);
            break;
        } /* end switch */
     /* transmit as 7 bit character */
     PutChar(Port,(char)(0x7f & c));
     /* delay 3/18th of a second */
     SioDelay(3);
     /* wait up to 1 second for the echo */
     Code = GetChar(Port,ONE_SECOND);
     /* echo char to display */
     if(Code>0) SioCrtWrite((char)Code);
    }
 return(TRUE);
} /* end SendTo */

void SayChar(char TheChar)
{if((TheChar>=' ')&&(TheChar<='~')) printf("'%c'",TheChar);
 else printf("%xH",TheChar);
}

int GetModemChar(int Port, int Tics)
{int Code;
 /* get next char not a CR or LF */
 while(1)
   {Code = GetChar(Port,Tics);
    if((Code>=0)&&((char)Code!=CR)&&((char)Code!=LF)) break;
   }
 return Code;
}

/*** wait for incoming string from modem ***/

int WaitFor(
  int  Port,     /* Port to talk to */
  char *String,  /* string to wait for */
  int  WaitTics) /* wait for 1st char */
{int i, k;
 char c;
 int Code;
 /* wait for string */
 SioCrtWrite(CR);
 SioCrtWrite(LF);
 for(i=0;i<strlen(String);i++)
   {/* User BREAK ? */
    if(BreakTest()) return(FALSE);
    c = String[i];
    /* wait for next character */
    if(i==0) Code = GetModemChar(Port,WaitTics);
    else Code = GetModemChar(Port,ONE_SECOND);
       /* printf("(\n%x)",Code);*/
    if(Code==-1) return(FALSE);
    SioCrtWrite((char)Code);
    /* char must match */
    if((char)Code != c)
      {printf("\nExpecting "); SayChar(c);
       printf(" not "); SayChar((char)Code);
       printf(" at %d\n",i);
       return(FALSE);
      }
   } /* end for(i) */
 /* more characters ? */
 while(1)
   {Code = GetChar(Port,ONE_SECOND/2);
    if(Code==-1) break;
    SioCrtWrite((char)Code);
   }
 return(TRUE);
} /* end WaitFor */

/*** enter command state ***/

/* NOTE: assumes escape char = '+' & guard time = 1 sec */

void CmdState(int Port)
{int i;
 /* delay a bit over 1 second */
 SioDelay(ONE_SECOND+ONE_SECOND/4);
 /* send Escape Code exactly 3 times */
 for(i=0;i<3;i++)
    {SioPutc(Port,'+');
     SioDelay(ONE_SECOND/4);
    }
 /* delay again */
 SioDelay(ONE_SECOND+ONE_SECOND/4);
} /* end CmdState */

/*** hangup phone (in command state) ***/

void Hangup(int Port)
{/* enter command state */
 CmdState(Port);
 /* hangup ! */
 SendTo(Port,"!AT!");
 SendTo(Port,"ATH0!");
} /* end Hangup */

/*** dial & wait for CONNECT ***/

int DialPhone(
  int  Port,     /* Port to talk to */
  char *String)  /* string to wait for */
{char Temp[80];
 /* send dial string */
 printf("...DIALING %s\n",String);
 strcpy(Temp,"!ATDT");
 strcat(Temp,String);
 strcat(Temp,"!");
 SendTo(Port,Temp);
 /* wait up to 60 seconds for CONNECT */
 if( WaitFor(Port,"CONNECT",60*ONE_SECOND) )
   {/* send lone CR */
    PutChar(Port,CR);
    return TRUE;
   }
 return FALSE;
} /* end DialPhone */

static int BreakTest(void)
{/* User BREAK ? */
 if(SioBrkKey())
    {printf("User BREAK\n");
     return(TRUE);
    }
 else return(FALSE);
} /* end BreakTest */
#endif
