;
;                           MEMBLOCK Integrity Check
;
;
; Borland C++ 4.0 for WIN32 prototype:
; BOOL  __pascal mbcheck (MEMBLOCK *mb);
;
; Returns:      NULL    - Invalid MEMBLOCK (or uninitalized)
;               1       - Valid MEMBLOCK
;
; version 0.4
; - White Shadow -
;
.386p
Ideal
include "bmmalloc.inc"

Public MBCHECK


;
Segment _TEXT byte public use32 'CODE'
Assume  cs:_TEXT, ds:DGROUP


; -- argument stack offsets
arg1 = 0                ; -> MEMBLOCK

MBCHECK:        push ebx
pct = (4)+(1*4)

                ;-- Load MEMBLOCK info
                mov  eax, [esp+pct+arg1]        ; -> MEMBLOCK
                mov  ebx, [eax+MEMBLOCK.base]   ; linear adx of MEMBLOCK
                sub  ebx, [_database]           ; relative ofs to DGROUP
                mov  edx, [eax+MEMBLOCK.size]
                add  edx, ebx

                ;-- Is MEMBLOCK uninitalized (size zero)?
                cmp  edx, ebx
                je   ExitNull

If DebugMode    ;-- Check MBSig
                cmp  [dword ebx], MBSig
                jne  ExitNull                   ; Invalid MBSig?
                add  ebx, MBSigSize             ; -> first node
EndIf

                ;-- Init Last MemNode Avl Flag
                xor  ecx, ecx                   ; last node was NOT avl

;---------------

MemNodeLoop:
; ebx -> MemNode to check
; edx -> final byte of MEMBLOCK + 1
; ecx - if 0 - last node was NOT Avl

                mov  eax, [ebx+MemNode.size]

If DebugMode    ;-- Check Node
                xor  eax, NodeSigKey
                cmp  [ebx+MemNode.sig], eax
                jne  InvlMemNode
                xor  eax, NodeSigKey
EndIf
                ;-- Last node avl?
                or   ecx, ecx
                jz   DoneAvlChk

                ;-- This node avl also?
                test eax, 80000000h
                jz   InvlMemNode

DoneAvlChk:     ;-- Set avl flag
                mov  ecx, eax
                shr  ecx, 31
                xor  cl, 1                      ; complement avl bit

                ;-- Point to next node
                and  eax, 7fffffffh             ; clear avl bit
                add  ebx, size MemNode
                add  ebx, eax

                ;-- Any more nodes to check?
                cmp  ebx, edx
                jb   MemNodeLoop             ; more nodes...
                ja   InvlMemNode             ; past end adx!

;---------------

                ;-- All nodes ok; send good exit
                mov  eax, 1
                jmp  short Exit

;---------------

ExitNull:       xor  eax, eax

;---------------

Exit:           pop  ebx
                ret  4                          ; 1 arg

;---------------

InvlMemNode:
If DebugMode    ;-- Invalidate MEMBLOCK
                mov  ebx, [esp+pct+arg1]        ; -> MEMBLOCK
                mov  ebx, [ebx+MEMBLOCK.base]   ; linear adx of MEMBLOCK
                sub  ebx, [_database]           ; relative ofs to DGROUP
                mov  [dword ebx], MBSigInvl
EndIf
                jmp  short ExitNull


;
EndS            _TEXT
End
