/*===========================================================================*\
| PULLDATA.C - User Statistics for data-entry windows.      ver 2.0, 04-15-89 |
|                                                                             |
| This file contains all the data to configure the data-entry fields in       |
| data windows or work windows.                                               |
|   Copyright (c) 1989 James H. LeMay, All rights reserved.                   |
|   Conversion to Turbo C by Jordan Gallagher / Wisdom Research               |
\*===========================================================================*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <ctype.h>

#include "pullc20.h"
#include "pulldemo.h"

/*================ Set up variables for data windows here: ==================*\
| Place your variables names here to interface with the menus.                |
| Be careful of strings that are too large.  They can be no larger than       |
| DATA_STR_SIZE.                                                              |
\*---------------------------------------------------------------------------*/

unsigned char aubyte     = 129;
char          abyte      = -10;
int           aint       = -31456;
unsigned int  auint      = 50000u;
long          along      = -123456789L;
double        adouble    = -24.3456E06;
char          ahex[5]    = "FF03";
char          achar      = 'Q';
crtstr_t      astring    = "This is a string";

unsigned char aubyte2    = 219;
char          abyte2     = -34;
int           aint2      = -1100;
unsigned int  auint2     = 45600u;
long          along2     = -98765432L;
double        adouble2   = -19.07070e12;
char          ahex2[5]   = "FFFF";
char          achar2     = 'W';
crtstr_t      astring2   = "This is another string";

unsigned char seats      =      4;
unsigned char years      =     30;
unsigned char month      =      1;
unsigned char day        =     12;
int           year       =   1989;
int           pricelimit =   2000;

char pathname[67];                  /* for the pull-down directory */
unsigned char dataentryoattr;       /* output attribute */
unsigned char dataentryiattr;       /* input  attribute */
unsigned char datawndwiattr;        /* input  attribute */
unsigned char datawndwoattr;        /* output attribute */
unsigned char datawndwbattr;        /* border attribute */
unsigned int  datawndwbrdr;

#ifdef USE_MSGLINE_CODE
/*=============================| geterrmsgs |===============================*\
\*==========================================================================*/
void geterrmsgs(void)
{
    autonumlock = 0;    /* if 1, turns NumLock on with data entry */
    capslockcol = 41;   /* first column for " CAPS NUM SCROLL " on msgline. */

    strcpy( errmsgline[INVALID_EM], " Invalid entry.             ESC-ack"
                                    "nowledge"                             );
    strcpy( errmsgline[PATH_EM],    " Invalid path.  Use [d:][path].  Pr"
                                    "ess ESC."                             );
    strcpy( errmsgline[REAL_EM],    " Range: <=4.0e12            ESC-ack"
                                    "nowledge"                             );
    strcpy( errmsgline[CHAR_EM],    " \"?\" not allowed            ESC-a"
                                    "cknowledge"                           );
    strcpy( errmsgline[STR_EM],     " At least 3 chars required. ESC-ack"
                                    "nowledge"                             );
}
#endif

/*=============================| makeerrmsg |===============================*\
\*==========================================================================*/
void makeerrmsg( unsigned long low, unsigned long high, char sign )
{
    char tmp[34];
#ifdef USE_MSGLINE_CODE
    datapad.errmsg = USER_EM;
    strcpy( errmsgline[USER_EM], "Range: " );
    if(sign)
        strcat( errmsgline[USER_EM], ltoa(low,tmp,10) );
    else
        strcat( errmsgline[USER_EM], ultoa(low,tmp,10) );
    strcat( errmsgline[USER_EM], " to " );
    if(sign)
        strcat( errmsgline[USER_EM], ltoa(high,tmp,10) );
    else
        strcat( errmsgline[USER_EM], ultoa(high,tmp,10) );
    strcat( errmsgline[USER_EM], ".  Press ESC" );
#endif
}

/*====================== Data entry range checking ==========================*\
| These functions are completely defined by the user.  They may not even be   |
| necessary if the string entered is satisfactory as a valid number.          |
| "translate" can alter each key from the keyboard before it gets evaluated.  |
| "verify" will check the range or even completely alter the entire string.   |
\*---------------------------------------------------------------------------*/

void verifypath(void)
{
    if(chdir(strdata(datapad))!=0) {    /* invalid directory */
        datapad.errmsg = PATH_EM;
        strcpy( pathname, "A:\\" );
        pathname[0]+=getdisk();
        getcurdir( 0, pathname+3 );     /* have DOS parrot the path name */
    } else {
        if(strdata(datapad)[1]==':') {
            setdisk( toupper(strdata(datapad)[0])-'A' );
        }
    }
}

void verifyfilemask(void)
{
    if(strdata(datapad)[0]==0)
        strcpy(strdata(datapad),"*.*");
}

void verifypricelimit(void)
{
    if(intdata(datapad) > 25000 || intdata(datapad) <= 0)
        makeerrmsg( 1, 25000, 1 );
}

void verifymonth(void)
{
    if(ubytedata(datapad)==0 || ubytedata(datapad) > 12)
        makeerrmsg( 1, 12, 0 );
}

void verifyday(void)
{
    if(ubytedata(datapad)==0 || ubytedata(datapad) > 31)
        makeerrmsg( 1, 31, 0 );
}

void verifyyear(void)
{
    if(intdata(datapad) < 1960 || intdata(datapad) > 2010)
        makeerrmsg( 1960, 2010, 1 );
}

void verifyyears(void)
{
    if(intdata(datapad) < 4 || intdata(datapad) > 30)
        makeerrmsg( 4, 30, 1 );
}

/*-------------------- Work window data entry checking ----------------------*/

void translatecase(void)
{
    if(!extkey)
        key = toupper(key);        /* simple upper case translation */
}

void verifybyte2(void)
{
    if(bytedata(datapad) > 101 || bytedata(datapad) < -50)
        makeerrmsg( -50, 101, 1 );
}

void verifyubyte2(void)
{
    if(ubytedata(datapad) > 200 || ubytedata(datapad)==0)
        makeerrmsg( 1, 200, 0 );
}

void verifyint2(void)
{
    if(intdata(datapad) > 20000 || intdata(datapad) < -10000)
        makeerrmsg( -10000, 20000, 1 );
}

void verifyuint2(void)
{
    if(uintdata(datapad) > 45000u || uintdata(datapad)==0)
        makeerrmsg( 1, 45000u, 0 );
}

void verifylong2(void)
{
    if(longdata(datapad) > 850000L || longdata(datapad) < -1000000L)
        makeerrmsg( -1000000L, 850000L, 1 );
}

void verifydouble2(void)
{
    if(doubledata(datapad) > 4.0e12)
        datapad.errmsg = REAL_EM;
}

void verifychar2(void)
{
    if(chardata(datapad) == '?')
        datapad.errmsg = CHAR_EM;
}

void verifystring2(void)
{
    if(strlen(strdata(datapad)) <3)
        datapad.errmsg = STR_EM;
}


/*=========================| getdataentrystats |============================*\
| The major configurations for all menus go here.  The program clears        |
| all values to 0.  The code below will set new values.  Therefore, clearing |
| the values of variables is unnecessary.                                    |
\*==========================================================================*/
void getdataentrystats(void)
{
    /*------------ Set up your pull-down data windows here: -----------------*\
      Justification will default with numbers right justified and strings to
      the left if none is specified.
    */

    getdatawndw(UBYTES_DW);                /* just gets cleared topdatawndw */
    topdatawndw.entry.varaddr       = &aubyte;
    topdatawndw.entry.typeofdata    = UNSIGNED_BYTES;
    topdatawndw.entry.field         = 3;
    topdatawndw.entry.setname       = NO_SET;
 /* topdatawndw.entry.justify_output = RIGHT; */     /* this is the default */
 /* topdatawndw.entry.msglinenum    = DE_ML; */      /* this is the default */
    topdatawndw.entry.helpwndwnum   = NUMERIC_HW;
    savedatawndw();                                 /* saves it in the heap */

    getdatawndw(INTS_DW);
    topdatawndw.entry.varaddr       = &aint;
    topdatawndw.entry.typeofdata    = INTS;
    topdatawndw.entry.field         = 6;
    topdatawndw.entry.setname       = NO_SET;
    topdatawndw.entry.helpwndwnum   = NUMERIC_HW;
    savedatawndw();

    getdatawndw(UINTS_DW);
    topdatawndw.entry.varaddr       = &auint;
    topdatawndw.entry.typeofdata    = UNSIGNED_INTS;
    topdatawndw.entry.field         = 5;
    topdatawndw.entry.setname       = NO_SET;
    topdatawndw.entry.helpwndwnum   = NUMERIC_HW;
    savedatawndw();

    getdatawndw(LONGS_DW);
    topdatawndw.entry.varaddr       = &along;
    topdatawndw.entry.typeofdata    = LONGS;
    topdatawndw.entry.field         = 11;
    topdatawndw.entry.setname       = NO_SET;
    topdatawndw.entry.helpwndwnum   = NUMERIC_HW;
    savedatawndw();

    getdatawndw(DOUBLES_DW);
    topdatawndw.entry.varaddr       = &adouble;
    topdatawndw.entry.typeofdata    = DOUBLES;
    topdatawndw.entry.field         = 17;
    topdatawndw.entry.setname       = NO_SET;
    topdatawndw.entry.precision     = 13;
    topdatawndw.entry.helpwndwnum   = NUMERIC_HW;
    savedatawndw();

    getdatawndw(CHARS_DW);
    topdatawndw.entry.varaddr       = &achar;
    topdatawndw.entry.typeofdata    = CHARS;
    topdatawndw.entry.field         = 1;
    topdatawndw.entry.setname       = NO_SET;
    topdatawndw.entry.helpwndwnum   = TEXT_HW;
    savedatawndw();

    getdatawndw(HEX_DW);
    topdatawndw.entry.varaddr       = &ahex;
    topdatawndw.entry.typeofdata    = USERNUMS;
    topdatawndw.entry.field         = 4;
    topdatawndw.entry.setname = HEX_SET; /* specify set name for custom sets */
    topdatawndw.entry.translatefunc = translatecase;
    topdatawndw.entry.helpwndwnum   = NUMERIC_HW;
    savedatawndw();

    getdatawndw(STRINGS_DW);
    strcpy( topdatawndw.title, "Enter string" );
    topdatawndw.entry.varaddr       = &astring;
    topdatawndw.entry.typeofdata    = STRINGS;
    topdatawndw.entry.field         = 25;
    topdatawndw.entry.setname       = NO_SET;
    topdatawndw.entry.maxfield      = sizeof(astring)-1;
 /* topdatawndw.entry.justify_output = LEFT; this is the default for strings */
    topdatawndw.entry.helpwndwnum   = TEXT_HW;
    savedatawndw();

    getdatawndw(PATH_DW);
    strcpy( topdatawndw.title, "Enter path" );
    topdatawndw.entry.varaddr       = &pathname;
    topdatawndw.entry.typeofdata    = STRINGS;
    topdatawndw.entry.field         = 40;
    topdatawndw.entry.maxfield      = sizeof(pathname)-1;
    topdatawndw.entry.setname       = PATH_SET;
    topdatawndw.entry.checkrangefunc= verifypath;
    topdatawndw.entry.helpwndwnum   = TEXT_HW;
    savedatawndw();

    getdatawndw(FILEMASK_DW);
    strcpy( topdatawndw.title, "Enter Mask" );
    topdatawndw.entry.varaddr       = &filemask;
    topdatawndw.entry.typeofdata    = STRINGS;
    topdatawndw.entry.field         = 12;
    topdatawndw.entry.setname       = NO_SET;
    topdatawndw.entry.maxfield      = sizeof(filemask)-1;
    topdatawndw.entry.setname       = MASK_SET;
    topdatawndw.entry.checkrangefunc= verifyfilemask;
    topdatawndw.entry.helpwndwnum   = TEXT_HW;
    savedatawndw();

    getdatawndw(SEATS_DW);
    topdatawndw.entry.varaddr       = &seats;
    topdatawndw.entry.typeofdata    = UNSIGNED_BYTES;
    topdatawndw.entry.field         = 2;
    topdatawndw.entry.setname       = NO_SET;
    topdatawndw.entry.helpwndwnum   = NUMERIC_HW;
    savedatawndw();

    getdatawndw(PRICE_DW);
    topdatawndw.entry.varaddr       = &pricelimit;
    topdatawndw.entry.typeofdata    = INTS;
    topdatawndw.entry.field         = 6;
    topdatawndw.entry.setname       = NO_SET;
    topdatawndw.entry.helpwndwnum   = NUMERIC_HW;
    savedatawndw();

    getdatawndw(MONTH_DW);
    topdatawndw.entry.varaddr       = &month;
    topdatawndw.entry.typeofdata    = UNSIGNED_BYTES;
    topdatawndw.entry.field         = 2;
    topdatawndw.entry.setname       = NO_SET;
    topdatawndw.entry.checkrangefunc= verifymonth;
    topdatawndw.entry.helpwndwnum   = NUMERIC_HW;
    savedatawndw();

    getdatawndw(DAY_DW);
    topdatawndw.entry.varaddr       = &day;
    topdatawndw.entry.typeofdata    = UNSIGNED_BYTES;
    topdatawndw.entry.field         = 2;
    topdatawndw.entry.setname       = NO_SET;
    topdatawndw.entry.checkrangefunc= verifyday;
    topdatawndw.entry.helpwndwnum   = NUMERIC_HW;
    savedatawndw();

    getdatawndw(YEAR_DW);
    topdatawndw.entry.varaddr       = &year;
    topdatawndw.entry.typeofdata    = INTS;
    topdatawndw.entry.field         = 4;
    topdatawndw.entry.setname       = NO_SET;
    topdatawndw.entry.checkrangefunc= verifyyear;
    topdatawndw.entry.helpwndwnum   = NUMERIC_HW;
    savedatawndw();

    getdatawndw(YEARS_DW);
    topdatawndw.entry.varaddr       = &years;
    topdatawndw.entry.typeofdata    = UNSIGNED_BYTES;
    topdatawndw.entry.field         = 2;
    topdatawndw.entry.setname       = NO_SET;
    topdatawndw.entry.checkrangefunc= verifyyears;
    topdatawndw.entry.helpwndwnum   = NUMERIC_HW;
    savedatawndw();

    /*----------------------- Work window data entry ------------------------*/
    autotab = 1;       /* after entry, tabs to next one in sequence */

    if(qvideo_mode==MONO)
         datapad.hattr = LIGHTGRAY_BG;
    else datapad.hattr = WHITE+CYAN_BG; /* optional attribute of data entry
                                           hilite - use SAMEATTR if not
                                           desired
                                        */
    getdataentry(ABYTE2_DE);
    topentry.varaddr     = &abyte2;
    topentry.typeofdata  = BYTES;
    topentry.row         = 14;
    topentry.col         = 20;
    topentry.field       = 4;
    topentry.setname     = NO_SET;
    topentry.maxfield    = 3;
    topentry.checkrangefunc = verifybyte2;
 /* topentry.msglinenum  = DE_ML; */        /* this is the default */
    topentry.helpwndwnum = NUMERIC_HW;
    savedataentry();

    getdataentry(AUBYTE2_DE);
    topentry.varaddr     = &aubyte2;
    topentry.typeofdata  = UNSIGNED_BYTES;
    topentry.row         = 15;
    topentry.col         = 20;
    topentry.field       = 4;
    topentry.setname     = NO_SET;
    topentry.checkrangefunc = verifyubyte2;
    topentry.helpwndwnum = NUMERIC_HW;
    savedataentry();

    getdataentry(AINT2_DE);
    topentry.varaddr     = &aint2;
    topentry.typeofdata  = INTS;
    topentry.row         = 16;
    topentry.col         = 20;
    topentry.field       = 6;
    topentry.setname     = NO_SET;
    topentry.checkrangefunc = verifyint2;
    topentry.helpwndwnum = NUMERIC_HW;
    savedataentry();

    getdataentry(AUINT2_DE);
    topentry.varaddr     = &auint2;
    topentry.typeofdata  = UNSIGNED_INTS;
    topentry.row         = 17;
    topentry.col         = 20;
    topentry.field       = 6;
    topentry.setname     = NO_SET;
    topentry.checkrangefunc = verifyuint2;
    topentry.helpwndwnum = NUMERIC_HW;
    savedataentry();

    getdataentry(ALONG2_DE);
    topentry.varaddr     = &along2;
    topentry.typeofdata  = LONGS;
    topentry.row         = 18;
    topentry.col         = 20;
    topentry.field       = 12;
    topentry.setname     = NO_SET;
    topentry.checkrangefunc = verifylong2;
    topentry.helpwndwnum = NUMERIC_HW;
    savedataentry();

    getdataentry(ADOUBLE2_DE);
    topentry.varaddr     = &adouble2;
    topentry.typeofdata  = DOUBLES;
    topentry.row         = 19;
    topentry.col         = 20;
    topentry.field       = 17;
    topentry.setname     = NO_SET;
    topentry.precision   = 14;
    topentry.checkrangefunc = verifydouble2;
    topentry.helpwndwnum = NUMERIC_HW;
    savedataentry();

    getdataentry(AHEX2_DE);
    topentry.varaddr     = &ahex2;
    topentry.typeofdata  = USERNUMS;
    topentry.row         = 14;
    topentry.col         = 50;
    topentry.field       = 4;
    topentry.setname     = NO_SET;
    topentry.setname     = HEX_SET;
    topentry.translatefunc = translatecase;
    topentry.helpwndwnum = NUMERIC_HW;
    savedataentry();

    getdataentry(ACHAR2_DE);
    topentry.varaddr     = &achar2;
    topentry.typeofdata  = CHARS;
    topentry.row         = 15;
    topentry.col         = 50;
    topentry.field       = 1;
    topentry.setname     = NO_SET;
    topentry.checkrangefunc = verifychar2;
    topentry.helpwndwnum = TEXT_HW;
    savedataentry();

    getdataentry(ASTRING2_DE);
    topentry.varaddr     = &astring2;
    topentry.typeofdata  = STRINGS;
    topentry.row         = 16;
    topentry.col         = 50;
    topentry.field       = 20;
    topentry.setname     = NO_SET;
    topentry.maxfield    = sizeof(astring2)-1;
    topentry.checkrangefunc = verifystring2;
    topentry.helpwndwnum = TEXT_HW;
    savedataentry();

    getdataentry(FILENAME_DE);
    topentry.varaddr     = &filename;
    topentry.typeofdata  = STRINGS;
    topentry.row         = 17;
    topentry.col         = 50;
    topentry.field       = 12;
    topentry.setname     = NO_SET;
    topentry.maxfield    = sizeof(filename)-1;
    topentry.setname     = FILENAME_SET;
    topentry.helpwndwnum = TEXT_HW;
    savedataentry();
}

/*=================== Data entry initialization code ========================*\
| The following code initializes all of the stats for the data entry windows  |
| and the work window data entry fields.  There is no need to edit this       |
| except for the default colors in setdefaultcolors.                          |
\*---------------------------------------------------------------------------*/

/*============================| allocateheap |==============================*\
\*==========================================================================*/
void allocateheap(void)
{
    if(heapok(NUM_OF_DATA_WNDWS*sizeof(datawndw_t)))
        datawndw=calloc( NUM_OF_DATA_WNDWS, sizeof(datawndw_t) );
    if(heapok(NUM_OF_DATA_ENTRIES*sizeof(dataentry_t)))
        dataentry=calloc( NUM_OF_DATA_ENTRIES, sizeof(dataentry_t) );
}

/*==========================| setdefaultcolors |============================*\
\*==========================================================================*/
void setdefaultcolors(void)
{
    /*------------------ set up your colors and borders here: ---------------*/
    if(qvideo_mode==MONO) {
        dataentryiattr = LIGHTGRAY;        /* input  attribute */
        dataentryoattr = WHITE;            /* output attribute */
        datawndwiattr  = WHITE;            /* input  attribute */
        datawndwoattr  = LIGHTGRAY_BG;     /* output attribute */
    } else {
        dataentryiattr = YELLOW+MAGENTA_BG;  /* input  attribute */
        dataentryoattr = BLACK+LIGHTGRAY_BG; /* output attribute */
        datawndwiattr  = BLACK+BROWN_BG;     /* input  attribute */
        datawndwoattr  = YELLOW+BLACK_BG;    /* output attribute */
    }
    datawndwbattr  = BLACK+BROWN_BG;     /* border attribute */
    datawndwbrdr   = HDOUBLE_BORDER;
}

/*===========================| initdatacolors |=============================*\
\*==========================================================================*/
void initdatacolors(void)
{
    int i;

    for(i=0; i<NUM_OF_DATA_WNDWS; i++) {
        getdatawndw( i );
        topdatawndw.entry.iattr = datawndwiattr;   /* input  attribute */
        topdatawndw.entry.oattr = datawndwoattr;   /* output attribute */
        topdatawndw.battr       = datawndwbattr;   /* border attribute */
        savedatawndw();
    }

    for(i=0; i<NUM_OF_DATA_ENTRIES; i++) {
          getdataentry( i );
          topentry.iattr = dataentryiattr;  /* input  attribute */
          topentry.oattr = dataentryoattr;  /* output attribute */
          savedataentry();
    }
}

/*=============================| getjustify |===============================*\
\*==========================================================================*/
int getjustify( int justify, int tod )
{
    if(justify==NO_DIR) {
        if(tod<=USERNUMS)
             return(RIGHT);        /* for nums */
        else return(LEFT);         /* for chars and strings */
    } else
        return(justify);
}

/*=============================| getsetname |===============================*\
\*==========================================================================*/
int getsetname( int sn, int tod )
{
    if(sn==NO_SET)
        switch(tod) {
            case UNSIGNED_BYTES:
            case UNSIGNED_INTS:  
            case UNSIGNED_LONGS: return(UNSIGNED_SET);
            case BYTES:
            case INTS:
            case LONGS:          return(SIGNED_SET);
            case FLOATS:
            case DOUBLES:        return(FLOAT_SET);
            default:             return(CHAR_SET);
        }
    else
        return(sn);
}

/*==========================| initdatadefaults |============================*\
\*==========================================================================*/
void initdatadefaults(void)
{
    int i;

    for(i=0; i<NUM_OF_DATA_WNDWS; i++) {
        getdatawndw(i);
        topdatawndw.border = datawndwbrdr;
        topdatawndw.entry.setname = getsetname( topdatawndw.entry.setname,
                                                topdatawndw.entry.typeofdata );
        topdatawndw.entry.row = 1;
        topdatawndw.entry.col = 2;
        if(topdatawndw.entry.maxfield==0)
            topdatawndw.entry.maxfield = topdatawndw.entry.field;
        topdatawndw.entry.justify_output = getjustify(
                                           topdatawndw.entry.justify_output,
                                           topdatawndw.entry.typeofdata );
        if(topdatawndw.entry.msglinenum==0)
            topdatawndw.entry.msglinenum = DW_ML;
        savedatawndw();
    }

    for(i=0; i<NUM_OF_DATA_ENTRIES; i++) {
        getdataentry(i);
        topentry.setname = getsetname( topentry.setname, topentry.typeofdata );
        if(topentry.maxfield==0)
            topentry.maxfield = topentry.field;
        topentry.justify_output = getjustify( topentry.justify_output,
                                              topentry.typeofdata );
        if(topentry.msglinenum==0)
            topentry.msglinenum = DE_ML;
        savedataentry();
    }
}

/*============================| initpulldata |==============================*\
\*==========================================================================*/
void initpulldata(void)
{
    allocateheap();
    setdefaultcolors();
    initdatacolors();
#ifdef USE_MSGLINE_CODE
    geterrmsgs();
#endif
    getdataentrystats();
    initdatadefaults();
}
