/*===========================================================================*\
| PULLDEMO.H - Header file for PULLC demo                   ver 2.0, 04-15-89 |
|                                                                             |
| This file contains all of the prototypes, macros, enums,                    |
| typedefs and externs for PULLDEMO.C.                                        |
|   Copyright (c) 1989 by James H. LeMay, All rights reserved.                |
|   Conversion to Turbo C by Jordan Gallagher / Wisdom Research               |
\*===========================================================================*/

#undef MULTIWORKWNDWS             /* Change this to "#undef" to exclude code
                                     for multiple work windows in PULLWORK.C */

/*===========================================================================*\
                           PULLSTAT declarations
\*===========================================================================*/

/* Any of the keys can be modified. POPKEY and TOPKEY1 are defined in *\
\* PULLC20.H.                                                         */

#define ALTF 33   /* Files menu */
#define ALTC 46   /* Colors menu */
#define ALTA 30   /* AutoParts menu */
#define ALTE 18   /* EnterData menu */
#define ALTO 24   /* Options menu */
#define ALTU 22   /* Utilities menu */
#define ALTI 23   /* IRSaccounting menu */
#define ALTQ 16   /* Quit menu */
#define ALTD 32   /* Directory menu */
#define ALTP 25   /* Path data entry */
#define ALTX 45   /* Immediately exit program */
#define ALT1 120  /* For work window 1 */
#define ALT2 121  /* For work window 2 */

/*------------------ Set up your menu names here in order: ----------------*/
/* This is optional, but it sure helps you in not only understanding the
   program, but also makes it unquestionably easier to rearrange.
*/

enum mainmenunames {
    FILES_MENU,    COLOR_MENU,     AUTO_PARTS_MENU,  ENTER_DATA_MENU,
    OPTIONS_MENU,  UTILITIES_MENU, IRS_MENU,         QUIT_MENU,
    NO_MAIN_MENU=255
};

#ifdef USE_SUBMENU_CODE
enum submenunames {
    TIRES_MENU,    RADIO_MENU,     UPDATE_MENU,      DATE_MENU,
    BRANDS_MENU,
    NO_SUB_MENU=255
};
#endif

#ifdef USE_DATAENTRY_CODE
enum datawndwnames {
    UBYTES_DW,   UINTS_DW,    INTS_DW,     LONGS_DW,    DOUBLES_DW,
    HEX_DW,      CHARS_DW,    STRINGS_DW,  PATH_DW,     FILEMASK_DW,
    SEATS_DW,    PRICE_DW,    MONTH_DW,    DAY_DW,      YEAR_DW,
    YEARS_DW,
    NO_DW=255
};
#endif

#ifdef USE_MSGLINE_CODE
enum msglinenames {
    WORK_ML,  TOP_ML,   ALT_ML,   MAIN_ML,  SUB_ML,   DW_ML,    DE_ML,
    SEQ_ML,   HELP_ML,  FUNC_ML,  DIR_ML,
    NO_ML=0xFF
};
#endif

#ifdef USE_HELPWNDW_CODE
enum helpwndwnames {
    WORKWNDW_HW,       TOPLINE_HW,        FILESMENU_HW,      DIRMENU_HW,
    BRANDSMENU_HW,     ENTERDATAMENU_HW,  IRSMENU_HW,        DATEMENU_HW,
    UPDATEMENU_HW,     EXECCHOICE_HW,     SINGLECHOICE_HW,   MULTIPLECHOICE_HW,
    NUMERIC_HW,        TEXT_HW,
    NO_HW=255
};

enum helplinenames {                /* HL - helpline;  L  - last */
    HL_W1, HL_W2, HL_W3, HL_W4, HL_W5,  HL_W6,      /* work window */
           HL_W7, HL_W8, HL_W9, HL_W10, HL_WL,
    HL_T1, HL_TL,                                   /* top menu */
    HL_B1, HL_B2, HL_B3, HL_B4, HL_B5,  HL_BL,      /* brands submenu */
    HL_F1, HL_F2, HL_F3, HL_F4, HL_F5,  HL_F6,      /* files submenu */
           HL_F7, HL_F8, HL_F9, HL_F10, HL_FL,
    HL_DIR1, HL_DIR2, HL_DIR3, HL_DIR4, HL_DIR5,    /* directory submenu */
             HL_DIR6, HL_DIR7, HL_DIR8, HL_DIR9,
             HL_DIRL,
    HL_E1, HL_E2,  HL_E3,  HL_E4,  HL_E5,  HL_E6,   /* enter data submenu */
           HL_E7,  HL_E8,  HL_E9,  HL_E10, HL_E11,
           HL_E12, HL_E13, HL_E14, HL_E15, HL_E16,
           HL_EL,
    HL_I1, HL_I2, HL_IL,                            /* IRS menu */
    HL_D1, HL_D2, HL_D3, HL_DL,                     /* date submenu */
    HL_U1, HL_U2, HL_UL,                            /* update submenu */
    HL_X1, HL_X2, HL_XL,                            /* execute choice menu */
    HL_S1, HL_S2, HL_SL,                            /* single choice menu */
    HL_M1, HL_M2, HL_ML,                            /* multiple choice menu */
    HL_N1, HL_N2, HL_N3, HL_N4, HL_N5, HL_N6,       /* numeric data */
           HL_NL,
    HL_TX1, HL_TX2, HL_TX3, HL_TX4, HL_TX5,         /* text data */
            HL_TXL,
    NO_HL=255
};
#endif

extern char filename[13];


/*===========================================================================*\
                           PULLDATA declarations
\*===========================================================================*/

extern char pathname[67];

enum dataentrynames {
    ABYTE2_DE,
    AUBYTE2_DE,
    AINT2_DE,
    AUINT2_DE,
    ALONG2_DE,
    ADOUBLE2_DE,
    AHEX2_DE,
    ACHAR2_DE,
    ASTRING2_DE,
    FILENAME_DE,
    NO_DE=255
};

/*---------------- Set up your error message lines here: ------------------*\
| Error messages are used for indicating that data entry was invalid or out |
| of range.  errmsgline[0] is reserved for custom error messages that you   |
| can create at runtime.  Messages up to INVALID_EM are reserved.           |
\*-------------------------------------------------------------------------*/
enum errmsgnames {
    USER_EM,
    INVALID_EM,
    PATH_EM,
    REAL_EM,
    CHAR_EM,
    STR_EM,
    NO_EM=255
};


/*===========================================================================*\
                            PULLDIR declarations
\*===========================================================================*/

#define FNAMESIZE 13      /* Size of a filename string variable */
#define MAXFILES 250      /* Size as large as you want your heap to be
                             available.   Uses 15 bytes per file name. */

typedef struct {
    char title[9];
    unsigned char menulines;
    unsigned char row,col,rows,cols;
    unsigned char hiliteline;
    unsigned char battr,wattr,hattr;
    int border;
    unsigned char msglinenum,helpwndwnum;
} dirmenu_t;

extern dirmenu_t dirmenu;
extern char filemask[FNAMESIZE];

/*  ----------   Prototypes from PULLSTAT.C   -----------  */

void getmainmenu( int name );
void savemainmenu(void);
void getsubmenu( int name );
void savesubmenu(void);
void sethelplines( int name, int first, int last );
void dummyfunc(void);
void gotodir(void);
void dodir(void);
void setquit(void);
void processthenpop(void);
void popthenprocess(void);
void popprocessandpull(void);
void popnumoflevels(void);
void poptonewmenu(void);
void datemenu1(void);
void datemenu2(void);
void datemenu3(void);
void getuserpullstats(void);
void getoverridestats(void);
void setworkwndw( int wn );
void checkglobalkeys(void);
void initpullstat(void);

/*  ----------   Prototypes from PULLDATA.C   -----------  */

void geterrmsgs(void);
void makeerrmsg( unsigned long low, unsigned long high, char sign );
void verifypath(void);
void verifyfilemask(void);
void verifypricelimit(void);
void verifymonth(void);
void verifyday(void);
void verifyyear(void);
void verifyyears(void);
void translatecase(void);
void verifybyte2(void);
void verifyubyte2(void);
void verifyint2(void);
void verifyuint2(void);
void verifylong2(void);
void verifydouble2(void);
void verifychar2(void);
void verifystring2(void);
void getdataentrystats(void);
void allocateheap(void);
void setdefaultcolors(void);
void initdatacolors(void);
int getjustify( int justify, int tod );
int getsetname( int sn, int tod );
void initdatadefaults(void);
void initpulldata(void);

/*  ----------   Prototypes from PULLDIR.C   -----------  */

void removespaces( char *str );
void dirqsort( int lower, int upper );
void sortdirectory(void);
void findfilenames(char *pathmask);
void getdirfilenames(void);
void showfilenames( int fli_new );
void maxpositive( int *num, int nummax );
void repositionlist( int fli_new, int hl_new );
void centernames( int *fli_new, int *hl_new, unsigned index );
void centerhilite(unsigned char mls, int *hl_new, int *fli_new);
void findclosematch( char *nametohilite, char *fn1, char *fn2, char *des,
                     int *index);
void showdirmenu( char *nametohilite );
void scandirbycursor(void);
void scandirbyletter(void);
void pulldirectory( char *nametochange, char *nametohilite );

/*  ----------   Prototypes from PULLWORK.C   -----------  */

void resetworkwndwstep(void);
void hideworkwndw(void);
void accessworkwndw( int wn );
void kbdidle(void);
void showfields(void);
void makeworkwndw2(void);
void editfields(void);
void initworkwndws(void);
void workwndw(void);
void initpullwork(void);

/*  ----------   Prototypes from MODNAME.C   -----------  */

void modfilename(void far *asciiz, void far *st);

