include qlib.inc
include string.inc
include stdio.inc
include stdlib.inc

.data
h1 dd ?
h2 dd ?
h3 dd ?
t1 dd ?
r1 REAL8 ?
r2 REAL8 ?
gig REAL8 1073741824.0
meg REAL8 1048576.0
kilo REAL8 1024.0

left dd ?

.code
pn proc  ;print number
  ;eax=#

  .if eax >= 1024*1024*1024  ;Gigs
    mov t1,eax
    fild t1
    fld gig
    fdiv
    fst r1
    fwait
    callp printf,"%.1f GBs (%d)\n",r1,t1
  .elseif eax >= 1024*1024   ;Megs
    mov t1,eax
    fild t1
    fld meg
    fdiv
    fst r1
    fwait
    callp printf,"%.1f MBs (%d)\n",r1,t1
  .elseif eax >= 1024        ;Kilos
    mov t1,eax
    fild t1
    fld kilo
    fdiv
    fst r1
    fwait
    callp printf,"%.1f KBs (%d)\n",r1,t1
  .else                      ;Bytes
    mov t1,eax
    fild t1
    fst r1
    fwait
    callp printf,"%.1f Bs (%d)\n",r1,t1
  .endif
  ret
pn endp

main proc
  callp printf,"  Total free="
  callp coreleft
  mov left,eax
  call pn
  callp printf,"Largest free="
  callp qfree
  call pn

  .if left < 64*1024
    callp printf,"Insufficent memory avail. for tests\n"
    ret
  .endif

;test malloc(), realloc(), free()
  callp malloc,1024
  mov h1,eax
  .if eax==NULL
    jmp bad
  .endif
  callp malloc,1
  mov h2,eax
  .if eax==NULL
    jmp bad
  .endif
  callp malloc,1024
  mov h3,eax
  .if eax==NULL
    jmp bad
  .endif
  callp free,h2
  .if eax==ERROR
    jmp bad
  .endif
  callp realloc,h1,1025
  mov h1,eax
  .if eax==NULL
    jmp bad
  .endif
  callp free,h1
  .if eax==ERROR
    jmp bad
  .endif
  callp free,h3
  .if eax==ERROR
    jmp bad
  .endif
  ret
bad:
  callp printf,"Heap corrupted! (bug?)\n"
  ret
main endp

end


