include qlib.inc
include process.inc

  atexit_siz equ 32    ;# of atexit()'s that can be called

.data
  _atexit_entries dd atexit_siz dup (0)  ;procs to call to uninit stuff

.code
_cexit proc
  pushad
  mov eax,offset _atexit_entries
  mov ecx,atexit_siz
@@:
  mov ebx,[eax]
  .if ebx
    push eax
    push ecx
    call ebx
    pop ecx
    pop eax
  .endif
  add eax,4
  dec ecx
  jnz @b
  popad
  ret
_cexit endp

;_c_exit is in c0.asm

exit proc,el:byte
  mov ds,cs:seldata
  mov es,seldata
  mov fs,seldata
  mov gs,selzero

  call _cexit   ;this will call atexit functions
  call _c_exit  ;this will uninit c0 stuff

  mov al,el  ;error level to return
  mov ah,4ch
  int 21h   ;this is the only place I allow this to be done. Don't do it in
            ; your own code!  Or things will not get uninit
exit endp

_exit proc,el:byte
  ;NOTE : This is _NOT_ the same as exit()
  ;This does not call _cexit()

  mov ds,cs:seldata
  mov es,seldata
  mov fs,seldata
  mov gs,selzero

  call _c_exit  ;this will uninit c0 stuff only

  mov al,el  ;error level to return
  mov ah,4ch
  int 21h   ;this is the only place I allow this to be done. Don't do it in
            ; your own code!  Or things will not get uninit
  
_exit endp

atexit proc uses ecx,a:dword
  mov eax,offset _atexit_entries
  mov ecx,atexit_siz
@@:
  .if !dptr[eax]
    mov ecx,a
    mov [eax],ecx
    xor eax,eax
    ret
  .endif
  add eax,4
  dec ecx
  jnz @b
  mov eax,ERROR
  ret
atexit endp

end

