/****************************************************************************
*
*						   SuperVGA Test Library
*
*                   Copyright (C) 1993 Kendall Bennett.
*							All rights reserved.
*
* Filename:		$RCSfile: common.c $
* Version:		$Revision: 1.1 $
*
* Language:		ANSI C
* Environment:	IBM PC (MSDOS)
*
* Description:	Module containing code common to all the SuperVGA test
*				programs.
*
* $Id: common.c 1.1 1993/03/07 04:07:47 kjb Exp $
*
* Revision History:
* -----------------
*
* $Log: common.c $
* Revision 1.1  1993/03/07  04:07:47  kjb
* Initial revision
*
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "drivers.h"
#include "getopt.h"

/*---------------------------- Global Variables ---------------------------*/

extern int _ignoreSVGA,_VESAFirst,driver,chipID,memory,dac;
char    *version = "3.1";

int queryCpu(void);

/*----------------------------- Implementation ----------------------------*/

void help(void)
/****************************************************************************
*
* Function:		help
*
* Description:	Provide command line usage information.
*
****************************************************************************/
{
	printf("Options are:\n");
	printf("    -v       - Check for VESA BIOS first\n");
	printf("    -s<name> - Force detection of SuperVGA 'name'\n");
	printf("    -c<x>    - Force detection of SuperVGA chipset (numerical id)\n");
	printf("    -m<size> - Force memory size to 'size'\n");
	printf("    -d<x>    - Force DAC type (0 normal, 1 HiColor, 3 TrueColor)\n");
	printf("    -i       - Do not perform SuperVGA detection\n");
	printf("\n");
	printf("It is possible the SuperVGA detection code will hang the machine on old\n");
	printf("VGA/SVGA cards. You can optionally force the program to work with any\n");
	printf("combination of card, chipset, memory size and DAC, but unless you specify\n");
	printf("the -i option, unspecified values will be filled in automatically for you.\n");
	exit(1);
}

void parseArguments(int argc,char *argv[])
/****************************************************************************
*
* Function:		parseArguments
* Parameters:	argc	- Number of command line arguments
*				argv	- Array of command line arguments
*
* Description:	Parses the command line and forces detection of specific
*				SuperVGA's if specified.
*
****************************************************************************/
{
	int		i,forceSVGA = -1,forceCHIP = -1,forceMEM = -1;
	int		forceDAC = grDETECTDAC;
	int		option;
	char	*argument;

	if (queryCpu() < 4) {
		printf("This program requires an 80386 or better processor to run.\n");
		exit(1);
		}

	/* Parse command line options */

	do {
		option = getopt(argc,argv,"VvS:s:C:c:M:m:D:d:Iih",&argument);
		if (isascii(option))
			option = tolower(option);
		switch(option) {
			case 'v':
				_VESAFirst = true;
				break;
			case 'i':
				_ignoreSVGA = true;
				break;
			case 's':
				i = __FIRST_SVGA+1;
				while (1) {
					if (stricmp(MGL_driverName(i),argument) == 0) {
						forceSVGA = i;
						break;
						}
					if (++i > __LAST_SVGA) {
						printf("Unknown SuperVGA chip. Valid values are:\n\n");
						for (i = __FIRST_SVGA+1; i <= __LAST_SVGA; i++)
							printf("    %s\n", MGL_driverName(i));
						exit(1);
						}
					}
				break;
			case 'c':
				forceCHIP = atoi(argument);
				break;
			case 'm':
				forceMEM = atoi(argument);
				break;
			case 'd':
				forceDAC = atoi(argument);
				break;
			case 'h':
			case INVALID:
				help();
			}
		} while (option != ALLDONE);

	driver = grDETECT;
	dac = forceDAC;
	MGL_detectGraph(&driver,&chipID,&memory,&dac,&i);
	if (forceSVGA != -1) driver = forceSVGA;
	if (forceCHIP != -1) chipID = forceCHIP;
	if (forceMEM != -1) memory = forceMEM;
}
