/* ***********************************************************************
   *									 *
   *	       The Continuous Potential Method for the Julia Set	 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************

   125 iterations maximum
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "math.inc"
#include "graph.inc"
#include "render.inc"

#define cp   -0.12
#define cq    0.74
#define XMin -1.4
#define XMax  1.4
#define YMin -1.4
#define YMax  1.4
#define Iter  32
#define Scal  32767

char ObjF[]="CPMJ1";

/*
#define cp    0.31
#define cq    0.04
#define XMin -1.4
#define XMax  1.4
#define YMin -1.4
#define YMax  1.4
#define Iter  32
#define Scal  32767

char ObjF[]="CPMJ2";
*/

int Iters;

float JSetPot(float p, float q, float cx, float cy, int MaxIter)
{
  float x, y;
  float x2, y2;
  float temp;

  x=cx;
  x2=SqrFP(x);
  y=cy;
  y2=SqrFP(y);
  Iters=0;
  while((Iters<MaxIter) && (x2+y2<20000.0))
  {
    temp=p+x2-y2;
    y=q+2*x*y;
    y2=SqrFP(y);
    x=temp;
    x2=SqrFP(x);
    ++Iters;
  }
  if(Iters<MaxIter)
    return(0.5*log10(x2+y2)/pow(2, Iters));
  else
    return(0.0);
}

void JSetCPM(int nx, int ny, int MaxIter,
	     float p, float q,
	     float Xmin, float Xmax,
	     float Ymin, float Ymax)
{
  int ix, iy;
  float cx, cy;
  float dx, dy;
  int z;

  dx=(Xmax-Xmin)/(nx-1);
  dy=(Ymax-Ymin)/(ny-1);
  for(ix=0; ix<=((nx-1)/2); ix++)
  {
    cx=Xmin+ix*dx;
    for(iy=0; iy<ny; iy++)
    {
      cy=Ymin+iy*dy;
      z=Round(JSetPot(p, q, cx, cy, MaxIter)*Scal);
      Height[ix][iy]=z;
      Height[Res-1-ix][Res-1-iy]=z;
      PutPixel(ix, 199-iy, Iters/7, Iters%35);
      PutPixel((Res-1-ix), 199-(Res-1-iy), Iters/7, Iters%35);
    }
  }
}

void InverseHeightBuffer()
{
  int i, j;
  int Max;

  Max=0;
  for(i=0; i<=MaxRes; i++)
  {
    for(j=0; j<=MaxRes; j++)
    {
      if(Height[i][j]>Max)
	Max=Height[i][j];
    }
  }
  for(i=0; i<=MaxRes; i++)
  {
    for(j=0; j<=MaxRes; j++)
    {
      Height[i][j]=Max-Height[i][j];
    }
  }
}

/* ***********************************************************************
   *									 *
   *				Main Program				 *
   *									 *
   ***********************************************************************
*/

void main()
{
  clrscr();
  Scaling=32767;
  Res=MaxRes;
  InitGraphics();
  ClearHeightBuffer();
  JSetCPM(Res, Res, Iter, cp, cq, XMin, XMax, YMin, YMax);
  InverseHeightBuffer();
  strcpy(ObjectFile, ObjF);
  SaveHeightBuffer(ObjectFile);
  ExitGraphics();
}
