/* ***********************************************************************
   *									 *
   *		 Original Material by Christopher D. Watkins		 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************
*/
/* ***********************************************************************
   *									 *
   *			Declare Constants and Variables			 *
   *									 *
   ***********************************************************************

   HeightBufferScalingFactor - scales height for integer manipulation
*/

#define MaxRes 160  /* 160x160 pixels - actually we have memory for 173x173 */

int Height[MaxRes+1][MaxRes+1];
int Scaling;
int MaxHeight;
int Res;

void HeightBufferScalingFactor()
{
  Scaling=32767/MaxHeight;
}

/* ***********************************************************************
   *									 *
   *		  Clear, Load and Save Height Buffer Data		 *
   *									 *
   ***********************************************************************

   ClearHeightBuffer - clears all heights to zero
   SaveHeightBuffer  - saves height buffer
   LoadHeightBuffer  - loads height buffer
   GetObjectFile     - get filename
   GetObjectColor    - text representation of color
*/

typedef char Name[32];

FILE *TextDiskFile;
Name ObjectFile;

void ClearHeightBuffer()
{
  int i, j;

  for(i=0; i<=MaxRes; i++)
  {
    for(j=0; j<=MaxRes; j++)
      Height[i][j]=0;
  }
}

void SaveHeightBuffer(Name FileName)
{
  int i, j;

  strcat(FileName, ".DAT");
  TextDiskFile=fopen(FileName, "w+b");
  if(ferror(TextDiskFile))
  {
    ungetch(32);
    ExitGraphics();
    printf("Can't open file!\n");
    getch();
    exit(1);
  }
  putw(Res, TextDiskFile);
  putw(Scaling, TextDiskFile);
  for(i=0; i<=Res; i++)
  {
    for(j=0; j<=Res; j++)
      putw(Height[i][j], TextDiskFile);
  }
  fclose(TextDiskFile);
}

void LoadHeightBuffer(Name FileName)
{
  int i, j;

  strcat(FileName, ".DAT");
  printf("\nLoading %s\n", FileName);
  TextDiskFile=fopen(FileName, "r+b");
  Res=getw(TextDiskFile);
  Scaling=getw(TextDiskFile);
  for(i=0; i<=Res; i++)
  {
    for(j=0; j<=Res; j++)
      Height[i][j]=getw(TextDiskFile);
  }
  fclose(TextDiskFile);
}

void GetObjectFile()
{
  int i;
  Byte x, y;

  printf("\nEnter File Name -> ");
  x=wherex();
  y=wherey();
  gets(ObjectFile);
  if(!(strcmp(ObjectFile, "")))
  {
    strcpy(ObjectFile, "MOUNTAIN");
    gotoxy(x, y);
    puts(ObjectFile);
  }
  puts("");
  for(i=0; i<strlen(ObjectFile); i++)
    ObjectFile[i]=toupper(ObjectFile[i]);
}

void GetObjectColor(int C)
{
  switch(C)
  {
    case 0 : puts("Black"); break;
    case 1 : puts("Blue"); break;
    case 2 : puts("Green"); break;
    case 3 : puts("Cyan"); break;
    case 4 : puts("Red"); break;
    case 5 : puts("Magenta"); break;
    case 6 : puts("Brown/Yellow"); break;
    case 7 : puts("Grey"); break;
  }
}
