/* ***********************************************************************
   *									 *
   * 		Three Dimensional Strange Attractor Generator		 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *		             'C' conversion by				 *
   *				Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "math.inc"
#include "graph.inc"

int GetPixel3D(int x, int y, int z)
{
  int xp, yp;

  MapCoordinates(x, y, z, &xp, &yp);
  return(GetPixel(xp, yp));
}

#define xxmin -2
#define xxmax  2
#define yymin -2
#define yymax  2
#define zzmin -2
#define zzmax  2
#define res    200
#define a      2.24
#define b      0.43
#define c     -0.65
#define d     -2.43
#define e      1.00

float xinc, yinc, zinc;
float x, y, z, xx, yy, zz;
int   xxx, yyy, zzz, col, pix;

void main()
{
  InitPerspective(false, 0, 0, 500, 500);
  InitPlotting(240, 18);
  InitGraphics();
  PutAxisAndPalette(true);
  AxisAndPalette();
  xinc=res/(xxmax-xxmin);
  yinc=res/(yymax-yymin);
  zinc=res/(zzmax-zzmin);
  x=0;
  y=0;
  z=0;
  while(!(kbhit()))
  {
    xx=sin(a*y)-z*cos(b*x);
    yy=z*sin(c*x)-cos(d*y);
    zz=e*sin(x);
    x=xx;
    y=yy;
    z=zz;
    xxx=Round(xx*xinc);
    yyy=Round(yy*yinc);
    zzz=Round(zz*zinc);
    col=(xxx+XRes/2)%251;
    pix=GetPixel3D(xxx, yyy, zzz);
    if(col>pix)
      CartesianPlot3D(xxx, yyy, zzz, col);
  }
  ExitGraphics();
}
