/* ***********************************************************************
   *									 *
   *	         Program to Display Slices of the Database		 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "stdlib.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "math.inc"
#include "graph.inc"
#include "render.inc"

int Max;

void TestHeightBufferXZPlane(int Slice)
{
  int i, j;

  j=Slice;
  for(i=0; i<Res; i++)
    PutPixel(i, Round(MaxY-100*Height[i][j]/Max), MaxCol, MaxInten);
}

void TestHeightBufferYZPlane(int Slice)
{
  int i, j;

  i=Slice;
  for(j=0; j<Res; j++)
    PutPixel(j, Round(MaxY-100*Height[i][j]/Max), MaxCol, MaxInten);
}

void FindMax()
{
  int i, j;

  Max=0;
  for(i=0; i<=MaxRes; i++)
  {
    for(j=0; j<=MaxRes; j++)
    {
      if(Height[i][j]>Max)
	Max=Height[i][j];
    }
  }
}

/* ***********************************************************************
   *									 *
   *				Main Program				 *
   *									 *
   ***********************************************************************
*/

void main()
{
  int Slice;
  int Sl;

  clrscr();
  printf("Display Slice of z-Buffer Data\n");
  ClearHeightBuffer();
  GetObjectFile();
  LoadHeightBuffer(ObjectFile);
  FindMax();
  do
  {
    clrscr();
    printf("Xslice = 0 or Yslice = 1 or Quit = -1 => ");
    scanf("%d", &Sl);
    if(Sl>=0)
    {
      printf("\nChoose a Slice =>");
      scanf("%d", &Slice);
      InitGraphics();
      if(Sl==1)
	TestHeightBufferYZPlane(Slice);
      else
	TestHeightBufferXZPlane(Slice);
      ExitGraphics();
    }
  }
  while(Sl!=-1);
}
