/*===========================================================================*\
| WNDWDEMO.C - Multi-level window demo for WNDWC20         ver 2.0, 03-06-89  |
|                                                                             |
| This demo shows just a few features of multi-level windows, including high  |
| speed screen design.                                                        |
|   Copyright(c) 1989 by James H. LeMay,  All rights reserved.                |
|   Conversion to Turbo C by Jordan Gallagher / Wisdom Research               |
\*===========================================================================*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>

#include "qwikc20.h"
#include "wndwc20.h"

#define FUNCKEY 0
#define RETKEY 13
#define ESCKEY 27

enum {
    STEP0,
    STEP1,
    STEP2,
    STEP3,
    STEP4,
    STEP5
};

int step=STEP0;
int i,j;
char key;
char tmp[10];
char tmp2[10];

char stra[16][40]=
{ "WNDWC20 works with these ...",
  "",
  "COMPUTERS:           ADAPTERS:",
  "   ",
  "IBM PC               MDA",
  "IBM XT               CGA",
  "IBM AT               EGA",
  "IBM PCjr             MCGA",
  "IBM PC Convertible   VGA",
  "IBM PS/2 Model 25    8514/A",
  "IBM PS/2 Model 30    Hercules:",
  "IBM PS/2 Model 50     HGC",
  "IBM PS/2 Model 60     HGC Plus",
  "IBM PS/2 Model 70     InColor",
  "IBM PS/2 Model 80 ",
  "IBM 3270 PC" };
char strb[13][40]=
{ "If you have any questions or comments,",
  "please write to or call:",
  "",
  "     Eagle Performance Software",
  "     TC Products",
  "     Attn: Jordan Gallagher",
  "           (CIS 73557,2342)",
  "     P.O. Box 292786",
  "     Lewisville, TX  75029-2786",
  "     (214) 539-7855",
  "",
  "Or call The Eagle BBS 24 hrs. a day at",
  "(214) 539-9878, 1200/2400 N81" };


/*=========================| displaybasescreen |============================*\
Displays text on the base screen (WINDOW0).
\*==========================================================================*/
void displaybasescreen(void)
{
    /* -- Create initial screen -- */
    wwritec( 2, "Multi-Level Virtual Windows" );
    wwritec( 3, "Version 2.0 for" );
    wwritec( 4, "Turbo C 2.0" );
    tws.wndwattr = LIGHTGRAY_BG;
    wwritec( 6, "For each of the following displays:" );
    wwritec( 8, "1. Press RETURN to continue." );
    wwritec( 9, "2. Press ESC to back up.    " );
    tws.wsline = SINGLE_BORDER;
    wlineh(12, 1, crt_cols );
    wwritec( 16,"This is the base screen without windows.  Let's just see  ");
    wwritec( 17,"how fast WNDWC can create complex screen designs.  As soon");
    wwritec( 18,"as you press return, WNDWC will start creating a screen   ");
    wwritec( 19,"from scratch.  Nothing has been done yet.  Then WNDWC will");
    wwritec( 20,"display the resulting window on the screen.  Try to time  ");
    wwritec( 21,"it, but don't blink!                                      ");
    step=STEP0;
}


/*==============================| doassets |================================*\
\*==========================================================================*/
void doassets(void)
{
    setwindowmodes( SEETHRUMODE+RELMODE );
    makewindow( 3, 1, 12, 39, GREEN_BG, SAMEATTR, NO_BORDER, AWINDOW );
    tws.wndwattr = LIGHTGRAY_BG;
    wclrline( 1 );
    wwritec( 1,    "A S S E T S" );
    weostorc( 3, 33 );
    qfilleos( 12, 7, LIGHTGRAY_BG, ' ' );
    tws.wndwattr = tws.origattr;
    wwrite( 2, 2, "Current Assets:" );
    wwrite( 3, 3, "Cash and Equivalents" );
    wwrite( 4, 3, "Accounts Receivable:" );
    wclreos( tws.wndwattr );
    wwrite( 5, 4, "United States" );
    wwrite( 6, 4, "Canada" );
    wwrite( 7, 4, "Europe" );
    wwrite( 8, 3, "Contracts in process" );
    wwrite( 9, 3, "Inventories" );
    wwrite(10, 3, "Prepaid expenses" );
    wwrite(11, 2, "Total Current Assets" );
    wwrite(12, 2, "Property and Equipment" );
    wwrite(14, 2, "Total Assets:" );
}


/*============================| doassetnums |===============================*\
\*==========================================================================*/
void doassetnums(void)
{
    int cash = 128;
    int us = 1757;
    int canada = 1827;
    int europe = 1426;
    int contracts = 10802;
    int inventory = 4872;
    int prepaid = 443;
    int property = 1140;
    long totalca,totalassets;

    makewindow( 3, 33, 12, 7, LIGHTGRAY_BG, SAMEATTR, NO_BORDER, AWINDOW );
    totalca = cash+us+canada+europe+contracts+inventory;
    totalassets = totalca+prepaid;

    wwritec( 3,  (sprintf(tmp,"%5s",itoa( cash,        tmp2,10)),tmp) );
    wwritec( 5,  (sprintf(tmp,"%5s",itoa( us,          tmp2,10)),tmp) );
    wwritec( 6,  (sprintf(tmp,"%5s",itoa( canada,      tmp2,10)),tmp) );
    wwritec( 7,  (sprintf(tmp,"%5s",itoa( europe,      tmp2,10)),tmp) );
    wwritec( 8,  (sprintf(tmp,"%5s",itoa( contracts,   tmp2,10)),tmp) );
    wwritec( 9,  (sprintf(tmp,"%5s",itoa( inventory,   tmp2,10)),tmp) );
    wwritec( 10, (sprintf(tmp,"%5s",itoa( prepaid,     tmp2,10)),tmp) );
    wwritec( 11, (sprintf(tmp,"%5s",ltoa( totalca,     tmp2,10)),tmp) );
    wwritec( 12, (sprintf(tmp,"%5s",itoa( property,    tmp2,10)),tmp) );
    wwritec( 14, (sprintf(tmp,"%5s",ltoa( totalassets, tmp2,10)),tmp) );
}


/*===========================| doliabilities |==============================*\
\*==========================================================================*/
void doliabilities(void)
{
    makewindow( 3, 41, 12, 38, GREEN_BG, SAMEATTR, NO_BORDER, AWINDOW );
    weostorc( 3, 32 );
    qfilleos( 12, 7, LIGHTGRAY_BG, ' ' );
    tws.wndwattr = WHITE+RED_BG;
    wclrline( 1 );
    wwritec( 1, "L I A B I L I T I E S" );
    tws.wndwattr = tws.origattr;
    wwrite( 2, 2, "Current Liabilities:" );
    wclreos( tws.wndwattr );
    wwrite( 3, 3, "Commercial paper" );
    wwrite( 4, 3, "Accounts payable" );
    wwrite( 5, 3, "Accrued salaries" );
    wwrite( 6, 3, "Deferred taxes" );
    wwrite( 7, 2, "Total Current" );
    wwrite( 8, 2, "Noncurrent Liabilities:" );
    wclreos( tws.wndwattr );
    wwrite( 9, 3,  "Long-term debt" );
    wwrite(10, 3,  "Product liability" );
    wwrite(11, 3,  "Deferred taxes" );
    wwrite(12, 2, "Total Noncurrent" );
    wwrite(14, 2, "Total Liabilities:" );
}


/*=============================| doliabnums |===============================*\
\*==========================================================================*/
void doliabnums(void)
{
    int paper = 3331;
    int payable = 5776;
    int salaries = 6430;
    int taxes1 = 2344;
    int longterm = 402;
    int product = 1876;
    int taxes2 = 1096;
    long totalcl,totalnl, totalliabs;

    makewindow( 3, 72, 12, 7, LIGHTGRAY_BG, SAMEATTR, NO_BORDER, AWINDOW );
    totalcl = paper+payable+salaries+taxes1;
    totalnl = longterm+product+taxes2;
    totalliabs = totalcl+totalnl;

    wwritec( 3,  (sprintf(tmp,"%5s",itoa( paper,      tmp2,10 )),tmp) );
    wwritec( 4,  (sprintf(tmp,"%5s",itoa( payable,    tmp2,10 )),tmp) );
    wwritec( 5,  (sprintf(tmp,"%5s",itoa( salaries,   tmp2,10 )),tmp) );
    wwritec( 6,  (sprintf(tmp,"%5s",itoa( taxes1,     tmp2,10 )),tmp) );
    wwritec( 7,  (sprintf(tmp,"%5s",ltoa( totalcl,    tmp2,10 )),tmp) );
    wwritec( 9,  (sprintf(tmp,"%5s",itoa( longterm,   tmp2,10 )),tmp) );
    wwritec( 10, (sprintf(tmp,"%5s",itoa( product,    tmp2,10 )),tmp) );
    wwritec( 11, (sprintf(tmp,"%5s",itoa( taxes2,     tmp2,10 )),tmp) );
    wwritec( 12, (sprintf(tmp,"%5s",ltoa( totalnl,    tmp2,10 )),tmp) );
    wwritec( 14, (sprintf(tmp,"%5s",ltoa( totalliabs, tmp2,10 )),tmp) );
}


/*=============================| doauditor |================================*\
\*==========================================================================*/
void doauditor(void)
{
    makewindow( 18, 1, 6, 78, GREEN_BG, SAMEATTR, NO_BORDER, AWINDOW );
    wwrite( 1, 2, "Auditor:" );
    wwrite( 2, 2, "Business Address:" );
    wwrite( 3, 2, "Mailing Address:" );
    wwrite( 4, 2, "Contact:" );
    wwrite( 5, 2, "Comments:" );
    setwindowmodes( RELMODE );
    makewindow( 18, 19, 6, 60, WHITE+BROWN_BG, SAMEATTR, NO_BORDER, AWINDOW );
    wwrite( 1, 1, "Ferret Auditors of Texas, Inc." );
    wwrite( 2, 1, "1234 Technical Avenue      " );
    qwriteeos( GREEN_BG, " State: " );
    qwriteeos( SAMEATTR, "Texas    " );
    qwriteeos( GREEN_BG, " Zip: " );
    qwriteeos( SAMEATTR, "76125-1200" );
    wwrite( 3, 1, "P.O. Box 292786            " );
    qwriteeos( GREEN_BG, " State: " );
    qwriteeos( SAMEATTR, "Texas    " );
    qwriteeos( GREEN_BG, " Zip: " );
    qwriteeos( SAMEATTR, "76125-1281" );
    wwrite( 4, 1, "John Q. Public, CPA        " );
    qwriteeos( GREEN_BG, " Phone: " );
    qwriteeos( SAMEATTR, "(817)-555-1212" );
    wwrite( 5, 1, "Was this screen fast enough for you?" );
    wwrite( 6, 1, "Press RETURN to continue or ESC to back up." );
}


/*============================| dopartitions |==============================*\
\*==========================================================================*/
void dopartitions(void)
{
    removewindow();       /* back to parent window. */

    wwritec( 1, "1989 CONSOLIDATED BALANCE (Dollars in thousands)" );
    tws.wsline = SINGLE_BORDER;
    wlineh(  2, 1, tws.wcols );
    wlineh( 15, 1, tws.wcols );
    wlinev(  3, 40, 14 );
    wlinepart( 2, 40, BRDR_TT );
    wlinepart( 15, 40, BRDR_CL );
    wbrdrh( 17 );
}


/*========================| displayscreendesign |===========================*\
\*==========================================================================*/
void displayscreendesign(void)
{
    /* -- You can compare how much slower it would be if we didn't use -- */
    /* -- HIDDENMODE.  Try without it and comment out writetohidden.   -- */
    setwindowmodes( HIDDENMODE+CURSOROFFMODE );
    makewindow( 1, 1, 25, 80, BLACK+GREEN_BG, WHITE+GREEN_BG,
                HDOUBLE_BORDER, WINDOW1 );
    writetohidden( WINDOW1 );
    titlewindow( TOP, LEFT, YELLOW+GREEN_BG, " High Speed Screen Design " );
    doassets();
    doassetnums();
    doliabilities();
    doliabnums();
    doauditor();
    dopartitions();
    showwindow( WINDOW1 );
}


/*========================| displayequipmentlist |==========================*\
\*==========================================================================*/
void displayequipmentlist(void)
{
    /* -- Compatible computers and adapters for WNDWC20 -- */
    setwindowmodes( ZOOMMODE );
    makewindow( 4, 35, 18, 34, WHITE+BLUE_BG, LIGHTCYAN+BLUE_BG,
                HDOUBLE_BORDER, AWINDOW );
    titlewindow( TOP, CENTER, SAMEATTR, " Software Compatibility " );
    for(j=0; j<16; j++) wwrite( j+1, 2, stra[j] );
}


/*===========================| displayauthor |==============================*\
\*==========================================================================*/
void displayauthor(void)
{
    /* -- Author of WNDWC20 -- */
    setwindowmodes( ZOOMMODE );
    if(videomode != 7)
        setwindowmodes( windowmodes+SHADOWRIGHT );
    strcpy( (char *) brdr[USER_BORDER_2], "ų");
    makewindow( 5, 20, 15, 42, WHITE+BROWN_BG, BROWN_BG, USER_BORDER_2,
                AWINDOW );
    for(j=0; j<13; j++)
        wwrite( j+1, 2, strb[j] );
    titlewindow( BOTTOM, CENTER, SAMEATTR, " Press RETURN to exit " );
}


/*===============================| getkey |=================================*\
\*==========================================================================*/
void getkey(void)
{
    do {
        key=getch();                      /* read keyboard input.      */
        if(key==0)                        /* if first char was #00 ... */
            key=getch();                  /* ... read second char.     */
    } while( key!=RETKEY && key!=ESCKEY );
}


/*============================| findnextstep |==============================*\
\*==========================================================================*/
void findnextstep(void)
{
    switch(key) {
        case ESCKEY: if(step > STEP0) {
                         removewindow();
                         step--;
                     } break;

        case RETKEY: step++;
    }
}


/*===========================| displaywindows |=============================*\
\*==========================================================================*/
void displaywindows(void)
{
    do {
        getkey();
        findnextstep();
        if(key==RETKEY)
            switch(step) {
                case STEP1:  displayscreendesign(); break;
                case STEP2:  displayequipmentlist(); break;
                case STEP3:  displayauthor();
            }
    } while(step != STEP4);
}


void main()
{
    int j;

    prefer_multitask=1;
    qinit();
    modcursor( cursor_off );
    initwindow( BLUE+LIGHTGRAY_BG, 1, 1 );
    displaybasescreen();
    displaywindows();
    /* -- Use the following statement to return to the original screen. -- */

    for(i=0,j=li; i<j; i++) removewindow();
    wclrscr();
    wwritec( 12, "Copyright (c) 1989  James H. LeMay" );
    wwritec( 13, "Eagle Performance Software" );
    modcursor( cursor_on );
    gotorc( crt_rows, 1 );

    exit(0);
}
