{
Windows with exclusive access in the XView-PC interface
By Antonio Carlos Moreirao de Queiroz - acmq@coe.ufrj.br
Version 1.0 - 10/04/94
Version 1.1 - 24/06/94 "wallpaper" set only if necessary

Procedure similar to "open_window", but with the control returning to the
calling point when the window "w" is closed. "w" is a pointer to a "frame".
The window "w" must be initially closed. Its "callbacks" can open other
windows, that must be also initially closed. The procedure returns when all
the new windows are closed with the "close_window" procedure.
This is a "trick" with the interface. Improper use may cause a "crash".
Use in simple warnings to the user that require immediate response.
Try to use "open_window" instead of this procedure whenever possible,
The program must use the units XView and Graph.
}

PROCEDURE open_exclusive_window(w:Xv_opaque);
VAR
  temp_w:Xv_opaque;
  temp:BOOLEAN;
  VP:ViewPortType;
BEGIN
  temp_w:=active_w;
  temp:=wallpaper;
  wallpaper:=wallpaper or (active_w<>nil);
  active_w:=nil;
  GetViewSettings(VP);
  xv_main_loop(w);
  xv_end:=FALSE;
  active_w:=temp_w;
  wallpaper:=temp;
  WITH VP DO SetViewPort(x1,y1,x2,y2,Clip)
END;
