/*
Test program for the PC-XView interface in C/C++
By Antonio Carlos Moreirao de Queiroz - acmq@coe.ufrj.br
Version 1.0a - 19/04/94
Version 1.1  - 09/07/94 - Simple bitmap editor; Compatible with djgpp
Version 1.1a - 01/08/94 - No more measurements of memory used

To compile with Borland C:

Make a project with mickey.obj, xview.obj, and xvtest.c.
Use Turbo C++ 1.0 or more recent version.
Set the memory model to "huge".
Set linking with floating point and graphics libraries.
Set the environment variable TCBGI to where are the BGI drivers with the
correct version (the ones in xv_pc*.zip are for Turbo Pascal 7.0).
Set the environment variable BMP to where are the ".bmp" files.
This is not necessary if the .bgi and .bmp files are in the current directory.

To compile with GNU C ("djgpp"):
The necessary files are "mickey.o", "xview.o", and the corresponding .h
files, that are not the same of the Borland C version.
See the file "xview_pc.txt" for information on how to get these files.
Set the environment variables in a way that works with the "libgrx"
and "bcc2grx" packages for djgpp.
Set the environment variable TCBGI to where is the "litt.chr" BGI font file.
Set the environment variable BMP to where are the ".bmp" files.
Compile the program with:
  gcc -Wall mickey.o xview.o xvtest.c -lbcc -lgrx -lpc -lm -o xvtest
Execute with "go32 xvtest", or use "strip xvtest" and "coff2exe xvtest" to
produce a directly executable program.
*/

#include <stdio.h>
#include <string.h>
#include "xview.h"
#include "notice.h"

#ifdef __GNUC__
#include <DPMI.h>
#define coreleft _go32_dpmi_remaining_virtual_memory
#endif

#define PWIDTH 32
#define PHEIGHT 32

int color=0;
char buf[200];
unsigned char painting[PWIDTH][PHEIGHT];
int pwidth,pheight;

/* Declaration of the interface objects */
Xv_opaque menu1,menu2;
Xv_opaque frame1,tty1,button1,button2,button3,
  button4,button5,text2,text3,text4,
  button6;
Xv_opaque frame2,canvas1,message1;
Xv_opaque frame3,setting1,setting2,button7,message2;

void ClearPainting(void)
{
  int i,j;

  for (i=0;i<PWIDTH;i++)
    for (j=0;j<PHEIGHT;j++)
      painting[i][j]=15;
}

/* Callback procedures */

void Open1(Xv_opaque obj)
{
  /* Notify handler for button1 */
  open_window(frame2);
}

void Open2(Xv_opaque obj)
{
  /* Notify handler for button2 */
  open_window(frame3);
}

void Quit(Xv_opaque obj)
{
  /* Notify handler for button3 */
  xv_end=notice("Exit to DOS?");
}

void Icon1(Xv_opaque obj)
{
  /* Notify handler for button4 */
  ttysw_output(tty1,"XView-PC\r\nBy Antonio C. M. de Queiroz\r\n");
}

void Icon2(Xv_opaque obj)
{
  /* Notify handler for button5 */
  ttysw_output(tty1,"Federal University of\r\nRio de Janeiro, Brazil\r\n");
}

void EnterText(Xv_opaque obj)
{
  /* Notify handler for text2 */
  sprintf(buf,"Text: %s\r\n",obj->v.stextfield.panel_value);
  ttysw_output(tty1,buf);
}

void EnterInt(Xv_opaque obj)
{
  /* Notify handler for text3 */
  sprintf(buf,"Integer: %d\r\n",obj->v.stextfield.panel_int);
  ttysw_output(tty1,buf);
}

void EnterReal(Xv_opaque obj)
{
  /* Notify handler for text4 */
  sprintf(buf,"Real: %g\r\n",obj->v.stextfield.panel_real);
  ttysw_output(tty1,buf);
}

void Icon3(Xv_opaque obj)
{
  /* Notify handler for button6 */
  ttysw_output(tty1,"E-mail: acmq@coe.ufrj.br\r\n");
}

void Close2(Xv_opaque obj)
{
  /* Notify handler for frame2 and frame3 */
  sprintf(buf,"Closed %s\r\n",obj->xv_label);
  ttysw_output(tty1,buf);
}

void ReDraw(Xv_opaque obj)
{
  /* Notify handler for canvas1 */
  int i,j;

  /* Updates the pixel size and redraws the painting */
  pwidth=canvas1->dx/PWIDTH;
  pheight=canvas1->dy/PHEIGHT;
  for (i=0;i<PWIDTH;i++)
    for (j=0;j<PHEIGHT;j++) {
      setfillstyle(SOLID_FILL,painting[i][j]);
      bar((i*pwidth),(j*pheight),(i+1)*pwidth-1,(j+1)*pheight-1);
    }
}

void Draw(Xv_opaque obj)
{
  /* Event handler for canvas1 */
  int i,j;

  /* Lists mouse location */
  if (ie_code==LOC_MOVE) {
    sprintf(buf,"x:%d y:%d",ie_locx,ie_locy);
    xv_set(message1,buf);
  }
  /* Adds pixel to painting */
  else if (ie_shiftcode==1) {
    i=ie_locx/pwidth;
    j=ie_locy/pheight;
    setfillstyle(SOLID_FILL,color);
    if ((i<PWIDTH) && (j<PHEIGHT)) {
      bar((i*pwidth),(j*pheight),(i+1)*pwidth-1,(j+1)*pheight-1);
      painting[i][j]=color;
    }
  }
}

void ChangeColor(Xv_opaque obj)
{
  /* Notify handler for setting1 and setting2 */
  /* Updates the color and makes the two settings agree */
  if (obj==setting2) {
    color=obj->v.ssetting.sel_setting;
    setting1->v.ssetting.sel_setting=color+1;
    draw_object(setting1,0);
  }
  else {
    color=obj->v.ssetting.sel_setting-1;
    setting2->v.ssetting.sel_setting=color;
    draw_object(setting2,0);
  }
  /* Lists the color selection, with an example */
  sprintf(buf,"Selection=%d\r\n",obj->v.ssetting.sel_setting);
  ttysw_output(tty1,buf);
  /* Shows the color */
  message2->fore_color=color;
  xv_set(message2,"Color");
}

void Options(Xv_opaque obj)
{
  /* Notify handler for menu1 */
  switch (obj->v.smenu.sel_menu) {
    case 1: /* close 1 */; close_window(frame1); break;
    case 2: /* close 2 */; close_window(frame2); break;
    case 3: /* close 3 */; close_window(frame3); break;
    case 4: /* open 1 */; open_window(frame1); break;
    case 5: /* open 2 */; open_window(frame2); break;
    case 6: /* open 3 */; open_window(frame3); break;
    case 7: /* quit */; xv_end=1; break;
    case 8: /* more... */; break;
    case 9: /* memory */
      sprintf(buf,"Memory left: %ul\r\n",coreleft());
      ttysw_output(tty1,buf);
      break;
  }
}

void Files(Xv_opaque obj)
{
  /* Notify handler for menu2 */
  switch (obj->v.smenu.sel_menu) {
    case 1: /* load */;
      if (notice("Load a new drawing?")) ttysw_output(tty1,"Load not implemented\r\n"); break;
    case 2: /* save */;
      if (notice("Save the drawing?")) ttysw_output(tty1,"Save not implemented\r\n"); break;
    case 3: /* more */ break;
    case 4: /* clear */
      if (notice("Clear the drawing?")) {
        ClearPainting();
        ReDraw(canvas1);
      }
  }
}

void ListEvents(Xv_opaque obj)
{
  /* Event handler for button7 and message2 */
  sprintf(buf,"Event: %d",ie_code);
  xv_set(message2,buf);
}

void main()
{
  /* Inicialization */
  use_palette=1;
  ClearPainting();
  xv_init(0,0);
  /* Menu creation */
  /* Menu for frame1, frame2, and frame3 */
  /* Submenu for item 8 of menu1 */
  /* Submenu for item 3 of menu2 */
  menu1=xv_create(menu);
    strcpy(menu1->xv_label,"menu");
    item_create("close 1");
    item_create("close 2");
    item_create("close 3");
    item_create("open 1");
    item_create("open 2");
    item_create("open 3");
    item_create("quit");
    item_create("more...");
    item_create("memory");
    /* Just for demonstration. Recursive menus can damage the screen */
    menu1->v.smenu.item_submenu[7]=menu1;
    menu1->v.smenu.sel_menu=1;
    menu1->notify_handler=(xv_handler)Options;
  /* Menu for canvas1 */
  menu2=xv_create(menu);
    strcpy(menu2->xv_label,"options");
    item_create("load");
    item_create("save");
    item_create("more");
    item_create("clear");
    menu2->v.smenu.item_submenu[2]=menu1;
    menu2->notify_handler=(xv_handler)Files;
  /* Interface objects creation */
  frame1=xv_create(frame);
    strcpy(frame1->xv_label,"XView-PC test program");
    frame1->dx=218;
    frame1->dy=162;
    frame1->v.sframe.dxmin=218;
    frame1->v.sframe.dymin=162;
    frame1->menu_name=menu1;
    frame1->v.sframe.adjust_exit=0;
  tty1=xv_create(tty);
    tty1->v.scanvas.can_yext=0; tty1->dy=42;
  button1=xv_create(button);
    strcpy(button1->xv_label,"popup 2..");
    button1->y=46;
    button1->notify_handler=(xv_handler)Open1;
  button2=xv_create(button);
    strcpy(button2->xv_label,"popup 3..");
    button2->y=61;
    button2->notify_handler=(xv_handler)Open2;
  button3=xv_create(button);
    strcpy(button3->xv_label,"quit");
    button3->y=76;
    button3->notify_handler=(xv_handler)Quit;
  button4=xv_create(button);
    strcpy(button4->xv_label,"xview.bmp");
    button4->x=80;
    button4->y=46;
    button4->v.sbutton.icon_label=1;
    button4->notify_handler=(xv_handler)Icon1;
  button5=xv_create(button);
    strcpy(button5->xv_label,"brasil.bmp");
    button5->x=126;
    button5->y=46;
    button5->v.sbutton.icon_label=1;
    button5->notify_handler=(xv_handler)Icon2;
  text2=xv_create(textfield);
    strcpy(text2->xv_label,"Text:");
    text2->y=91;
    text2->notify_handler=(xv_handler)EnterText;
  text3=xv_create(textfield);
    strcpy(text3->xv_label,"Integer:");
    text3->y=106;
    text3->v.stextfield.value_length=17;
    text3->v.stextfield.field_type=int_field;
    text3->notify_handler=(xv_handler)EnterInt;
  text4=xv_create(textfield);
    strcpy(text4->xv_label,"Real:");
    text4->y=121;
    text4->v.stextfield.field_type=real_field;
    text4->notify_handler=(xv_handler)EnterReal;
  button6=xv_create(button);
    strcpy(button6->xv_label,"email.bmp");
    button6->x=171;
    button6->y=46;
    button6->v.sbutton.icon_label=1;
    button6->notify_handler=(xv_handler)Icon3;
  frame2=xv_create(frame);
    strcpy(frame2->xv_label,"Window 2");
    frame2->x=18;
    frame2->y=20;
    frame2->dx=PWIDTH*5+1+2*mrgx;
    frame2->dy=PHEIGHT*5+16+mrgx+mrgy;
    frame2->notify_handler=(xv_handler)Close2;
    frame2->menu_name=menu1;
    frame2->v.sframe.dxmin=PWIDTH+1+2*mrgx;
    frame2->v.sframe.dymin=PWIDTH+16+mrgx+mrgy;
  canvas1=xv_create(canvas);
    canvas1->y=15;
    canvas1->event_handler=(xv_handler)Draw;
    canvas1->notify_handler=(xv_handler)ReDraw;
    canvas1->menu_name=menu2;
  message1=xv_create(message);
    strcpy(message1->xv_label,"x: y:");
  frame3=xv_create(frame);
    strcpy(frame3->xv_label,"Window 3");
    frame3->x=39;
    frame3->y=42;
    frame3->dx=277;
    frame3->dy=70;
    frame3->v.sframe.dymin=30;
    frame3->notify_handler=(xv_handler)Close2;
    frame3->menu_name=menu1;
  setting1=xv_create(setting);
    strcpy(setting1->xv_label,"color #");
    item_create("0");
    item_create("1");
    item_create("2");
    item_create("3");
    item_create("4");
    item_create("5");
    item_create("6");
    item_create("7");
    item_create("8");
    item_create("9");
    item_create("A");
    item_create("B");
    item_create("C");
    item_create("D");
    item_create("E");
    item_create("F");
    setting1->v.ssetting.exclusive=1;
    setting1->v.ssetting.sel_setting=1;
    setting1->notify_handler=(xv_handler)ChangeColor;
  setting2=xv_create(setting);
    strcpy(setting2->xv_label,"binary ");
    setting2->y=15;
    item_create("1");
    item_create("2");
    item_create("4");
    item_create("8");
  setting2->notify_handler=(xv_handler)ChangeColor;
  button7=xv_create(button);
    strcpy(button7->xv_label,"test events");
    button7->y=30;
    button7->event_handler=(xv_handler)ListEvents;
  message2=xv_create(message);
    message2->y=30;
    message2->x=100;
    message2->event_handler=(xv_handler)ListEvents;
  xv_main_loop(frame1);
  /* Exit */
  restorecrtmode();
}
