/*****************************************************************************
 *									     *
 *      Header          :       CT-voice.H                                   *
 *      By              :       Marq/Fit                                     *
 *      Date            :       6.04.1993                                    *
 *      Version         :       1.1B                                         *
 *      Description     :       Plays samples with CT-voice.drv & SB         *
 *      Thanx to        :       Creative Labs Inc, Amit K. Mathur, UF &      *
 *				David Beatty.				     *
 *      What did I do?  :       Well, in fact I just converted some TP       *
 *                              sources to C...                              *
 *									     *
 *****************************************************************************/

/*      With this header you can play VOC files with SB. To play a single
        file, do the following things:

        load a VOC file to memory.
        loaddriver()
        SB_init();
        SB_speaker(1);
        SB_output(segment_of_your_VOC,offset_of_your_VOC);
        ...
        SB_speaker(0);
        SB_init();
        closedriver();

        Don't know whether it works or not... Maybe baby...  */

#pragma inline

#include <dos.h>
#include <stdio.h>
#include <fcntl.h>
#include <alloc.h>
#include <io.h>

#define SB_OK 0
#define SB_HARDWARE_ERROR 1
#define SB_IO_ERROR 2
#define SB_DMA_ERROR 3
#define SPEAKER_ON 1
#define SPEAKER_OFF 0
#define PLAYING 0xFFFF

char far        *SB_driver;

int loaddriver(void);
int SB_init(void);
int SB_getversion(void);
void call(void);
void closedriver(void);
void setstatusword(unsigned seg,unsigned off);
void SB_speaker(int mode);
void SB_output(unsigned seg,unsigned off);
void setIOaddress(int num);
void setIRQnumber(int num);
void SB_input(unsigned seg,unsigned off,unsigned rate,long int length);
void SB_stopoutput(void);
void SB_pauseoutput(void);
void SB_continueoutput(void);
void setuserfunction(unsigned seg,unsigned off);

int loaddriver(void)
{
	int	hand;

	hand=open("CT-VOICE.DRV",O_RDONLY|O_BINARY);
	if(hand==-1)
		return(-1);

        SB_driver=malloc(filelength(hand)+20);
        if(SB_driver==NULL)
        {
                close(hand);
                return(-1);
        }

        SB_driver=MK_FP(FP_SEG(SB_driver)+1,0);

        read(hand,SB_driver,filelength(hand));
	close(hand);

	return(0);
}

int SB_init(void)
{
	int	huu;

	asm	mov	bx,3
	call();
	asm	mov	huu,ax

	return(huu);
}

int SB_getversion(void)
{
	unsigned	num;

	asm	mov	bx,0
	call();
	asm	mov	num,ax

	return(num);
}

void call(void)
{
	asm	push	bp
        asm     call    dword ptr       SB_driver
	asm	pop	bp
}

void closedriver(void)
{
	asm	mov	bx,9
	call();

        free(SB_driver);
}

void setstatusword(unsigned seg,unsigned off)
{
	asm	mov	bx,5
	asm	push	es
	asm	push	di
	asm	mov	ax,seg
	asm	mov	es,ax
	asm	mov	di,off
	call();
	asm	pop	di
	asm	pop	es
}

void SB_speaker(int mode)
{
	asm	mov	ax,mode
	asm	mov	bx,4
	call();
}

void SB_output(unsigned seg,unsigned off)
{
	asm	mov	bx,6
	asm	push	es
	asm	push	di
	asm	mov	ax,seg
	asm	mov	es,ax
	asm	mov	di,off
	call();
	asm	pop	di
	asm	pop	es
}

void setIOaddress(int num)
{
	asm	mov	bx,1
	asm	mov	ax,num
	call();
}

void setIRQnumber(int num)
{
	asm	mov	bx,2
	asm	mov	ax,num
	call();
}

void SB_input(unsigned seg,unsigned off,unsigned rate,long int length)
{
	unsigned	hw,lw;

	hw=length >> 16;
	lw=length & 0xffff;

	asm	mov	bx,7
	asm	mov	ax,rate
	asm	push	es
	asm	push	di
	asm	mov	ax,seg
	asm	mov	es,ax
	asm	mov	di,off
	asm	mov	dx,hw
	asm	mov	cx,lw
	call();
	asm	pop	di
	asm	pop	es
}

void SB_stopoutput(void)
{
	asm	mov	bx,8
	call();
}

void SB_pauseoutput(void)
{
	asm	mov	bx,10
	call();
}

void SB_continueoutput(void)
{
	asm	mov	bx,11
	call();
}

void setuserfunction(unsigned seg,unsigned off)
{
	asm	push	dx
	asm	mov	dx,seg
	asm	mov	ax,off
	call();
	asm	pop	dx
}

/*      EOS     */
