;
;									    
;  32-bit DOS-Extender v0.15, Copyright (c) 1995 Sami Kantoluoto.	    
;  All rights reserved.						    
;									    
;
		.386P
;۲۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_PMODE_TEXT	Segment Para Public Use16 'CODE'
		Assume	cs:_PMODE_TEXT,ds:_PMODE_TEXT
;
		org	0
		jmp	ExitDOS
;
; Header
;
		org	4
		db	"32DE"
		dw	0015h
rmode_stacks	dw	8
rmode_stacklen	dw	40h		; in paragraphs
pmode_stacks	dw	8
pmode_stacklen	dw	80h		; in paragraphs
rmode_buflen	dw	65536/16	; Maximum is 65536/16 (para...)
memhandles	dw	100h		; Each takes 16-bytes of lowmem.
pagetables      db      04h             ; Each takes 4-kbytes
gdt_entries	dw	64		; Each takes 8-bytes
callbacks	dw	16		; Each takes 25-bytes
pm_flags	db	000b		; Flags: bit 0: detect VCPI first
					;	 bit 1: Use virtual memory;
					;	 bit 2: Erase VM swapfile...
copyright	db	13,10
		db	"Copyright (c) 1995, Sami Kantoluoto",13,10
		db	"All rights reserved."
Public		LineFeed
LineFeed	db	13,10,"$",0
		Align	4
;
; Constants
;
SEL_Code	equ	08h
SEL_Data	equ	10h
SEL_ZData	equ	18h
SEL_TSS 	equ	38h
SEL_VCPI_TSS	equ	38h
SEL_VCPI_Code	equ	40h
SYS_SELECTORS	equ	11
;
; Structures
;
Descriptor	Struc
Desc_Limit15	dw	0	; Limit, bits 0-15
Desc_Addr15	dw	0	; Base address, bits  0-15
Desc_Addr23	db	0	; Base address, bits 16-23
Desc_Acc	dw	0	; Access Rights
Desc_Addr31	db	0	; Base address, bits 24-31
Descriptor	EndS

Callback_s	Struc
		dw	6066h
		db	68h
CB_CS		dw	0
		dw	6866h
CB_EIP		dd	0
		db	0B9h
CB_ES		dw	0
		dw	6866h
CB_EDI		dd	0
		db	0EAh
		dw	0,0
Callback_s	EndS

TSS		Struc
TSS_LINK_TSS	dw	0,0
TSS_ESP0	dd	0
TSS_SS0 	dw	0,0
TSS_ESP1	dd	0
TSS_SS1 	dw	0,0
TSS_ESP2	dd	0
TSS_SS2 	dw	0,0
TSS_CR3 	dd	0
TSS_EIP 	dd	0
TSS_EFLAGS	dd	0
TSS_EAX 	dd	0
TSS_ECX 	dd	0
TSS_EDX 	dd	0
TSS_EBX 	dd	0
TSS_ESP 	dd	0
TSS_EBP 	dd	0
TSS_ESI 	dd	0
TSS_EDI 	dd	0
TSS_ES		dw	0,0
TSS_CS		dw	0,0
TSS_SS		dw	0,0
TSS_DS		dw	0,0
TSS_FS		dw	0,0
TSS_GS		dw	0,0
TSS_LDTR	dw	0,0
TSS_TRAP	dw	0
TSS_IO_MAP	dw	0
TSS		EndS

MEMHandle	Struc
MH_Flags	label	word
MH_BaseAddress	dd	0
MH_Size 	dd	0
MH_Handle	dd	0
MH_BackLink	dw	0
MH_NextLink	dw	0
MEMHandle	EndS

ExceptionStack	Struc
ES_RetEIP	dd	0
ES_RetCS	dw	0,0
ES_ErrorCode	dd	0
ES_EIP		dd	0
ES_CS		dw	0,0
ES_EFlags	dd	0
ES_ESP		dd	0
ES_SS		dw	0
ExceptionStack	EndS

include 32de.inc
;
; Data (aligned)
;
cpu_type	db	0	; 5 = Pentium, 4 = 486, 3 = 386 etc.
pmode_type	db	0	; 0 = RAW, 1 = XMS, 2 = VCPI, 3 = DPMI
dpmi_ver	dw	0
dpmi_flags	dw	0
xms_ver 	dw	0

public		code_sel,data_sel,zdata_sel,codebase
code_sel	dw	SEL_Code
data_sel	dw	SEL_Data
zdata_sel	dw	SEL_ZData
codebase	dd	0

gdt_limit	dw	0
gdt_addr	dd	0
		dw	0

idt_limit	dw	7FFh
idt_addr	dd	0
		dw	0

rm_idt_limit	dw	3FFh
rm_idt_addr	dd	0

memory_needed	dw	0

		Align	4

xms_extadd	label	dword
raw_extadd	dd	0

rm_stackbase	dd	0
rm_stacktop	dd	0
rm_stacklen	dd	0

pm_stackbase	dd	0
pm_stacktop	dd	0
pm_stacklen	dd	0

rm_bufseg	dw	0
rm_bufbase	dd	0
rm_buflen	dd	0

vcpi_struc_addr dd	offset vcpi_struc
vcpi_struc	label
_cr3		label	dword
vcpi_cr3	dd	0
vcpi_gdtr_addr	dd	offset gdt_limit
vcpi_idtr_addr	dd	offset idt_limit
vcpi_ldtr	dw	0
vcpi_tr 	dw	SEL_VCPI_TSS
vcpi_eip	dd	offset v_rm2pm_pm
vcpi_cs 	dw	SEL_Code

vcpi_msw_stack	dd	0

vcpi_call	label	fword
vcpi_call_eip	dd	?
vcpi_call_cs	dw	SEL_VCPI_Code

vcpi_pic_master db	0
vcpi_pic_slave	db	0

picvecs 	label	word
pic_slave	db	70h
pic_master	db	78h

init_rout	dw	offset raw_init,xms_init,vcpi_init

memhandle_base	dd	0
memhandle_top	dd	0
memhandle_first dd	0
memhandle_last	dd	0
memman_alloc	dw	0
memman_free	dw	0

callbacks_base	dd	0
callbacks_top	dd	0

pagetable_base	dd	0
pagetable_top	dd	0

rm2pm_rout	dw	0
pm2rm_rout	dw	0,0
read_drx	dw	0
write_drx	dw	0

Public		HexTable
HexTable	db	"0123456789ABCDEF"
dta_addr	label	fword
		dq	0
dpmi_oldint21	label	fword
OldInt21	dd	0
OldInt15	dd	0
XMSControl	dd	0
dpmi_call	dd	0
dpl		db	0
dexit_code	db	0
ExceptionNro	db	0,0
		Align	4
;
; Something for exception handler
;
Extrn		DEBUG_01PM:Near,DEBUG_03PM:Near
ExceptionVec	label	FWord
		RepT	20h
		dd	offset exception_def
		dd	SEL_Code
		EndM
ExceptionTbl	dw	E00,E01,E02,E03,E04,E05,E06,E07,E08,E09,E0A,E0B,E0C
		dw	E0D,E0E,ERS,E10,E11,ERS,ERS,ERS,ERS,ERS,ERS,ERS,ERS
		dw	ERS,ERS,ERS,ERS,ERS,ERS,ERS,ERS
Public		EXCP_RegTable
EXCP_RegTable	dw	EEAX,EECX,EEDX,EEBX,EESP,EEBP,EESI,EEDI
ExceptionErCode dd	100111110100000000b	; Error code mask...
;
; Temporary variables
;
tempw0		dw	0
tempw1		dw	0
tempw2		dw	0
tempd0		dd	0
tempw3		dw	0
;
; DPMI Interface tables (v0.9)
;
		Align	4
dpmi_func	dw	0000h,0001h,0002h,0003h,0006h,0007h
		dw	0008h,0009h,000Ah,000Bh,000Ch;,0100h
		;dw	 0101h,0102h,
		dw	0200h,0201h,0202h,0203h
		dw	0204h,0205h,0300h,0301h,0302h,0303h
		dw	0304h
		dw	0305h,0306h,0400h
		dw	0501h,0502h,0503h
		;dw	 0B00h,0B01h,0B02h,0B03h
		dw	0900h,0901h,0902h
dpmi_funcs	equ	$-dpmi_func
		Align	4
dpmi_rout	dw	dpmi0000,dpmi0001,dpmi0002,dpmi0003,dpmi0006,dpmi0007
		dw	dpmi0008,dpmi0009,dpmi000A,dpmi000B,dpmi000B;,dpmi0100
		;dw	 dpmi0101,dpmi0102,
		dw	dpmi0200,dpmi0201,dpmi0202,dpmi0203
		dw	dpmi0204,dpmi0205,dpmi0300,dpmi0301,dpmi0302,dpmi0303
		dw	dpmi0304
		dw	dpmi0305,dpmi0306,dpmi0400
		dw	dpmi0501,dpmi0502,dpmi0503
		;dw	 dpmi0B00,dpmi0B01,dpmi0B02,dpmi0B03
		dw	dpmi0900,dpmi0901,dpmi0902
;
; DOS Extender tables
;
dos_func	db	09h,1Ah,1Bh,1Ch,1Fh,25h,2Fh,32h,34h	; 0Ah???
		db	35h,39h,3Ah,3Bh,3Ch,3Dh,3Fh,40h,41h
		db	43h,47h,48h,49h,4Ah,4Eh,4Fh,56h
		db	4Ch
dos_funcs	equ	($-dos_func)
dos_rout	dw	dos09,dos1A,dos1B,dos1C,dos1F,dos25,dos2F,dos32,dos34
		dw	dos35,dos39,dos3A,dos3B,dos3C,dos3D,dos3F,dos40,dos41
		dw	dos43,dos47,dos48,dos49,dos4A,dos4E,dos4F,dos56
		dw	dos4C
;
; Non-aligned strings
;
vdisk_sig	db	"VDISK V"
vdisk_sig_len	equ	$-vdisk_sig
;
; And strings for exception handler:
;
IFDEF		DEBUG
DISASM		=	1
ENDIF
IFDEF		DISASM
Extrn		UnAssemble:Near,Instruction_Off:DWord,Instruction_Len:Byte
Extrn		UBuf:Byte,SegSize:Byte
ENDIF
ERS		db	"* RESERVED EXCEPTION??? *$"
E00		db	"Divide Error$"
E01		db	"Debug Exception$"
E02		db	"NMI (not Exception)$"
E03		db	"Breakpoint$"
E04		db	"Overflow$"
E05		db	"Bounds Check$"
E06		db	"Invalid Opcode$"
E07		db	"Device Not Available$"
E08		db	"Double Fault$"
E09		db	"CoProcessor-segment overrun (Reserved)$"
E0A		db	"Invalid TSS$"
E0B		db	"Segment Not Present$"
E0C		db	"Stack Exception$"
E0D		db	"General Protection$"
E0E		db	"Page Fault$"
E10		db	"Floating-Point Error$"
E11		db	"Alignment Check$"
EEAX		db	"EAX: $"
EECX		db	"ECX: $"
EEDX		db	"EDX: $"
EEBX		db	"EBX: $"
EESP		db	"ESP: $"
EEBP		db	"EBP: $"
EESI		db	"ESI: $"
EEDI		db	"EDI: $"
EEFLAGS 	db	"EFlags: $"
EXCP_CS 	db	"CS: $"
EXCP_SS 	db	"SS: $"
EXCP_DS 	db	"DS: $"
EXCP_ES 	db	"ES: $"
EXCP_FS 	db	"FS: $"
EXCP_GS 	db	"GS: $"
ECR0		db	"CR0: $"
ECR2		db	"CR2: $"
EXCP_MSG01	db	" at $"
Public		EXCP_MSG02
EXCP_MSG02	db	"       $"
EXCP_MSG03	db	" with ErrorCode: $"
EXCP_MSG04	db	", Invalid.$"
EXCP_MSG05	db	", NULL."
EXCP_MSG06	db	"$"
EXCP_MSG07	db	", Base: $"
EXCP_MSG08	db	", Limit: $"
EXCP_MSG09	db	", Acc: $"
EXCP_MSG0A	db	"SS:[ESP+$"
;
; Code
;
public		_pm_info
_pm_info:	push	ds cs
		pop	ds
		call	detect_cpu
		cmp	cpu_type,3
		jb	_d_inv_cpu
		push	es
		pushad

		mov	ax,rmode_buflen
		mov	memory_needed,ax

		mov	eax,cs
		shl	eax,4
		mov	codebase,eax

		lea	ebx,[eax+offset vcpi_struc]
		mov	vcpi_struc_addr,ebx
		lea	ebx,[eax+offset gdt_limit]
		mov	vcpi_gdtr_addr,ebx
		lea	ebx,[eax+offset idt_limit]
		mov	vcpi_idtr_addr,ebx

		mov	pmode_type,0FFh

		test	pm_flags,1
		jnz	_d_vcpi_check

		call	detect_dpmi
_d_vcpi_check:	call	detect_vcpi
		call	detect_dpmi
		call	detect_xms
		mov	al,pmode_type
		cmp	al,3
		je	_d_dpmi
		cmp	al,2
		je	_d_not_raw

_d_raw_sw:	smsw	ax
		test	al,1
		jnz	_d_in_pmode

		mov	vcpi_call_cs,SEL_Code
		mov	vcpi_call_eip,offset retfar32b
		xor	al,al
		mov	bx,offset r_rm2pm
		mov	dx,offset r_pm2rm
		mov	bp,offset raw_alloc
		mov	cx,offset raw_free
		call	set_switch_rout

_d_not_raw:	movzx	eax,gdt_entries
		shl	eax,3
		mov	cx,ax
		dec	cx
		mov	gdt_limit,cx
		movzx	ebx,rmode_stacks
		imul	bx,rmode_stacklen
		shl	ebx,4
		lea	eax,[(eax+8+0Fh)+(ebx+0Fh)+1FFFh+800h+70h]
		mov	rm_stacktop,ebx
		movzx	ebx,pmode_stacks
		imul	bx,pmode_stacklen
		shl	ebx,4
		lea	eax,[eax+(ebx+0Fh)]
		mov	pm_stacktop,ebx
		mov	ebx,25
		imul	bx,callbacks
		lea	eax,[eax+(ebx+0Fh)]
		shr	eax,4
		add	ax,memhandles
		add	ah,pagetables

		movzx	ebx,rmode_stacklen
		shl	ebx,4
		mov	rm_stacklen,ebx
		movzx	ebx,pmode_stacklen
		shl	ebx,4
		mov	pm_stacklen,ebx

		add	memory_needed,ax

_d_exit:	popad
		xor	ax,ax
		mov	bx,memory_needed
		mov	cl,cpu_type
		mov	ch,pmode_type
		pop	es ds
		retf

_d_in_pmode:	popad
		mov	ax,2
		jmp	_d_inv_exit

_d_dpmi:	test	dpmi_flags,1
		jnz	_d_exit
		popad
		mov	ax,3
		jmp	_d_inv_exit

_d_inv_cpu:	mov	ax,1
_d_inv_exit:	stc
		pop	es ds
		retf
;
public		_pm_init
_pm_init:	; ES = Segment of ...
		push	bx cx
		call	far ptr _pm_info
		pop	cx bx
		jnc	_pm_i_ok
_pm_i_error:	retf
_pm_i_ok:	pushad
		push	ds cs
		pop	ds

		mov	rm_bufseg,es
		mov	ebx,es
		movzx	esi,rmode_buflen
		lea	si,[si+bx]
		push	si
		shl	esi,4
		mov	memhandle_base,esi
		shl	ebx,4
		mov	rm_bufbase,ebx
		cld
		xor	al,al
		xor	edi,edi
		movzx	ecx,memory_needed
		shl	ecx,4
_pm_i_clear_dta:rep	stos byte ptr es:[di]
		jecxz	_pm_i_data_clr
		add	ebx,edi
		and	di,0Fh
		mov	edx,ebx
		shr	edx,4
		mov	es,dx
		dec	ecx
		jmp	_pm_i_clear_dta

_pm_i_data_clr: pop	es
		movzx	ebx,rmode_buflen
		shl	ebx,4
		dec	ebx
		and	bl,not 3
		mov	rm_buflen,ebx

		cmp	pmode_type,3
		je	dpmi_init

		movzx	eax,memhandles
		shl	eax,4
		add	eax,esi
		mov	memhandle_top,eax
		shr	eax,4
		mov	es,ax

		xor	bh,bh
		mov	bl,pmode_type
		add	bl,bl
		jmp	init_rout[bx]

dpmi_init:	mov	ax,1
		call	[dpmi_call]
		jc	dpmi_error

		mov	dx,cs
		mov	code_sel,dx
		lar	bx,dx
		and	bh,60h
		mov	dpl,bh
		mov	data_sel,ds

		xor	ebx,ebx
		mov	edx,0FFFFFFFFh
		mov	bp,1100000010010010b
		call	alloc_desc
		jc	exitdos
		mov	zdata_sel,bx

		mov	ax,0204h
		mov	bl,21h
		int	31h
		mov	dword ptr [dpmi_oldint21],edx
		mov	word ptr [dpmi_oldint21+4],cx

		mov	ax,0205h
		mov	cx,cs
		mov	edx,offset extender_api
		mov	bl,21h
		int	31h
		jc	exitdos

dvxr_init:	pop	bx
		mov	edx,0FFFFh
		and	ebx,edx
		shl	ebx,4
		mov	bp,0100000010010010b
		call	alloc_desc
		jc	exitdos
		push	bx

		mov	bx,[esp+36]
		mov	edx,0FFFFh
		and	ebx,edx
		shl	ebx,4
		mov	bp,10011010b
		call	alloc_desc
		jc	exitdos
		mov	[esp+36],bx
IFDEF		DEBUG
		mov	ax,0202h
		mov	bl,1
		int	31h
		mov	dword ptr ExceptionVec+8*1,edx
		mov	word ptr ExceptionVec+8*1+2,cx

		mov	ax,0202h
		mov	bl,3
		int	31h
		mov	dword ptr ExceptionVec+8*3,edx
		mov	word ptr ExceptionVec+8*3+2,cx

		mov	cx,cs
		mov	edx,offset DEBUG_01PM
		mov	ax,0203h
		mov	bl,1
		int	31h
		jc	exitdos

		mov	edx,offset DEBUG_03PM
		mov	ax,0203h
		mov	bl,3
		int	31h
		jc	exitdos
ENDIF

		pop	ds
		popad
                xor     ax,ax

IFDEF		DEBUG
                pushf
                or      byte ptr [esp+1],1
                popf
                retf
        ELSE
		retf
ENDIF

dpmi_error:	mov	dexit_code,5
init_error:	pop	ds
		popad
		stc
		xor	ah,ah
		mov	al,cs:dexit_code
		retf
		; -------------------------------------------------------------
vcpi_init:	mov	ax,0DE0Ah
		int	67h

		mov	vcpi_pic_master,bl
		mov	vcpi_pic_slave,cl
		cmp	bl,08h
		jne	vcpi_i_pics_ok

		cli

		mov	esi,8
		movzx	edi,pic_master
		call	copy_vectors

		mov	cl,pic_master
		mov	ch,vcpi_pic_slave
                xor     dl,dl
                call    program_pic

		xor	bh,bh
		mov	ch,bh
		mov	bl,pic_master
		mov	cl,vcpi_pic_slave
		mov	ax,0DE0Bh
		int	67h

		sti

		mov	bl,pic_master
		mov	cl,vcpi_pic_slave

vcpi_i_pics_ok: mov	pic_slave,cl
		mov	pic_master,bl

		mov	ecx,es
		add	cx,0FFh
		xor	cl,cl
		mov	fs,cx
		inc	ch
		mov	es,cx

		movzx	ebx,cx
		shl	ebx,4
		mov	pagetable_base,ebx
		xor	eax,eax
		mov	al,pagetables
		shl	eax,12
		lea	eax,[eax+ebx]
		mov	pagetable_top,eax

		xor	di,di
		mov	ax,ss
		sub	sp,8*3
		mov	ds,ax
		mov	si,sp
		mov	ax,0DE01h
		int	67h

		push	cs
		pop	ds

		mov	vcpi_call_eip,ebx

		movzx	ebx,di
		shl	ebx,10

		push	bx

		mov	ah,42h
		int	67h

		movzx	edx,bx
		pop	bx

		shl	edx,14
		jz	vcpi_continue

		movzx	eax,pagetables
		shl	eax,22
		sub	eax,ebx
		jc	vcpi_pt_clear
		jz	vcpi_pt_clear
		cmp	edx,eax
		jbe	vcpi_memhandle
		mov	edx,eax
vcpi_memhandle: mov	ebx,1024*1024
		call	memm_addhandle

vcpi_continue:	xor	bh,bh
		mov	bl,ch
		shl	bx,2
		mov	eax,es:[bx-4]
		mov	vcpi_cr3,eax
		xor	ecx,ecx

vcpi_pt_clear:	sub	di,4
		jc	vcpi_pagedir
		and	byte ptr es:[di+1],11110001b
		jmp	short vcpi_pt_clear

vcpi_pagedir:	mov	eax,es:[bx]
		mov	fs:[ecx*4],eax
		lea	bx,[bx+4]
		inc	cl
		cmp	cl,pagetables
		jb	vcpi_pagedir

		shl	bx,6
		movzx	ebx,bx
		mov	es,bx
		push	es

		mov	eax,ebx
		shl	eax,4
		add	eax,64h-24h
		mov	vcpi_msw_stack,eax

		mov	ecx,vcpi_cr3
		mov	es:[TSS_CR3],ecx
		mov	es:[TSS_IO_MAP],68h

		add	bx,7
		mov	es,bx

		; -------------------------------------------------------------
vxr_init:
                push    bx es
                mov     ax,3521h
                int     21h
                mov     word ptr OldInt21,bx
                mov     word ptr OldInt21+2,es
                pop     es bx
                mov     dx,offset rm_int21
                mov     ax,2521h
                int     21h

                shl     ebx,4
                mov     pm_stackbase,ebx
                add     ebx,pm_stacktop
                mov     pm_stacktop,ebx
                mov     rm_stackbase,ebx
                add     ebx,rm_stacktop
		mov	rm_stacktop,ebx

		mov	eax,ebx

		shr	ebx,4
		mov	es,bx

		mov	callbacks_base,eax
		movzx	ecx,callbacks
		imul	cx,25
		add	cx,0Fh
		lea	eax,[eax+ecx]
		mov	callbacks_top,eax
		shr	cx,4
		and	al,0F0h
		mov	idt_addr,eax
		add	eax,800h
		mov	gdt_addr,eax

		add	bx,cx

                ; create callbacks (callback structure by Tran)

		xor	di,di
		mov	cx,callbacks
		jcxz	vxr_cb_done
vxr_callbacks:	mov	word ptr es:[di],6066h		; PUSHAD
		mov	byte ptr es:[di+2],068h 	; PUSH WORD
		mov	word ptr es:[di+5],06866h	; PUSH DWORD
		mov	byte ptr es:[di+11],0B9h	; MOV CX,? instruction
		mov	word ptr es:[di+14],06866h	; PUSH DWORD instruction
		mov	byte ptr es:[di+20],0EAh	; JMP FAR PTR ?:? intruction
		mov	word ptr es:[di+21],offset callback
		mov	word ptr es:[di+23],_PMODE_TEXT
		lea	di,[di+25]
		loop	vxr_callbacks			; We save a byte here... ;)

vxr_cb_done:	mov	es,bx

		; create IDT

		xor	di,di
		xor	edx,edx
vxr_idt:	lea	eax,[SEL_Code*10000h+offset int_vectors+edx*4]
		stos	dword ptr es:[di]
		mov	eax,1000111000000000b
		mov	cl,dl
		and	cl,0F8h
		cmp	cl,20h
		jb	vxr_idt_gate
		cmp	cl,pic_master
		je	vxr_idt_gate
		cmp	cl,pic_slave
		je	vxr_idt_gate
		or	ah,1
vxr_idt_gate:	stos	dword ptr es:[di]
		inc	dl
		jnz	vxr_idt

		mov	word ptr es:[31h*8],offset dpmi_api
		mov	word ptr es:[21h*8],offset extender_api

		; create GDT

		add	bx,80h
		mov	es,bx

		pop	ax
		cmp	pmode_type,2
		jne	vxr_xr

		mov	si,sp
		mov	di,SEL_VCPI_Code
		mov	cx,(3*8)/4
		rep	movs dword ptr es:[di],ss:[si]
		add	sp,8*3

vxr_xr: 	shl	eax,4
		mov	es:[SEL_TSS+2],eax
		mov	byte ptr es:[SEL_TSS+5],10001001b
		mov	byte ptr es:[SEL_TSS],67h

		mov	di,8

		mov	ebx,_PMODE_TEXT
		shl	ebx,4
		mov	edx,0FFFFh
		mov	cx,10011010b
		call	create_desc

		mov	cl,10010010b
		call	create_desc

		xor	ebx,ebx
		mov	edx,0FFFFFFFFh
		mov	cx,0100000010010010b
		call	create_desc

		mov	ah,62h
		int	21h
		mov	fs,bx
		xor	ch,ch
		mov	bx,fs:[2Ch]
		or	bx,bx
		jz	vxr_env_sel
		shl	ebx,4
		mov	fs:[2Ch],di
		mov	edx,0FFFFh
		call	create_desc
vxr_env_sel:	push	di
		mov	edx,0FFh
		mov	ebx,fs
		shl	ebx,4
		call	create_desc

		mov	ebx,ss
		shl	ebx,4
		mov	edx,0FFFFh
		mov	cx,0100000010010010b
		call	create_desc

		pop	cx
		mov	ax,SEL_Data
		lea	dx,[di-8]
		movzx	ebx,sp
		mov	si,SEL_Code
		mov	edi,offset dvxr_init
		jmp	[rm2pm_rout]
		; -------------------------------------------------------------
xms_init:	xor	ah,ah
		call	[XMSControl]
		mov	dexit_code,8
		cmp	ax,0300h
		jb	init_error

		mov	ah,88h
		call	[XMSControl]

		movzx	ebp,pagetables
		shl	ebp,22
		lea	ebp,[ebp-1024*1024]
		shl	edx,10
		cmp	edx,ebp
		jbe	x_memok
		mov	edx,ebp
x_memok:	mov	ebx,1024*1024
		call	memm_addhandle

xr_init:	mov	ebx,es
		push	es
		; remap pic (only master is remapped)

		cli

		mov	esi,8
		movzx	edi,pic_master
		call	copy_vectors

		mov	cl,pic_master
		mov	ch,pic_slave
                xor     dl,dl
                call    program_pic

		sti

		; create Page Directory and map first meg...

		add	bx,0FFh+7
		xor	bl,bl
		mov	fs,bx
		mov	eax,ebx
		add	bx,100h
		mov	es,bx

		shl	eax,4

		mov	_cr3,eax
		lea	ecx,[eax+1000h]
		mov	pagetable_base,ecx
		or	al,111b

		mov	cl,pagetables
		xor	di,di
xr_pagedir:	add	bx,100h
		lea	eax,[eax+4096]
		mov	fs:[di],eax
		lea	di,[di+4]
		dec	cl
		jnz	xr_pagedir

		and	al,not 111b
		mov	pagetable_top,eax

		mov	eax,7
		xor	di,di
		mov	cx,1024/4
xr_firstptable: stos	dword ptr es:[di]
		lea	eax,[eax+4096]
		loop	xr_firstptable

		mov	es,bx

		jmp	vxr_init
		; -------------------------------------------------------------
raw_init:	xor	eax,eax
		mov	ah,88h
		int	15h
		or	eax,eax
		jz	xr_init

		call	enableA20
		jc	raw_A20_error

		push	ax dx es
		mov	ax,3515h
		int	21h
		mov	word ptr OldInt15,bx
		mov	word ptr OldInt15+2,es
		mov	dx,offset rm_int15
		mov	ax,2515h
		int	21h
		pop	es dx ax

		shl	eax,10
		mov	ebx,1024*1024

		push	es
		xor	cx,cx
		mov	es,cx
		mov	es,es:[19h*4+2]
		xor	di,di
		call	check_vdisk_sig
		jne	raw_no_vdisk1
		mov	ebx,es:[2Ch]
		and	ebx,00FFFFFFh
raw_no_vdisk1:	mov	cx,0FFFFh
		mov	es,cx
		mov	di,10h
		call	check_vdisk_sig
		jne	raw_no_vdisk2
		movzx	ecx,word ptr es:[2Eh]
		shl	ecx,10
		cmp	ebx,ecx
		jae	raw_no_vdisk2
		mov	ebx,ecx
raw_no_vdisk2:	pop	es
		and	bx,0F000h

		lea	edx,[ebx-1024*1024]
		sub	eax,edx
		jc	xr_init

		lea	ecx,[eax+edx]
		and	ecx,4095
		sub	edx,ecx
		and	edx,not 4095
		mov	raw_extadd,edx

		lea	edx,[eax+ecx]
		and	edx,not 4095

		mov	ebx,1024*1024

		call	memm_addhandle

		jmp	xr_init

raw_A20_error:	mov	ax,4
i_error:	pop	ds
		mov	bp,sp
		mov	[bp]._ax,ax
		popad
		stc
		retf
;
; Software detection routines
;
check_vdisk_sig:cld
		lea	di,[di+12h]
		mov	si,offset vdisk_sig
		mov	cx,vdisk_sig_len
		repe	cmps byte ptr ds:[si],es:[di]
		ret
;
detect_dpmi:	mov	ax,1687h
		int	2Fh
		or	ax,ax
		jnz	d_dpmi_exit

		mov	dpmi_ver,dx
		mov	dpmi_flags,bx
		cmp	cpu_type,cl
		jae	d_dpmi_cpu_ok
		mov	cpu_type,cl

d_dpmi_cpu_ok:	mov	word ptr [dpmi_call],di
		mov	word ptr [dpmi_call+2],es
		mov	al,3
		call	set_switch_rout
		jne	d_dpmi_exit

		add	memory_needed,si

d_dpmi_exit:	ret
;
detect_vcpi:	mov	ax,3567h
		int	21h
		mov	ax,es
		or	ax,bx
		jz	d_vcpi_exit

		mov	ax,0DE00h
		int	67h
		or	ah,ah
		jnz	d_vcpi_exit

		mov	al,2
		mov	bx,offset v_rm2pm
		mov	dx,offset v_pm2rm
		mov	bp,offset vcpi_alloc
		mov	cx,offset vcpi_free
		call	set_switch_rout

d_vcpi_exit:	ret
;
detect_xms:	mov	ax,4300h
		int	2Fh
		cmp	al,80h
		jne	d_xms_exit
		mov	ax,4310h
		int	2Fh
		mov	word ptr [XMSControl],bx
		mov	word ptr [XMSControl+2],es

		xor	ah,ah
		call	[XMSControl]
		mov	xms_ver,ax

		mov	al,1
		mov	bx,offset r_rm2pm
		mov	dx,offset r_pm2rm
		mov	bp,offset xms_alloc
		mov	cx,offset xms_free
		call	set_switch_rout
d_xms_exit:	ret
;
set_switch_rout:;  AL = pmode type
		; EBX = real mode -> protected mode routine
		; EDX = protected mode -> real mode routine
		;  BP = Memory allocation routine
		;  CX = Memory free routine
		cmp	pmode_type,0FFh
		jne	s_sw_rout_exit
		mov	pmode_type,al
		mov	rm2pm_rout,bx
		mov	pm2rm_rout,dx
		mov	memman_alloc,bp
		mov	memman_free,cx
s_sw_rout_exit: ret
;
; Couple descriptor setup routines...
;
create_desc:	; ES:DI = GDT
		; EBX = Base address
		; EDX = Limit
		;  CX = Access rights
		push	ebx edx cx
		mov	dword ptr es:[di].Desc_Addr15,ebx
		rol	ebx,8
		mov	es:[di].Desc_Addr31,bl

		and	ch,01000000b
		or	ch,00010000b

		cmp	edx,1024*1024
		jb	cd_lim_ok
		or	ch,80h
		shr	edx,12
cd_lim_ok:	mov	es:[di].Desc_Limit15,dx
		ror	edx,8
		or	ch,dh
		mov	es:[di].Desc_Acc,cx
		lea	di,[di+8]
		pop	cx edx ebx
		ret
;
alloc_desc:	; EBX = Base address
		; EDX = Limit
		;  BP = Access Rights
		xor	ax,ax
		mov	cx,1
		int	31h
		jc	ad_exit

		push	edx
		mov	dx,bx
		rol	ebx,16
		mov	cx,bx
		mov	bx,ax
		mov	ax,7
		int	31h
		pop	dx cx
		jc	ad_exit

		mov	ax,8
		int	31h
		jc	ad_exit

		mov	ax,9
		mov	cx,bp
		or	cl,dpl
		int	31h
		jc	ad_exit

ad_exit:	ret
;
; Hardware detection/setup routines:
;
		assume	ds:_PMODE_TEXT
cpu_id		macro
		db	00Fh,0A2h	; cpu_id instruction
		endm
		.8086
detect_cpu:	pushf
		push	ax cx
		cli

		mov	cpu_type,0

		pushf
		pop	ax
		mov	cx,ax
		and	ax,0FFFh
		push	ax
		popf
		pushf
		pop	ax
		and	ax,0F000h
		cmp	ax,0F000h
		je	d_cpu_exit

		.286
d_cpu_286:	mov	cpu_type,2
		or	cx,0F000h
		push	cx
		popf
		pushf
		pop	ax
		and	ax,0F000h
		jz	d_cpu_exit

		.386P
d_cpu_386:	push	eax ecx edx ebx
		inc	cpu_type
		mov	bx,sp
		and	sp,not 3
		pushfd
		pop	eax
		mov	ecx,eax
		xor	eax,40000h
		push	eax
		popfd
		pushfd
		pop	eax
		xor	eax,ecx
		mov	sp,bx
		jz	d_cpu_exit_386p

		and	sp,not 3
		push	ecx
		popfd
		mov	sp,bx

d_cpu_486:	inc	cpu_type
		mov	eax,ecx
		xor	eax,200000h
		push	eax
		popfd
		pushfd
		pop	eax
		xor	eax,ecx
		jz	d_cpu_exit_386p

d_cpu_x86:	xor	eax,eax
		cpu_id
		cmp	eax,1
		jne	d_cpu_exit_386p

		cpu_id
		and	ah,0Fh
		mov	cpu_type,ah

d_cpu_exit_386p:pop	ebx edx ecx eax

d_cpu_exit:	pop	cx ax
		popf
		ret
;
enableA20:	pusha
		push	fs gs

		xor	ax,ax
		mov	fs,ax
		dec	ax
		mov	gs,ax

		call	testA20
		je	eA20_done

		in	al,92h
		or	al,2
		jmp	$+2
		jmp	$+2
		jmp	$+2
		out	92h,al

		call	testA20
		je	eA20_done

		call	wait_kbc
		jnz	eA20_wait_A20

		mov	al,0D1h
		out	64h,al
		call	wait_kbc
		mov	al,0DFh
		out	60h,al
		call	wait_kbc

eA20_wait_A20:	mov	cx,1000h
eA20_wait:	in	al,40h
		in	al,40h
		mov	ah,al
eA20_wait_tick: jmp	$+2
		jmp	$+2
		in	al,40h
		in	al,40h
		cmp	al,ah
		je	eA20_wait_tick

		call	testA20
		je	eA20_done

		loop	eA20_wait

		stc
		jmp	eA20_exit

eA20_done:	clc
eA20_exit:	pop	gs fs
		popa
		ret
;
wait_kbc:	xor	cx,cx
wkbc:		jmp	$+2
		jmp	$+2
		jmp	$+2
		in	al,64h
		test	al,2
		loopnz	wkbc
		ret
;
testA20:	mov	al,fs:[0]
		mov	ah,gs:[10h]
		not	byte ptr fs:[0]
		cmp	gs:[10h],ah
		mov	fs:[0],al
		ret
;
program_pic:	; cl = master pic-mapping
		; ch = slave pic-mapping
                ; dl = jore
                mov     al,00010001b
                or      al,dl
		out	20h,al
		jmp	$+2
		jmp	$+2
		mov	al,cl
		out	21h,al
		jmp	$+2
		jmp	$+2
		mov	al,00000100b
		out	21h,al
		jmp	$+2
		jmp	$+2
                mov     al,01101b
		out	21h,al
		jmp	$+2
		jmp	$+2
		mov	al,00010001b
                or      al,dl
		out	0A0h,al
		jmp	$+2
		jmp	$+2
		mov	al,ch
		out	0A1h,al
		jmp	$+2
		jmp	$+2
		mov	al,2
		out	0A1h,al
		jmp	$+2
		jmp	$+2
                mov     al,1001b;00011011b
		out	0A1h,al
		jmp	$+2
		jmp	$+2
		ret
;
copy_vectors:	; ESI = Old vec, EDI = New vec
		push	ds es
		cld
		xor	ax,ax
		mov	ds,ax
		mov	es,ax
		shl	si,2
		shl	di,2
		mov	ecx,8
		rep	movs dword ptr es:[di],ds:[si]
		pop	es ds
		ret
;
; Interrupt Service routines:
;
rm_int15:	cmp	ah,88h
		je	short int15_88
		jmp	cs:[OldInt15]
int15_88:	xor	ax,ax
		iret
;
rm_int21:       pushf
		cmp	ah,25h
		je	short int21_x5xx
		cmp	ah,35h
		je	short int21_x5xx
int21_jmp:	popf
		jmp	cs:[OldInt21]
int21_x5xx:	cmp	al,8
		jb	short int21_jmp
		cmp	al,0Fh
		ja	short int21_jmp
		popf
		push	ax
		pushf
		and	al,7
		add	al,cs:pic_master
		call	cs:[OldInt21]
		pop	ax
		jmp	int21_jmp
;
		align	4
int_vectors:	rept	100h
		nop
		call	pm_inthandler
		endm

pm_inthandler:	push	gs fs ds es
		pushad

		mov	ds,cs:zdata_sel
		mov	esi,cs:codebase

		mov	bx,[esp+40]
		sub	bx,offset int_vectors+4
		mov	cx,bx
		shr	cx,2

excpt_dpmi_jmp: mov	ch,cl
		and	ch,0F8h

		mov	al,8
		cmp	ch,ds:pic_slave[esi]
		je	pm_ih_irq
		mov	al,70h
		cmp	ch,ds:pic_slave[esi]
		jne	pm_ih_maybe_int

pm_ih_irq:	and	cl,7
		xor	ebx,ebx
		mov	bl,al
		add	bl,cl
		push	dword ptr ds:[ebx*4]
		mov	edi,ds:rm_stacktop[esi]
		lea	edx,[edi-12]
		sub	edi,ds:rm_stacklen[esi]
		cmp	edi,ds:rm_stackbase[esi]
		jb	stack_overflow
		mov	ds:rm_stacktop[esi],edi
		mov	edi,edx
		pushf
		db	66h,67h,0C7h,00000111b	; mov ds:[edi],...
		dw	pm_ih_irq_rm
		dw	_PMODE_TEXT
		pop	word ptr ds:[edi+4]
		lea	ebp,[esp+4]
		mov	ds:[edi+10],ss
		mov	ds:[edi+6],ebp
		mov	bx,di
		xor	di,di
		shr	edi,4
		mov	dx,di
		pop	di si
		db	66h
		jmp	cs:[pm2rm_rout]
pm_ih_irq_rm:	pop	ebx dx
		mov	si,SEL_Code
		mov	edi,offset ih_exit
		mov	ax,SEL_Data
		xor	cx,cx
		jmp	cs:[rm2pm_rout]
ih_exit:	mov	eax,ds:rm_stacklen
		add	ds:rm_stacktop,eax
ih_exit2:	popad
		pop	es ds fs gs
		add	esp,2
		iretd

pm_ih_maybe_int:cmp	ch,20h
		jb	ih_maybe_exception

pm_ih_int:	mov	ebp,ds:[bx]
		mov	edi,ds:rm_stacktop[esi]
		mov	eax,edi
		mov	ebx,ds:rm_stacklen[esi]
		sub	edi,ebx
		cmp	edi,ds:rm_stackbase[esi]
		jb	stack_overflow
		mov	ds:rm_stacktop[esi],edi
		cld
		mov	edx,edi
		shr	edx,4
		sub	bx,48
		lea	edi,[eax-48]
		; DX:BX = Stack...
		mov	ax,ds
		mov	es,ax
		mov	esi,esp
		mov	ecx,8
		mov	ax,ss:[esp+50]
		rep	movs dword ptr es:[edi],ss:[esi]
		mov	es:[edi],ebp
		lea	edi,[edi+4]

		db	66h,67h,0C7h,07h	; mov ds:[edi],...
		dw	pm_ih_int_rm2,_PMODE_TEXT

		mov	es:[edi+4],ax
		mov	ds:[edi+6],esp
		mov	ds:[edi+10],ss
		mov	si,_PMODE_TEXT
		mov	di,offset pm_ih_int_rm
		db	66h
		jmp	cs:[pm2rm_rout]
pm_ih_int_rm:	popad
		retf
pm_ih_int_rm2:	pushf
		pushad
		movzx	esp,sp
		mov	bp,sp
		mov	ebx,[bp+34]
		mov	dx,[bp+38]
		mov	ebp,ss
		add	ebp,ebp
		lea	ebp,[ebp*8+esp]
		mov	ax,SEL_ZData
		mov	cx,dx
		mov	si,SEL_Code
		mov	edi,offset pm_ih_int_pm
		jmp	cs:[rm2pm_rout]
pm_ih_int_pm:	cld
		mov	esi,ebp
		mov	edi,esp
		mov	ecx,8
		rep	movs dword ptr es:[edi],ds:[esi]
		mov	ax,ds:[esi]

		and	word ptr [esp+50],1111000100101010b
		and	ax,0000111011010101b
		or	[esp+50],ax

		mov	ecx,cs:codebase
		mov	ebx,ds:rm_stacklen[ecx]
		add	ds:rm_stacktop[ecx],ebx
		jmp	ih_exit2

ih_maybe_exception:
		; oh well... Let's check if it's software int, not exception...
		mov	eax,1
		shl	eax,cl
		test	eax,ds:ExceptionErCode[esi]
		jnz	ih_check2
		les	edi,[esp+42]
		cmp	byte ptr es:[edi-2],0CDh
		jne	exception
		cmp	byte ptr es:[edi-1],cl
		jne	exception
		jmp	pm_ih_int
ih_check2:	movzx	edx,word ptr [esp+46]
		xor	ah,ah
		cmp	dx,gdt_limit
		ja	exception
		lar	ax,dx
		jnz	exception
		test	ah,80h
		jz	exception
		xor	eax,eax
		lsl	eax,edx
		jnz	exception
		or	eax,eax
		jz	exception
		les	edi,[esp+42]
		cmp	edi,eax
		ja	exception
		cmp	byte ptr es:[edi-2],0CDh
		jne	exception
		cmp	byte ptr es:[edi-1],cl
		jne	exception
		jmp	pm_ih_int
;
exception:	; Exception Handler... ;)
		mov	ds,cs:data_sel
		assume	ds:_PMODE_TEXT

		; Switch stacks
		push	word ptr ExceptionNro
		mov	ExceptionNro,cl

		lea	ebp,[esp+44]
		mov	eax,1
		shl	eax,cl
		test	ExceptionErCode,eax
		mov	eax,0
		jz	excpt_ercod_ok
		mov	eax,[ebp]
		lea	ebp,[ebp+4]
excpt_ercod_ok: mov	es,zdata_sel

		mov	edi,pm_stacktop
		mov	edx,edi
		sub	edx,pm_stacklen
		cmp	edx,pm_stackbase
		jb	stack_overflow
		mov	pm_stacktop,edx

		lea	edi,[edi-(40+8+8+12+4+8+2)]
		mov	edx,edi

		cld
		lea	esi,[esp+2]
		mov	ecx,10
		rep	movs dword ptr es:[edi],ss:[esi]

		movzx	esi,bx
		lea	esi,[esi*2+offset ExceptionVec]
		mov	cl,2
		rep	movs dword ptr es:[edi],ds:[esi]

		mov	dword ptr es:[edi],offset exception_back
		mov	dword ptr es:[edi+4],SEL_Code
		lea	edi,[edi+8]

		stos	dword ptr es:[edi]

		mov	cl,3
		mov	esi,ebp
		rep	movs dword ptr es:[edi],ss:[esi]

		pop	word ptr ss:[esi-2]

		mov	es:[edi],esi
		mov	es:[edi+4],ss

		mov	ss,zdata_sel
		mov	esp,edx

		popad
		pop	es ds fs gs

		db	66h
		retf

exception_back: lea	esp,[esp+4]
		db	66h
		push	es
		push	edi esi ecx
		mov	edi,[esp+16+12]
		mov	es,[esp+16+16]
		sub	edi,16+12
		push	edi
		cld
		mov	ecx,7
		lea	esi,[esp+4]
		rep	movs dword ptr es:[edi],ss:[esi]
		mov	si,es
		pop	edi
		mov	ss,si
		mov	esp,edi

		mov	es,cs:data_sel
		mov	ecx,es:pm_stacklen
		add	es:pm_stacktop,ecx

		pop	ecx esi edi
		db	66h
		pop	es
		iretd

exception_def:	; Default handler for all exceptions
		push	ds es fs gs
		pushad
		mov	ds,cs:data_sel
		assume	ds:_PMODE_TEXT
		mov	es,zdata_sel

		mov	ax,03
		int	10h

		cli

		xor	edx,edx
		mov	bx,word ptr ExceptionNro
		add	bl,bl
		mov	dx,ExceptionTbl[bx]
		mov	ah,09h
		int	21h
		mov	edx,offset EXCP_MSG01
		int	21h

		mov	cl,4
		mov	bp,[esp+40].ES_CS
		call	PrintHex

		mov	ah,02h
		mov	dl,':'
		int	21h

		mov	cl,8
		mov	ebp,[esp+40].ES_EIP
		call	PrintHex

		mov	edx,offset EXCP_MSG03
		mov	ah,09h
		int	21h

		mov	ebp,[esp+40].ES_ErrorCode
		mov	cl,8
		call	PrintHex

		mov	edx,offset LineFeed
		mov	ah,09h
		int	21h
		int	21h

		mov	ebx,[esp+40].ES_ESP
		xor	esi,esi
		mov	[esp]._reserved,ebx

		mov	ax,8
excpt_showregs: push	ax
		movzx	edx,cs:EXCP_RegTable[esi*2]
		mov	ah,09h
		int	21h
		lea	ebp,[esi*4]
		neg	ebp
		mov	ebp,[esp+ebp+28+2]
		mov	cl,8
		call	PrintHex
		mov	edx,offset EXCP_MSG02
		mov	ah,09h
		int	21h
		inc	esi
		pop	ax
		dec	ax
		jnz	excpt_showregs

		mov	edx,offset EEFLAGS
		mov	ah,09h
		int	21h
		mov	ebp,[esp+40].ES_EFLAGS
		mov	cl,8
		call	PrintHex

		mov	edx,offset LineFeed
		mov	ah,09h
		int	21h
		int	21h

		lea	ebp,[esp+40].ES_CS
		mov	edx,offset EXCP_CS
		call	PrintSReg
		lea	ebp,[esp+40].ES_SS
		mov	edx,offset EXCP_SS
		call	PrintSReg
		mov	ax,4
		lea	ebp,[esp+40]
		mov	edx,offset EXCP_DS
excpt_showsregs:lea	ebp,[ebp-2]
		push	ax edx ebp
		call	PrintSReg
		pop	ebp edx ax
		lea	edx,[edx+5]
		dec	ax
		jnz	excpt_showsregs

		mov	edx,offset LineFeed
		mov	ah,09h
		int	21h

		;cmp	 pmode_type,3
		;je	 excpt_dpmi
		mov	edx,offset ECR0
		int	21h
		mov	ebp,cr0
		mov	cl,8
		call	PrintHex
		mov	edx,offset EXCP_MSG02
		mov	ah,09h
		int	21h
		mov	edx,offset ECR2
		int	21h
		mov	ebp,cr2
		mov	cl,8
		call	PrintHex
		mov	edx,offset LineFeed
		mov	ah,09h
		int	21h
excpt_dpmi:	int	21h

		mov	ebp,[esp+40].ES_ESP
		mov	fs,[esp+40].ES_SS
IFNDEF		DISASM
		lea	ebp,[ebp+7*4]
		mov	cl,8
	ELSE
		lea	ebp,[ebp+16*4]
		mov	cl,17
ENDIF
excpt_showstack:push	cx ebp
		mov	ah,2
		xor	bh,bh
		xor	dl,dl
IFNDEF		DISASM
		mov	dx,14 shl 8+55
	ELSE
		mov	dx,23 shl 8+55
ENDIF
		sub	dh,cl
		int	10h
		mov	edx,offset EXCP_MSG0A
		mov	ah,09h
		int	21h
		xor	ch,ch
		mov	bp,cx
		dec	bp
		shl	bp,2
		mov	cl,2
		call	PrintHex
		mov	al,2
		mov	dl,']'
		int	21h
		mov	dl,' '
		int	21h
		mov	ebp,[esp]
		mov	ebp,fs:[ebp]
		mov	cl,8
		call	PrintHex
		pop	ebp cx
		lea	ebp,[ebp-4]
		dec	cl
		jnz	excpt_showstack

IFDEF		DISASM
		mov	dx,15 shl 8
		mov	ah,2
		xor	bh,bh
		int	10h

		mov	cl,8
		mov	eax,[esp+40].ES_EIP
		mov	SegSize,16
		mov	Instruction_off,eax
		lar	eax,dword ptr [esp+40].ES_CS
		test	eax,00400000h
		jz	excpt_cont
		mov	SegSize,32
excpt_cont:	push	cx
		mov	bp,[esp+42].ES_CS
		mov	cl,4
		call	PrintHex
		mov	ah,2
		mov	dl,':'
		int	21h
		mov	ebp,Instruction_Off
		mov	ch,8
		cmp	SegSize,32
		setc	cl
		shr	ch,cl
		mov	cl,ch
		call	PrintHex
		mov	ah,2
		mov	dl,' '
		int	21h
		push	[esp+42].ES_CS
		push	Instruction_Off
		push	Instruction_Off
		call	UnAssemble
		mov	byte ptr ds:[di],'$'
		mov	edx,offset UBuf
		mov	ah,09h
		int	21h
		mov	edx,offset LineFeed
		int	21h
		pop	cx
		dec	cl
		jnz	excpt_cont
ENDIF
		mov	ah,2
		xor	bh,bh
		mov	dx,22 shl 8
		int	10h

		mov	ax,4C00h
		int	21h
		assume	ds:nothing
;
PrintSReg:	;      EDX = Offset to string...
		; SS:[EBP] = Selector
		mov	ah,09h
		int	21h
		push	ebp
		mov	bp,word ptr [ebp]
		mov	cl,4
		call	PrintHex
		pop	ebp
		movzx	eax,word ptr [ebp]
		mov	edx,offset EXCP_MSG05
		or	ax,ax
		jz	PSR_Exit
		mov	edx,offset EXCP_MSG04
		lsl	ebx,eax
		jnz	PSR_Exit
		push	ebx
		and	al,not 111b
		mov	esi,gdt_addr
		mov	ebx,es:[esi+eax+2]
		rol	ebx,8
		mov	bl,es:[esi+eax+7]
		push	ebp
		ror	ebx,8
		mov	ebp,ebx
		mov	cl,8
		mov	edx,offset EXCP_MSG07
		mov	ah,09h
		int	21h
		call	PrintHex
		pop	ebp
		xchg	[esp],ebp
		mov	cl,8
		mov	edx,offset EXCP_MSG08
		mov	ah,09h
		int	21h
		call	PrintHex
		pop	ebp
		mov	edx,offset EXCP_MSG09
		mov	ah,09h
		int	21h
		mov	ebx,[ebp]
		lar	ebp,ebx
		shr	ebp,8
		mov	cl,4
		call	PrintHex
		mov	edx,offset EXCP_MSG06
PSR_Exit:	mov	ah,09h
		int	21h
		mov	edx,offset LineFeed
		int	21h
		ret
;
Public		PrintHex
PrintHex:	; EBP = Number, CL = Width (max = 8)
		;push	 es edi esi
		;mov	 es,cs:zdata_sel
		;mov	 esi,cs:codebase

		;movzx	 edi,cs:YPos
		;imul	 di,di,160
		;add	 di,cs:XPos
		;add	 di,cs:XPos
		;lea	 edi,[edi+0B8000h]

		mov	ch,cl
		dec	cl
		not	cl

		;mov	 ah,cs:TextCol
		and	cl,7
		shl	cl,2
		shl	ebp,cl
PH_MainLoop:	xor	bx,bx
		shld	ebx,ebp,4
		shl	ebp,4
		;inc	 es:XPos[esi]
		;mov	 al,cs:HexTable[bx]
		mov	ah,2
		mov	dl,cs:HexTable[bx]
		int	21h
		;stos	 word ptr es:[edi]
		dec	ch
		jnz	PH_MainLoop
		;pop	 esi edi es
		ret
;
;exception_dpmi: mov	 ds,cs:data_sel
;		 assume  ds:_PMODE_TEXT
;
;		 mov	 ExceptionNro,cl
;		 mov	 eax,[esp+40+8]
		;mov	 ErrorCode,eax
		jmp	$
;
stack_overflow: cli
		smsw	ax
		test	al,1
		jz	sov_rm
		mov	es,cs:zdata_sel
		mov	dword ptr es:[0B8000h],'OS'
		jmp	$
sov_rm: 	push	0B800h
		pop	es
		mov	dword ptr es:[0],'OS'
		jmp	$
;
; Mode switch routines
;
		assume	ds:nothing
		align	16
r_rm2pm:	;  AX = New DS
		;  CX = New ES
		;  DX = New SS
		; EBX = New ESP
		;  SI = New CS
		; EDI = New EIP
		pushfd
		cli
		push	ax
		lgdt	fword ptr cs:gdt_limit
		lidt	fword ptr cs:idt_limit
		mov	eax,_cr3
		mov	cr3,eax
		mov	eax,cr0
		or	eax,80000001h
		mov	cr0,eax

		db	0EAh
		dw	r_rm2pm_pm
		dw	SEL_Code

r_rm2pm_pm:	pop	ds eax
		mov	ss,dx
		mov	esp,ebx
		mov	es,cx

		and	ah,0BFh
		push	ax
		popf
		push	eax esi edi

		xor	ax,ax
		mov	fs,ax
		mov	gs,ax
		iretd
;
		align	16
r_pm2rm:	;  AX = New DS
		;  CX = New ES
		;  DX = New SS
		;  BX = New SP
		;  SI = New CS
		;  DI = New IP
		pushf
		cli
		mov	ds,cs:data_sel
		assume	ds:_PMODE_TEXT
		pop	tempw0
		mov	tempw1,ax
		mov	ax,data_sel
		mov	es,ax
		mov	fs,ax
		mov	gs,ax
		mov	ss,ax
		mov	eax,cr0
		and	eax,7FFFFFFEh
		mov	cr0,eax
		lidt	fword ptr ds:rm_idt_limit
		db	0EAh
		dw	r_pm2rm_rm,_PMODE_TEXT
r_pm2rm_rm:	assume	ds:nothing
		mov	ds,tempw1
		mov	es,cx
		xor	ax,ax
		mov	fs,ax
		mov	gs,ax
		mov	ss,dx
		mov	sp,bx
		push	tempw0 si di
		iret
;
		align	16
v_rm2pm:	;  AX = New DS
		;  CX = New ES
		;  DX = New SS
		; EBX = New ESP
		;  SI = New CS
		; EDI = New EIP
		pushf
		cli
		push	cs
		pop	ds
		pop	ds:tempw0
		mov	ds:tempw1,ax
		mov	ds:tempw2,si
		mov	esi,ds:vcpi_struc_addr
		mov	ax,0DE0Ch
		int	67h
v_rm2pm_pm:	mov	ss,dx
		mov	esp,ebx

		mov	ds,cs:tempw1
		mov	es,cx
		xor	cx,cx
		mov	fs,cx
		mov	gs,cx
		pushfd
		mov	ax,cs:tempw0
		and	ah,0Fh
		and	word ptr [esp],0F000h	; Necessary?
		or	[esp],ax		; Necessary? (mov [esp],ax)
		push	dword ptr cs:tempw2
		push	edi
		iretd
;
		align	16
v_pm2rm:	;  AX = New DS
		;  CX = New ES
		;  DX = New SS
		;  BX = New SP
		;  SI = New CS
		;  DI = New IP
		pushf
		cli
		push	ax
		mov	ds,cs:zdata_sel
		mov	eax,cs:vcpi_msw_stack
		movzx	edi,di
		movzx	ebx,bx
		mov	dword ptr ds:[eax+00h],offset v_pm2vm_vm
		mov	dword ptr ds:[eax+04h],_PMODE_TEXT
		mov	ds:[eax+0Ch],ebx
		mov	ds:[eax+10h],dx
		mov	ds:[eax+14h],cx
		pop	word ptr ds:[eax+18h]
		pop	bx
		mov	word ptr ds:[eax+1Ch],0
		mov	word ptr ds:[eax+20h],0
		mov	ss,cs:zdata_sel
		mov	esp,eax

		mov	ax,0DE0Ch
		call	cs:[vcpi_call]
v_pm2vm_vm:
		push	bx si di
		iret
;
callback:	mov	ax,sp		; This is almost directly from Tran...
		push	ss ax

		push	gs fs ds es
		pushf

		cli
		cld

		mov	ebp,cs:pm_stacktop

		mov	eax,ebp
		sub	eax,cs:pm_stacklen
		cmp	eax,cs:pm_stackbase
		jb	stack_overflow
		.386C
		mov	cs:pm_stacktop,eax
		.386P

		mov	eax,ss
		add	eax,eax
		movzx	ebx,sp
		lea	ebx,[eax*8+ebx]

		mov	ax,SEL_ZData
		mov	dx,ax
		mov	si,SEL_Code
		mov	edi,offset cb_pm

		jmp	cs:[rm2pm_rout]
cb_pm:
		mov	edi,[esp+14]
		lea	esi,[esp+24]
		mov	ecx,8
		rep	movs dword ptr es:[edi],ds:[esi]

		mov	esi,esp
		mov	cx,5
		rep	movs word ptr es:[edi],ds:[esi]

		lods	dword ptr ds:[esi]
		add	ax,42
		mov	es:[edi+4],eax

		lea	edi,[edi-42]

		movzx	esi,ax
		shr	eax,12
		and	al,0F0h
		lea	esi,[esi+eax]

		xchg	esp,ebp
		pushfd
		db	66h
		push	cs
		dw	6866h,offset cb_back,0

		push	dword ptr [ebp+22]
		push	dword ptr [ebp+18]

		db	66h
		retf

cb_back:	cli
		cld

		mov	esi,edi
		push	es
		pop	ds

		mov	es,cs:zdata_sel
		movzx	ebx,ds:[esi]._sp
		movzx	edx,ds:[esi]._ss
		sub	bx,42

		mov	ebp,ds:[esi]._reserved
		mov	bp,bx

		lea	edi,[edx*8]
		lea	edi,[edi*2+ebx]

		mov	ecx,8
		rep	movs dword ptr es:[edi],ds:[esi]

		mov	eax,[esi+6]
		mov	es:[edi],eax

		mov	eax,ds:[esi+10]
		mov	es:[edi+4],eax
		mov	ax,ds:[esi]
		mov	es:[edi+8],ax

		mov	ax,[esi+4]
		mov	cx,[esi+2]

		mov	si,_PMODE_TEXT
		mov	di,offset cb_back_rm

		db	66h
		jmp	cs:[pm2rm_rout]

cb_back_rm:	mov	esp,ebp

		mov	eax,cs:pm_stacklen
		.386C
		add	cs:pm_stacktop,eax
		.386P

		popad
		pop	fs gs
		iret
;
; DOS-Extender routines
;
extender_api:	push	ds es fs gs
		pushad

		; Setup Temporary regs - using stack so re-entrancy is
		; possible... It must be...
		lea	esp,[esp-regs_size]
		mov	dword ptr ss:[esp]._sp,0

		push	bx
		mov	bx,dos_funcs
ext_findfunc:	cmp	cs:dos_func[bx-1],ah
		je	ext_find_it
		dec	bx
		jnz	ext_findfunc
		pop	bx
ext_chain:	lea	esp,[esp+regs_size]
		popad
		pop	gs fs es ds
		cmp	cs:pmode_type,3
		jne	ext_vxr
		jmp	cs:[dpmi_oldint21]
ext_vxr:	jmp	cs:[int_vectors+21h*4]

ext_find_it:	add	bx,bx
		mov	bx,cs:dos_rout[bx-2]
		xchg	bx,[esp]
		retn

;ret_dsdx:	 mov	 esi,offset regstruct._dx
;		 jmp	 ret_dsxx
ret_dsbx:	mov	esi,offset regstruct._bx
ret_dsxx:	mov	edx,offset regstruct._ds
		lea	ebp,[esp+regs_size+38]
		;jmp	 short ret_xsxx

ret_xsxx:	movzx	eax,word ptr es:[edi+edx]
		shl	eax,4
		movzx	ebx,word ptr es:[edi+esi]
		lea	eax,[eax+ebx]
		mov	word ptr ss:[ebp],SEL_ZData
		mov	ss:[esp+regs_size+esi],eax

ext_exit:	lea	esp,[esp+regs_size]
		popad
		pop	gs fs es ds
		iretd
;
dos43:		cmp	al,2
		jnb	ext_chain
dos39:
dos3A:
dos3B:
dos3C:
dos3D:
dos41:
dos4E:
		xor	al,al
		jmp	dos_x2
dos09:		; DS:EDX = String...
		mov	al,'$'
dos_x2: 	mov	esi,edx
		call	get_len
		push	offset d09_call
		call	dos_fillbuf
		mov	ax,[esp+regs_size]._ax
		cmp	ah,09h
		je	ext_exit
		test	es:[edi]._flags,1
		jnz	dos_reteax
		cmp	ah,4Eh
		je	dos_copydta
		cmp	ax,4300h
		jne	dos_ret_eax
		mov	ax,es:[edi]._cx
		mov	[esp+regs_size]._cx,ax
dos_ret_eax:	mov	eax,es:[edi]._eax
		mov	[esp+regs_size]._eax,eax
		jmp	dos_clearcarry
d09_call:	mov	es:[edi]._dx,0
		call	dos_call
		ret
;
dos1A:		mov	es,cs:data_sel
		mov	dword ptr es:[dta_addr],edx
		mov	word ptr es:[dta_addr+4],ds
		jmp	ext_exit
;
dos32:
dos1F:		mov	byte ptr [esp+regs_size]._reserved,1
		jmp	short dos_x1
dos1B:
dos1C:		mov	byte ptr [esp+regs_size]._reserved,0
dos_x1: 	call	copy_call
		mov	al,es:[edi]._al
		cmp	byte ptr [esp+regs_size]._reserved,1
		mov	[esp+regs_size]._al,al
		je	ret_dsbx
		movzx	ecx,es:[edi]._cx
		movzx	edx,es:[edi]._dx
		mov	[esp+regs_size]._ecx,ecx
		mov	[esp+regs_size]._edx,edx
		jmp	ret_dsbx
;
dos25:		mov	cx,ds
		mov	bl,al
		mov	ax,0205h
		int	31h
		jmp	ext_exit
;
dos2F:		xor	ax,ax
		or	ax,word ptr cs:[dta_addr+4]
		jz	dos2F_getdta
		mov	ebx,dword ptr cs:[dta_addr]
		mov	[esp+regs_size+36],ax
		mov	[esp+regs_size]._ebx,ebx
		jmp	ext_exit
dos34:
dos2F_getdta:	call	copy_call
ret_esbx:	mov	esi,offset regstruct._bx
ret_esxx:	lea	ebp,[esp+regs_size+36]
		mov	edx,offset regstruct._es
		jmp	ret_xsxx
;
dos35:		mov	bl,al
		mov	ax,0204h
		int	31h
cxedx_2_esebx:	mov	[esp+regs_size+36],cx
		mov	[esp+regs_size]._ebx,edx
		jmp	ext_exit
;
dos3F:		; DS:EDX = Destination
		;    ECX = Bytes to read
		push	ds
		pop	es
		mov	edi,edx
		xor	edx,edx

		push	offset d3F_read
		call	dos_flushbuf
		mov	[esp+regs_size]._eax,edx
		jmp	dos_clearcarry

d3F_read:	mov	es:[edi]._dx,0
		mov	es:[edi]._cx,cx
		call	dos_call
		movzx	eax,es:[edi]._ax
		test	es:[edi]._flags,1
		jnz	d3F_err_ret
		lea	edx,[edx+eax]
		ret
d3F_err_ret:	lea	esp,[esp+12]
		jmp	d3F40_error
;
dos40:		; DS:EDX = Source
		;    ECX = Bytes to read
		mov	esi,edx
		xor	edx,edx

		push	offset d40_write
		call	dos_fillbuf
		and	byte ptr [esp+regs_size+48],not 1
		mov	[esp+regs_size]._eax,edx
		jmp	ext_exit

d40_write:	mov	es:[edi]._dx,0
		mov	es:[edi]._cx,cx
		call	dos_call
		movzx	eax,es:[edi]._ax
		test	es:[edi]._flags,1
		jnz	d40_err_ret
		lea	edx,[edx+eax]
		ret
d40_err_ret:	lea	esp,[esp+regs_size+18]
d3F40_error:	mov	[esp+regs_size]._eax,eax
		jmp	dos_setcarry
;
dos47:		mov	ecx,64
		push	offset d47_check
		call	dos_flushbuf
		jmp	dos_clearcarry
d47_check:	mov	es:[edi]._si,0
		call	dos_call
		movzx	eax,es:[edi]._ax
		test	es:[edi]._flags,1
		jnz	d3F_err_ret
		mov	ax,64
		ret
;
dos48:		mov	ax,0100h
		int	31h
		jnc	dos48_ret_eax
dosmemm_eaxebx: movzx	ebx,bx
		mov	[esp+regs_size]._ebx,ebx
dos_4849_reteax:movzx	eax,ax
		mov	[esp+regs_size]._eax,eax
dos_setcarry:	or	byte ptr [esp+regs_size+48],1
		jmp	ext_exit
dos48_ret_eax:	movzx	eax,dx
		mov	[esp+regs_size]._eax,eax
dos_clearcarry: and	byte ptr [esp+regs_size+48],not 1
		jmp	ext_exit
;
dos49:		mov	dx,es
		mov	ax,0101h
		int	31h
		jnc	dos_4849_reteax
		mov	word ptr [esp+regs_size+36],0	  ; clear ES
		jmp	dos_clearcarry
;
dos4A:		mov	dx,es
		mov	ax,0102h
		int	31h
		jnc	dos_clearcarry
		jmp	dosmemm_eaxebx
;
dos4C:		mov	ds,cs:data_sel
		assume	ds:_PMODE_TEXT
		mov	ds:dexit_code,al

		cmp	pmode_type,3
		je	dos4C_dpmi

		mov	fs,zdata_sel
		mov	edx,memhandle_base
		mov	ebp,memhandle_last
dos4c_freemem:	or	ebp,ebp
		jz	dos4c_memfreed
		test	fs:[edx+ebp].MH_Flags,1
		jz	dos4c_fm_next
		;test	 fs:[edx+ebp].MH_Flags,10b
		;jnz	 dos4c_fm_next
		xor	si,si
		mov	edi,ebp
		shr	edi,4
		mov	ax,0502h
		int	31h
dos4c_fm_next:	lea	ebp,[ebp-10h]
		jmp	dos4c_freemem
dos4c_memfreed:
		mov	ax,_PMODE_TEXT
		mov	cx,ax
		mov	ebx,rm_stacklen
		mov	edx,rm_stacktop
		sub	edx,ebx
		mov	rm_stacktop,edx
		shr	edx,4
		mov	si,ax
		mov	di,offset dos4C_rm
		db	66h
		jmp	cs:[pm2rm_rout]

		assume	ds:_PMODE_TEXT
dos4C_rm:	cli
		mov	cl,08h
		cmp	pmode_type,2
		je	dos4C_vcpi_pic
		mov	ch,70h
                mov     dl,100b
                call    program_pic
		jmp	dos4C_pic_ok

dos4C_vcpi_pic: mov	ch,vcpi_pic_slave
                mov     dl,100b
                call    program_pic

		xor	bh,bh
		mov	ch,bh
		mov	bl,vcpi_pic_master
		mov	cl,vcpi_pic_slave
		mov	ax,0DE0Bh
		int	67h

dos4C_pic_ok:	push	ds
		or	OldInt15,0
		jz	dos4C_int15_ok
		lds	dx,OldInt15
		mov	ax,2515h
		int	21h
dos4C_int15_ok: .386C
		or	cs:OldInt21,0
		.386P
		jz	dos4C_int21_ok
		lds	dx,cs:OldInt21
                mov     ax,2521h
                pushf
                call    cs:[OldInt21]
dos4C_int21_ok: pop	ds

		mov	ah,4Ch
		mov	al,dexit_code
		int	21h

dos4C_dpmi:	push	ax
		mov	edx,dword ptr ds:[dpmi_oldint21]
		mov	cx,word ptr ds:[dpmi_oldint21+4]
		mov	bl,21h
		mov	ax,0205h
		int	31h
		pop	ax
		jmp	ds:[dpmi_oldint21]
		assume	DS:Nothing
;
dos4F:		call	copy_call
		test	es:[edi]._flags,1
		jnz	dos_reteax
dos_copydta:	call	copy_dta
		jmp	dos_clearcarry
dos_reteax:	movzx	eax,es:[edi]._ax
		mov	[esp+regs_size]._eax,eax
		jmp	dos_setcarry
;
dos56:		xor	al,al

		push	es edi
		call	get_len
		pop	edi es

		inc	cx
		push	ecx

		call	getlen

		inc	cx
		xchg	ecx,[esp]

		lea	ebx,[esp+4]
		push	ss
		pop	fs
		mov	ax,cs:rm_bufseg
		mov	fs:[ebx]._ah,56h
		mov	fs:[ebx]._di,cx
		mov	fs:[ebx]._dx,0
		mov	fs:[ebx]._ds,ax
		mov	fs:[ebx]._es,ax
		pushf
		pop	fs:[ebx]._flags

		mov	es,cs:zdata_sel
		mov	edi,cs:rm_bufbase
		mov	esi,edx
		rep	movs byte ptr es:[edi],ds:[esi]

		pop	ecx
		mov	esi,[esp+regs_size]._edi
		mov	ds,[esp+regs_size+36]
		rep	movs byte ptr es:[edi],ds:[esi]
		push	ss
		pop	es
		mov	edi,ebx

		call	dos_call

		test	es:[edi]._flags,1
		jz	dos_clearcarry
		jmp	dos_reteax
;
get_len:	; DS:EDX = string / whatever
		;     al = termination char
		push	ds
		pop	es
		mov	edi,edx
getlen: 	; ES:EDI = string / whatever
		;     al = termination char
		cld
		mov	ecx,-1
		repne	scas byte ptr es:[edi]
		inc	ecx
		not	ecx
		ret
;
dos_fillbuf:	;    ECX = Length of data in bytes...
		; DS:ESI = Data we want to buffer...
		;     AL = Character to put into last "entry"
		mov	ebp,ecx

		mov	es,cs:zdata_sel

d_fill: 	cld
		push	ax ebp
		mov	ebx,cs:rm_buflen
		cmp	ebp,ebx
		jae	d_fill_it
		mov	ebx,ebp

d_fill_it:	push	bx
		mov	edi,cs:rm_bufbase
		xor	ecx,ecx
		shr	bx,1
		setc	cl
		rep	movs byte ptr es:[edi],ds:[esi]
		shr	bx,1
		setc	cl
		rep	movs word ptr es:[edi],ds:[esi]
		mov	ecx,ebx
		rep	movs dword ptr es:[edi],ds:[esi]
		mov	es:[edi],al
		pop	bx

		push	esi es

		lea	esi,[esp+regs_size+16]
		lea	eax,[esp+16]

		call	copyregs

		mov	ax,cs:rm_bufseg
		mov	es:[edi]._ds,ax
		mov	es:[edi]._es,ax
		mov	es:[edi]._fs,ax
		mov	es:[edi]._gs,ax

		mov	cx,bx

		call	word ptr [esp+14]

		pop	es esi ebp ax	; ES pushed/popped just for security...
		sub	ebp,cs:rm_buflen
		jz	d_fill_exit
		jnc	d_fill
		push	ss
		pop	es
d_fill_exit:	retn	2
;
dos_flushbuf:	;    ECX = Bytes to "flush"...??
		; ES:EDI = Destination
		mov	ds,cs:zdata_sel
		mov	ebp,ecx

d_flush_it:	push	es edi
		mov	eax,cs:rm_buflen
		cmp	ebp,eax
		jae	d_cont
		mov	eax,ebp

d_cont: 	push	eax

		lea	esi,[esp+regs_size+14]
		lea	eax,[esp+14]
		call	copyregs

		pop	ecx

		mov	ax,cs:rm_bufseg
		mov	es:[edi]._ds,ax
		mov	es:[edi]._es,ax
		mov	es:[edi]._fs,ax
		mov	es:[edi]._gs,ax

		call	word ptr [esp+8]
		pop	edi es

		or	ax,ax
		jz	d_flush_exit

		cld
		mov	esi,cs:rm_bufbase
		xor	ecx,ecx
		shr	ax,1
		setc	cl
		rep	movs byte ptr es:[edi],ds:[esi]
		shr	ax,1
		setc	cl
		rep	movs word ptr es:[edi],ds:[esi]
		mov	ecx,eax
		rep	movs dword ptr es:[edi],ds:[esi]

		sub	ebp,cs:rm_buflen
		jz	d_flush_exit
		jnc	d_flush_it
d_flush_exit:	retn	2
;
copy_call:	lea	esi,[esp+regs_size+2]
		lea	eax,[esp+2]
		call	copyregs
;
dos_call:	; ES:EDI = Selector:Offset of real mode call structure
		mov	ax,0300h
		mov	bx,21h
		xor	cx,cx
		int	31h
		ret
;
copyregs:	; SS:ESI = source
		cld
		push	ss
		pop	es
		mov	edi,eax
		mov	ecx,8
		rep	movs dword ptr es:[edi],ss:[esi]
		mov	edi,eax
		pushf
		pop	es:[edi]._flags
		ret
;
copy_dta:	xor	ax,ax
		or	ax,word ptr cs:[dta_addr+4]
		jz	c_dta_exit

		mov	es,cs:zdata_sel
		lea	esi,[esp+regs_size]
		mov	eax,esp
		call	copyregs
		mov	es:[edi]._ah,2Fh
		call	dos_call
		movzx	esi,es:[edi]._es
		movzx	ebx,es:[edi]._bx
		shl	esi,1
		lea	esi,[esi*8+ebx]
		mov	ds,cs:zdata_sel

		les	edi,cs:dta_addr
		cld
		mov	ecx,43
		rep	movs byte ptr es:[edi],ds:[esi]
c_dta_exit:	ret
;
; DPMI Interface routines
;
		assume	ds:nothing
dpmi_api:	push	ds es fs gs
		pushad

		lea	esp,[esp-regs_size]
		mov	dword ptr [esp]._sp,0

		mov	ds,cs:zdata_sel

		push	bx
		mov	bx,dpmi_funcs*2
dpmi_findfunc:	sub	bx,2
		jc	dpmi_nofunc
		cmp	ax,cs:dpmi_func[bx]
		jne	dpmi_findfunc
		mov	bx,cs:dpmi_rout[bx]
		xchg	bx,[esp]
		retn

dpmi_nofunc:	pop	bx
		jmp	dos_setcarry
;
		; Allocate Descriptors
		; CX = Number of descriptors to allocate
dpmi0000:	movzx	esi,cs:gdt_limit
		mov	eax,cs:gdt_addr
		and	si,not 7
		mov	bx,cx
		jmp	d0000_checksel
d0000_tryagain: mov	cx,bx
d0000_findsels: lea	esi,[esi-8]
d0000_checksel: cmp	esi,(SYS_SELECTORS)*8
		jbe	dos_setcarry
		test	byte ptr ds:[eax+esi+6],10h
		jnz	d0000_tryagain
		dec	cx
		jnz	d0000_findsels
		lea	edx,[esi+eax]
		xor	eax,eax
		mov	ecx,00101200h
d0000_setupsel: mov	ds:[edx],eax
		mov	ds:[edx+4],ecx
		lea	edx,[edx+8]
		dec	bx
		jnz	d0000_setupsel
		mov	[esp+regs_size]._ax,si
		jmp	dos_clearcarry
;
		; Free Descriptor
		; BX = Selector to free
dpmi0001:	call	dpmi_testsel
		mov	word ptr ds:[esi+ebx+5],0
		lea	ebp,[esp+regs_size+40]
		xor	ax,ax
		mov	cl,4
		jmp	d0001_check
d0001_clearsel: dec	cl
		jz	dos_clearcarry
d0001_check:	sub	ebp,2
		cmp	[ebp],bx
		jne	d0001_clearsel
		mov	[ebp],ax
		jmp	d0001_clearsel
;
		; Segment to Descriptor
		; BX = Real mode segment address
dpmi0002:	xor	ax,ax
		mov	cx,1
		int	31h
		jc	dos_setcarry
		movzx	eax,ax
		movzx	ebx,bx
		shl	ebx,4
		mov	esi,cs:gdt_addr
		mov	word ptr ds:[esi+eax],0FFFFh
		mov	ds:[esi+eax+2],bx
		ror	ebx,8
		mov	ds:[esi+eax+4],bh
dpmi_ax:	mov	[esp+regs_size]._ax,ax
		jmp	dos_clearcarry
;
dpmi0003:	mov	ax,8
		jmp	dpmi_ax
;
dpmi0006:	call	dpmi_testsel
		mov	dx,ds:[esi+ebx+2]
		mov	cl,ds:[esi+ebx+4]
		mov	ch,ds:[esi+ebx+7]
dpmi_cxdx:	mov	[esp+regs_size]._dx,dx
dpmi_cx:	mov	[esp+regs_size]._cx,cx
		jmp	dos_clearcarry
;
dpmi0007:	call	dpmi_testsel
		mov	ds:[esi+ebx+2],dx
		mov	ds:[esi+ebx+4],cl
		mov	ds:[esi+ebx+7],ch
		jmp	dos_clearcarry
;
dpmi0008:	call	dpmi_testsel
		rol	ecx,16
		mov	cx,dx
		mov	dl,ds:[esi+ebx+6]
		and	dl,070h
		cmp	ecx,1024*1024
		jb	d0008_limok
		or	dl,80h
		shr	ecx,12
d0008_limok:	mov	ds:[esi+ebx],cx
		ror	ecx,8
		or	dl,ch
		mov	ds:[esi+ebx+6],dl
		jmp	dos_clearcarry
;
dpmi0009:	call	dpmi_testsel
		call	dpmi_testacc
		mov	dh,ds:[esi+ebx+6]
		and	dh,0Fh
		or	ch,dh
		mov	ds:[esi+ebx+5],cx
		jmp	dos_clearcarry
;
dpmi000A:	call	dpmi_testsel
		test	byte ptr ds:[esi+ebx+5],8
		jz	dos_setcarry
		test	byte ptr ds:[esi+ebx+5],4
		jnz	dos_setcarry
		test	byte ptr ds:[esi+ebx+5],2
		jz	dos_setcarry
		xor	ax,ax
		mov	cx,1
		int	31h
		jc	dos_setcarry
		movzx	eax,ax
		mov	ecx,ds:[esi+ebx]
		mov	dx,ds:[esi+ebx+6]
		mov	ds:[esi+eax],ecx
		mov	ds:[esi+eax+6],dx
		mov	cl,ds:[esi+ebx+4]
		mov	ds:[esi+eax+4],cl
		jmp	dpmi_ax
;
dpmi000B:	call	dpmi_testsel
		cld
		mov	ecx,2
		lea	esi,[esi+ebx]
		rep	movs dword ptr es:[edi],ds:[esi]
		jmp	dos_clearcarry
;
dpmi000C:	call	dpmi_testsel
		mov	cx,es:[edi+5]
		call	dpmi_testacc
		mov	eax,es:[edi]
		mov	dx,es:[edi+6]
		and	dl,0Fh
		or	dl,ch
		mov	ch,cl
		mov	cl,ds:[edi+4]
		mov	ds:[esi],eax
		mov	ds:[esi+4],cx
		mov	ds:[esi+6],dx
		jmp	dos_clearcarry
;
;dpmi0100:	 push	 ss
;		 pop	 es
;		 mov	 edi,esp
;		 mov	 es:[edi]._bx,bx
;		 mov	 es:[edi]._ah,48h
;		 mov	 bx,21h
;		 xor	 cx,cx
;		 mov	 ax,0300h
;		 int	 31h
;		 jc	 dos_setcarry
;		 test	 es:[edi]._flags,1
;		 jnz	 d0100_err
;		 mov	 cx,[esp+regs_size]._bx
;		 shr	 cx,12
;		 inc	 cx
;		 xor	 ax,ax
;		 int	 31h
;		 jc	 d0100_nosels
;		 mov	 bp,cx
;		 movzx	 esi,es:[edi]._ax
;		 shl	 esi,4
;		 mov	 si,es:[edi]._ax
;		 push	 bx
;d0100_setupsels:mov	 ecx,esi
;		 mov	 dx,si
;		 lea	 esi,[esi+10000h]
;		 rol	 ecx,16
;		 mov	 ax,7
;		 int	 31h
;		 xor	 cx,cx
;		 mov	 dx,0FFFFh
;		 inc	 al
;		 int	 31h
;		 inc	 al
;		 mov	 cx,10010010b
;		 int	 31h
;		 lea	 bx,[bx+8]
;		 dec	 bp
;		 jnz	 d0100_setupsels
;		 mov	 ax,es:[edi]._ax
;		 pop	 dx
;dpmi_dxax:	 mov	 [esp+regs_size]._dx,dx
;		 jmp	 dpmi_ax
;d0100_nosels:	 mov	 ax,es:[edi]._ax
;		 mov	 es:[edi]._ah,39h
;		 mov	 es:[edi]._es,ax
;		 xor	 cx,cx
;		 mov	 ax,0300h		 ; Reloaded because of future...
;		 int	 31h
;		 mov	 ax,8
;		 xor	 bx,bx
;d0100_err:	 mov	 ax,es:[edi]._ax
;		 mov	 bx,es:[edi]._bx
;dpmi_e_bxax:	 mov	 [esp+regs_size]._bx,bx
;dpmi_e_ax:	 mov	 [esp+regs_size]._ax,ax
;		 jmp	 dos_setcarry
;
dpmi0200:	xor	bh,bh
		shl	bx,2
		mov	dx,ds:[bx]
		mov	cx,ds:[bx+2]
		jmp	dpmi_cxdx
;
dpmi0201:	xor	bh,bh
		shl	bx,2
		mov	ds:[bx],dx
		mov	ds:[bx+2],cx
		jmp	dos_clearcarry
;
dpmi0202:	cmp	bl,20h
		jnb	dos_setcarry
		and	ebx,1Fh
		lea	ebx,[ebx*8+offset ExceptionVec]
		add	ebx,cs:codebase
		mov	cx,ds:[ebx+4]
		mov	edx,ds:[ebx]
		jmp	dpmi_cxedx
;
dpmi0203:	cmp	bl,20h
		jnb	dos_setcarry
		and	ebx,1Fh
		lea	ebx,[ebx*8+offset ExceptionVec]
		add	ebx,cs:codebase
		mov	ds:[ebx+4],cx
		mov	ds:[ebx],edx
		jmp	dos_clearcarry
;
dpmi0204:	movzx	ebx,bl
		shl	bx,3
		add	ebx,cs:idt_addr
		mov	dx,ds:[ebx+6]
		mov	cx,ds:[ebx+2]
		rol	edx,16
		mov	dx,ds:[ebx]
dpmi_cxedx:	mov	[esp+regs_size]._edx,edx
		jmp	dpmi_cx
;
dpmi0205:	mov	bx,cx
		call	dpmi_testsel
		xor	ebx,ebx
		mov	bl,[esp+regs_size]._bl
		shl	bx,3
		add	ebx,cs:idt_addr
		mov	ds:[ebx],dx
		rol	edx,16
		mov	ds:[ebx+2],cx
		mov	ds:[ebx+6],dx
		jmp	dos_clearcarry
;
dpmi0300:	xor	bh,bh
		shl	bx,2
		mov	ebp,ds:[bx]
		jmp	dpmi030x012
dpmi0301:
dpmi0302:	mov	ebp,dword ptr es:[edi]._ip
dpmi030x012:	mov	esi,cs:codebase

		or	dword ptr es:[edi]._sp,0
		jz	d030x012_provide_stack
		movzx	ebx,word ptr es:[edi]._sp
		movzx	edx,word ptr es:[edi]._ss
		lea	edx,[edx+edx]
		lea	edx,[edx*8]
		jmp	d030x012_cstk
d030x012_provide_stack:
		mov	edx,cs:rm_stacktop
		mov	ebx,cs:rm_stacklen
		sub	edx,ebx
		cmp	edx,cs:rm_stackbase
		jb	dos_setcarry
		mov	ds:rm_stacktop[esi],edx
d030x012_cstk:	lea	esi,[edx+ebx]
		shr	edx,4

		movzx	ecx,cx

		push	ecx

		add	ecx,ecx

		lea	bx,[bx-(2Eh+4+2+6)]
		sub	bx,cx

		lea	esi,[esi-(2Eh+4+2+6)]
		sub	esi,ecx

		xchg	esi,edi
		push	es
		mov	es,cs:zdata_sel
		pop	ds

		mov	ecx,8
		rep	movs dword ptr es:[edi],ds:[esi]
		mov	ax,ds:[esi]
		lea	esi,[esi+2]
		mov	cl,2
		rep	movs dword ptr es:[edi],ds:[esi]
		mov	es:[edi],ebp
		db	66h,0B9h
		dw	d030x012_brm
		dw	_PMODE_TEXT
		mov	es:[edi+4],ecx
		lea	edi,[edi+8]

		cmp	byte ptr [esp+regs_size+4]._al,1
		je	d0301
		stos	word ptr es:[edi]
d0301:
		pop	ecx
		lea	esi,[esp+regs_size+52]
		rep	movs word ptr es:[edi],ss:[esi]
		mov	es:[edi],esp
		mov	es:[edi+4],ss

		mov	si,_PMODE_TEXT
		mov	di,offset d030x012_rm
		db	66h
		jmp	cs:[pm2rm_rout]
d030x012_rm:	popad
		pop	es ds fs gs
		retf
d030x012_brm:	push	gs fs ds es
		pushf
		pushad
		movzx	ebp,sp
		mov	ebx,ss
		add	ebx,ebx
		lea	ebx,[ebx*8+ebp]
		mov	ax,SEL_ZData
		mov	dx,ax
		mov	cx,SEL_Data
		mov	si,SEL_Code
		mov	edi,offset d030x012_pm
		jmp	cs:[rm2pm_rout]

d030x012_pm:	mov	esi,esp
		mov	ss,[esi+46]
		mov	esp,[esi+42]
		cld
		mov	edi,[esp+regs_size]._edi
		mov	es,[esp+regs_size+36]
		mov	ecx,2Ah/2
		rep	movs word ptr es:[edi],ds:[esi]

		or	dword ptr es:[edi-2Ah]._sp,0
		jnz	dos_clearcarry
		mov	ds,cs:data_sel
		mov	eax,ds:rm_stacklen
		add	ds:rm_stacktop,eax
		jmp	dos_clearcarry
;
dpmi0303:	; DS:ESI = Sel:Offset to procedure... (Note: DS is trashed)
		; ES:EDI = Sel:Offset to rm struc...
		mov	ebx,cs:callbacks_base
		mov	cx,cs:callbacks
d0303_findcb:	or	cx,cx
		jz	dos_setcarry
		dec	cx
		or	ds:[ebx].CB_CS,0
		jz	d0303_found
		lea	ebx,[ebx+25]
		jmp	d0303_findcb
d0303_found:	mov	cx,[esp+regs_size+38]
		mov	ds:[ebx].CB_EIP,esi
		mov	ds:[ebx].CB_CS,cx
		mov	ds:[ebx].CB_ES,es
		mov	ds:[ebx].CB_EDI,edi
		mov	dx,bx
		and	dx,0Fh
		mov	ecx,ebx
		shr	ecx,4
		jmp	dpmi_cxdx
;
dpmi0304:	and	ecx,0FFFFh
		and	edx,0FFFFh
		add	ecx,ecx
		lea	ecx,[ecx*8+edx]
		cmp	ecx,cs:callbacks_base
		jb	dos_setcarry
		cmp	ecx,cs:callbacks_top
		ja	dos_setcarry
		cmp	word ptr ds:[ecx],6066h
		jne	dos_setcarry
		mov	ds:[ecx].CB_CS,0
		jmp	dos_clearcarry
;
dpmi0305:	xor	ax,ax
		mov	bx,_PMODE_TEXT
		mov	cx,offset rm_saverestore
		mov	si,SEL_Code
		mov	edi,offset pm_saverestore
dpmi_nopop_cfz: lea	esp,[esp+regs_size+38]
		pop	ds
		and	byte ptr [esp+regs_size+8],not 1
		iretd
;
dpmi0306:	mov	bx,_PMODE_TEXT
		mov	cx,word ptr rm2pm_rout
		mov	si,SEL_Code
		mov	edi,dword ptr pm2rm_rout
		jmp	dpmi_nopop_cfz
;
dpmi0400:	mov	ax,90
		mov	bx,1
		cmp	cs:pmode_type,2
		sete	cl
		add	cl,cl
		or	bl,cl
		mov	cl,cs:cpu_type
		mov	dx,cs:picvecs
		jmp	dpmi_nopop_cfz
;
dpmi0501:	; BX:CX = memory to allocate
		mov	fs,cs:data_sel
		rol	ebx,16
		mov	bx,cx
		lea	ebx,[ebx+4093]
		and	ebx,not 4093
		jz	dos_setcarry
		mov	ebp,cs:memhandle_base
		mov	edi,cs:memhandle_first
		or	edi,edi
		jz	dos_setcarry
		xor	esi,esi
dpmi_am_find:	test	ds:[esi+ebp].MH_Flags,1
		jz	dpmi_am_next
		test	ds:[esi+ebp].MH_Flags,100b
		jnz	dpmi_am_next
		mov	eax,ds:[esi+ebp].MH_Size
		sub	eax,ebx
		jc	dpmi_am_next
		;jne	 dpmi_am_setit
		;test	 ds:[esi+ebp].MH_Flags,10b
		;jnz	 dpmi_am_setit
		;mov	 edi,esi
dpmi_am_setit:	push	eax ebx esi edi ebp
		add	eax,ds:[esi+ebp].MH_BaseAddress
		mov	esi,eax
		shr	esi,10
		and	si,not 3
		add	esi,cs:pagetable_base
		mov	ecx,ebx
		shr	ecx,10
		lea	ecx,[ecx+esi]
		cmp	ecx,cs:pagetable_top
		jnb	dpmi_err1
		; EAX = BaseAddress (linear), EBX = Size, ESI = Offs to ptable
		call	cs:[memman_alloc]
		pop	ebp edi esi ebx eax
		mov	ds:[edi+ebp].MH_Handle,ecx
		jc	dos_setcarry
		mov	ds:[esi+ebp].MH_Size,eax
		add	eax,ds:[esi+ebp].MH_BaseAddress
		and	ax,0F000h
		push	eax
		or	al,5
		mov	ds:[edi+ebp].MH_Size,ebx
		mov	ds:[edi+ebp].MH_BaseAddress,eax
		mov	ax,ds:[esi+ebp].MH_Nextlink
		mov	ds:[edi+ebp].MH_Nextlink,ax
		mov	eax,esi
		shr	eax,4
		mov	ds:[esi+ebp].MH_Backlink,ax
		cmp	memhandle_first,edi
		jne	dpmi_am_mhl
		mov	esi,edi
dpmi_am_mhf_fnd:lea	esi,[esi+16]
		lea	ebx,[esi+ebp]
		test	ds:[ebx].MH_Flags,1
		jnz	dpmi_am_mhf_f
		mov	fs:memhandle_first,esi
		jmp	dpmi_am_mhl
dpmi_am_mhf_f:	cmp	ebx,memhandle_top
		jb	dpmi_am_mhf_fnd
		mov	fs:memhandle_first,esi
dpmi_am_mhl:	cmp	memhandle_last,edi
		ja	dpmi_am_exit
		mov	fs:memhandle_last,edi
dpmi_am_exit:	shr	edi,4
		pop	ebx
		mov	cx,bx
		rol	ebx,16
dpmi_e_bxcxsidi:mov	[esp+regs_size]._bx,bx
		mov	[esp+regs_size]._cx,cx
		mov	[esp+regs_size]._si,si
		mov	[esp+regs_size]._di,di
		jmp	dos_clearcarry
dpmi_am_next:	lea	esi,[esi+16]
		cmp	esi,cs:memhandle_last
		jb	dpmi_am_find
		jmp	dos_setcarry
dpmi_err1:	lea	esp,[esp+5*4]
		jmp	dos_setcarry
;
dpmi0502:	; SI:DI = Handle
		and	edi,0FFFFh
		mov	ebp,cs:memhandle_base
		shl	edi,4
		test	ds:[edi+ebp].MH_Flags,1
		jz	dos_setcarry
		test	ds:[edi+ebp].MH_Flags,010b
		jnz	dos_setcarry
		test	ds:[edi+ebp].MH_Flags,100b
		jz	dos_setcarry
		call	cs:[memman_free]
		movzx	esi,ds:[edi+ebp].MH_NextLink
		shl	esi,4
		jz	d0502_cont
		test	ds:[esi+ebp].MH_Flags,100b
		jnz	d0502_cont
		mov	eax,ds:[esi+ebp].MH_Size
		mov	ds:[esi+ebp].MH_Flags,0
		add	ds:[edi+ebp].MH_Size,eax
		xor	esi,esi
d0502_cont:	mov	ecx,cs:codebase
		shr	esi,4
		movzx	eax,ds:[edi+ebp].MH_BackLink
		shl	eax,4
		mov	ebx,ds:[edi+ebp].MH_Size
		mov	ds:[eax+ebp].MH_NextLink,si
		add	ds:[eax+ebp].MH_Size,ebx
		mov	ds:[edi+ebp].MH_Flags,0
		cmp	edi,cs:memhandle_first
		ja	d0502_cont2
		mov	ds:memhandle_first[ecx],edi
d0502_cont2:	cmp	edi,cs:memhandle_last
		jb	dos_clearcarry
d0502_findlast: sub	edi,16
		jc	dos_clearcarry
		test	ds:[edi+ebp].MH_Flags,1
		jz	d0502_findlast
		mov	ds:memhandle_last[ecx],edi
		jmp	dos_clearcarry
;
dpmi0503:	; SI:DI = Handle
		jmp	dos_setcarry
;
dpmi0900:	mov	al,[esp+regs_size+48]
		and	al,1
		and	byte ptr [esp+regs_size+48],not 1
		jmp	dpmi_nopop_cfz
;
dpmi0901:	mov	al,[esp+regs_size+48]
		and	al,1
		or	byte ptr [esp+regs_size+48],1
		jmp	dpmi_nopop_cfz
;
dpmi0902:	mov	al,[esp+regs_size+48]
		and	al,1
		jmp	dpmi_nopop_cfz
;
;dpmi0B00:	 ; Set Debug Watchpoint
;		 ; BX_CX = Linear address of watchpoint
;		 ;    DL = Size of watchpoint
;		 ;    DH = Type of watchpoint
;		 jmp	 dos_setcarry
;
;dpmi0B01:	 ; Clear Debug Watchpoint
;		 ; BX = Debug wathcpoint handle
;		 jmp	 dos_setcarry
;
;dpmi0B02:	 ; Get State of Debug Watchpoint
;		 ; BX = Handle
;		 jmp	 dos_setcarry
;
;dpmi0B03:	 ; Reset Debug Watchpoint
;		 ; BX = Handle
;		 jmp	 dos_setcarry
;
rm_saverestore: retf
pm_saverestore:
retfar32b:	db	66h
		retf
;
dpmi_testsel:	pop	bp
		movzx	ebx,bx
		cmp	bx,SYS_SELECTORS*8
		jna	dos_setcarry
		cmp	bx,cs:gdt_limit
		ja	dos_setcarry
		mov	esi,cs:gdt_addr
		test	byte ptr ds:[esi+ebx+6],10h
		jz	dos_setcarry
		jmp	bp
;
dpmi_testacc:	pop	bp
		test	ch,20h
		jnz	dos_setcarry
		or	ch,10h
		test	cl,10h
		jz	dos_setcarry
		test	cl,60h
		jnz	dos_setcarry
		test	cl,8
		jz	dpmi_acc_ok
		test	cl,2
		jz	dos_setcarry
		test	cl,4
		jnz	dos_setcarry
		and	ch,0F0h
dpmi_acc_ok:	jmp	bp
;
vcpi_alloc:	; EAX = BaseAddress (linear), EBX = Size, ESI = Offs to ptable
		shr	ebx,12
		mov	ecx,ebx
		mov	edi,esi
vcpi_allocloop: mov	ax,0DE04h
		call	cs:[vcpi_call]
		or	ah,ah
		jnz	vcpi_afree
		and	dx,0F000h
		or	dl,7
		mov	ds:[esi],edx
		lea	esi,[esi+4]
		dec	ebx
		jnz	vcpi_allocloop
		clc
		ret
vcpi_afree:	cmp	ecx,ebx
		jbe	vcpi_aerr
		xor	edx,edx
		xchg	edx,ds:[edi]
		and	dx,0F000h
		mov	ax,0DE05h
		call	cs:[vcpi_call]
		lea	edi,[edi+4]
		dec	ecx
		jmp	vcpi_afree
vcpi_aerr:	stc
		ret
;
xms_alloc:	; EAX = BaseAddress (linear), EBX = Size, ESI = Offs to ptable
		lea	edi,[esp+22]
		push	ss
		pop	es
		mov	edx,cs:XMSControl
		mov	es:[edi]._ah,89h
		mov	dword ptr es:[edi]._ip,edx
		xor	cx,cx
		lea	edx,[ebx+3072]
		shr	edx,10
		mov	es:[edi]._edx,edx
		mov	ax,0301h
		int	31h
		jc	xms_aerr2
		cmp	es:[edi]._ax,1
		jne	xms_aerr2
		mov	bp,es:[edi]._dx
		mov	es:[edi]._ah,0Ch
		;mov	 ax,0301h
		int	31h
		jc	xms_aerr
		cmp	es:[edi]._ax,1
		jne	xms_aerr
		mov	dx,es:[edi]._dx
		rol	edx,16
		mov	dx,es:[edi]._bx
		and	dx,not 4095
		shr	ebx,12
		or	dl,7
xms_setptable:	mov	ds:[esi],edx
		lea	esi,[esi+4]
		lea	edx,[edx+4096]
		dec	ebx
		jnz	xms_setptable
		mov	cx,bp
		clc
		ret
xms_aerr:	mov	es:[edi]._ah,0Ah
		mov	ax,0301h
		int	31h
xms_aerr2:	stc
		ret
;
raw_alloc:	; EAX = BaseAddress (linear), EBX = Size, ESI = Offs to ptable
		add	eax,cs:raw_extadd
		shr	ebx,12
		or	al,7
raw_allocloop:	mov	ds:[esi],eax
		lea	eax,[eax+4096]
		lea	esi,[esi+4]
		dec	ebx
		jnz	raw_allocloop
		clc
		ret
;
raw_free:
vcpi_free:	mov	ebx,ds:[edi+ebp].MH_Size
		mov	esi,ds:[edi+ebp].MH_BaseAddress
		shr	ebx,12
		shr	esi,10
		and	si,not 3
		add	esi,cs:pagetable_base
vcpi_freeit:	xor	edx,edx
		xchg	edx,ds:[esi]
		and	dx,0F000h
		mov	ax,0DE05h
		call	cs:[vcpi_call]
		lea	esi,[esi+4]
		dec	ebx
		jnz	vcpi_freeit
		ret
;
xms_free:	push	edi
		mov	eax,cs:[XMSControl]
		mov	dx,word ptr ds:[edi+ebp].MH_Handle
		lea	edi,[esp+6]
		push	ss
		pop	es
		mov	es:[edi]._dx,dx
		mov	es:[edi]._ah,0Dh
		mov	dword ptr es:[edi]._ip,eax
		xor	cx,cx
		mov	ax,0301h
		int	31h
		mov	es:[edi]._ah,0Ah
		;mov	 ax,0301h	 ; I know - reloaded...
		int	31h
		pop	edi
		jmp	vcpi_free
;
memm_addhandle: ; EBX = Base address, EDX = Size
		push	es
		mov	eax,ds:memhandle_base
		add	eax,ds:memhandle_first
		cmp	eax,ds:memhandle_top
		jae	memm_ah_exit
		add	ds:memhandle_first,10h
		add	ds:memhandle_last,10h
		shr	eax,4
		mov	es,ax
		or	bl,1
		mov	es:MH_BaseAddress,ebx
		mov	es:MH_Size,edx
memm_ah_exit:	pop	es
		ret
;
exitdos:	mov	ax,4CFFh
		int	21h
;
_PMODE_TEXT	EndS
;۲۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲۲
		End
