; TENIE REMMEL

; Here are some very tiny hex filters (bin2hex 69 bytes, hex2bin 72 bytes) 
; that I wrote.  They use the undocumented variants of AAM and AAD (you 
; can add a byte operand instead of the default 0Ah) so will not work on 
; some old chips such as the V30, but who has those anymore?? 
 
;*******************************************************; 
;* Bin2Hex.ASM -- Tiny 69-byte binary to hex converter *;  
;*******************************************************; 
 
Ideal                
 
Macro       AAME op1 
 
            db 0D4h 
            db op1 
 
EndM 
 
Model Tiny 
CodeSeg 
P186 
Org 100h 
 
Proc        Program 
 
            mov ah,3Fh         ;Read file/device 
            xor bx,bx          ;handle for STDIN 
            mov dx,34816       ;Start at DS:34K 
            mov cx,30240       ;30K bytes (max) 
            int 21h            ;DOS services 
            jc Exit            ;Error? 
            mov cx,ax          ;Number of bytes in CX 
             
            mov si,34816       ;SI = 34K 
            mov di,1024        ;DI = 1K 
 
InpLoop:    lodsb              ;Load byte 
            aame 10h           ;AAME to unpack digits 
             
            add al,90h         ;Allison's algorithm 
            daa                ;for converting a 
            adc al,40h         ;binary byte to hex 
            daa 
             
            xchg al,ah         ;Get other digit 
            add al,90h         ;Allison's algorithm 
            daa 
            adc al,40h 
            daa 
            stosw              ;Store digits 
             
            inc bx             ;Inc line counter 
            cmp bx,32          ;32 bytes? 
            jl Next            ;If not, loop back 
            xor bx,bx          ;Zero line counter 
            mov ax,0A0Dh       ;Output a CRLF 
            stosw 
 
Next:       loop InpLoop       ;Loop back 
             
            mov ah,40h         ;Write file/device 
            mov bx,1           ;handle for STDOUT 
            mov cx,di          ;Number of bytes 
            mov dx,1024        ;Start at DS:1K 
            sub cx,dx          ;Adjust bytes 
            int 21h            ;DOS services 
             
Exit:       ret                ;Exit 
 
EndP        Program 
 
End Program 
 
;*******************************************************; 
;* Hex2Bin.ASM -- Tiny 72-byte hex to binary converter *;  
;*******************************************************; 
 
Ideal                
 
Macro       AADE op1 
 
            db 0D5h 
            db op1 
 
EndM 
 
Model Tiny 
CodeSeg 
P186 
Org 100h 
 
Proc        Program 
 
            mov ah,3Fh         ;Read file/device 
            xor bx,bx          ;handle for STDIN 
            mov dx,1024        ;Start at DS:1K 
            mov cx,62464       ;61K bytes (max) 
            int 21h            ;DOS services 
            jc Exit            ;Error? 
            mov cx,ax          ;Number of bytes in CX 
             
            mov si,1024        ;SI, DI = 1K 
            mov di,si 
 
InpLoop:    lodsb              ;Load byte 
            cmp al,'0'         ;0-9? 
            jl Next 
            cmp al,'9' 
            jle IsDigit 
            cmp al,'A'         ;A-F? 
            jl Next 
            cmp al,'F' 
            jg Next 
             
            sub al,7           ;Was A-F, subtract 7 
 
IsDigit:    sub al,'0'         ;Make it binary 
            test bx,bx         ;Nextdigit flag set? 
            jz First           ;If not, jump 
             
            aade 10h           ;AADE to pack the digits

            stosb              ;Store byte 
            dec bx             ;Clear nextdigit flag 
            jmp Next           ;Loop back 
 
First:      mov ah,al          ;Put digit in AH 
            inc bx             ;Set nextdigit flag 
 
Next:       loop InpLoop       ;Loop back 
             
            mov ah,40h         ;Write file/device 
            mov bx,1           ;handle for STDOUT 
            mov cx,di          ;Number of bytes 
            mov dx,1024        ;Start at DS:1K 
            sub cx,dx          ;Adjust CX 
            int 21h            ;DOS services 
             
Exit:       ret                ;Exit 
 
EndP        Program 
 
End Program 
