;-----------------------------------------------------------------------------             
; chkdisk.asm   Check for presence of disk in drive                                                    
;               Avoids having to use an int 24 handler  
;               Works with both floppy and ram drives.
;                 
.model   small
.stack   200h  

.data

buffer        db           500 dup(?)           ; set up a buffer, do NOT
                                                ; reduce size
not_there     db           'Disk not present.$'
there         db           'Disk present.$'

.code

start:             
             mov          ax,@data
             mov          ds,ax
             push         ds            ; save all required registers
             mov          ax,seg buffer ; point ds:bx to the buffer
             mov          ds,ax
             mov          dx,63         ; logical sector number
                                        ; 63 is the first sector of track
                                        ; 3 on side 1
             mov          al,1          ; read drive b:
             mov          cx,1          ; no. of sectors to read
             int          25h           ; READ absolute sectors
             pop          cx            ; pop flags from stack to any register
             pop          ds            ; restore registers
             jnc          disk_present  ; carry flag set if problem with drive
no_disk:
             mov          dx,offset not_there
             mov          ah,9
             int          21h
             mov          ax,4c01h      ; terminate with error code of 1
             int          21h           ; to possibly pass errorlevel to
                                        ; batch files

disk_present:                           ; int 25h
                                        ; return CF
                                        ;        AH
                                        ;           01h bad command
                                        ;           02h bad address mark
                                        ;           03h write-protected disk
                                        ;
             mov          dx,offset there
             mov          ah,9
             int          21h

exit:
             mov          ax,4c00h
             int          21h

end          start


