;---------------------------------------------------------------------
; GEN_FONT.ASM -- Generate font file for Tetris Deluxe
; Run GEN_FONT.COM to generate TETRIS.FN1
;---------------------------------------------------------------------
; To construct TETRIS.DAT (TETRIS.FNT must exist):
;   GEN_PCS
;   GEN_FONT
;   COPY /B TETRIS.FN1+TETRIS.PCS TETRIS.DAT
;   DEL TETRIS.FN1
;   DEL TETRIS.PCS
;---------------------------------------------------------------------

.Model Tiny
.Code
Org 100h
Start:      mov ax,3D00h            ;Open input file
            mov dx,offset InFile
            int 21h
            xchg bx,ax              ;BX = handle

            mov ah,3Fh              ;Read file
            mov cx,14*256
            mov dx,offset Buffer
            int 21h

            mov ah,3Eh              ;Close file
            int 21h

;---------------------------------------------------------------------

            mov si,offset Buffer    ;SI = in, DI = out
            mov di,offset OutBuf

            xor ah,ah               ;Count = 0

EncLoop:    lodsb                   ;Get byte
            test al,al              ;Zero?
            jz EncZero

            test ah,ah              ;Any zeros pending?
            jz EncSkip

            push ax                 ;Save AX
            xor al,al               ;Output RLE code
            stosw
            pop ax                  ;Restore AX

EncSkip:    stosb                   ;Store byte
            xor ah,ah               ;Zero AH
            jmp EncLb

EncZero:    inc ah                  ;Increment count
            cmp ah,255              ;Too big?
            jb EncLb

            stosw                   ;Output RLE code
            xor ah,ah               ;Zero AH

EncLb:      loop Encloop            ;Loop back

            test ah,ah              ;Any zeros pending?
            jz EncTerm

            xor al,al               ;Output RLE code
            stosw

EncTerm:    xor ax,ax               ;Output terminator
            stosw

;---------------------------------------------------------------------

            mov ah,3Ch              ;Create the output file
            xor cx,cx
            mov dx,offset OutFile
            int 21h
            xchg bx,ax              ;BX = handle

            mov ah,40h              ;Write out compressed data
            mov dx,offset OutBuf
            mov cx,di               ;CX = size
            sub cx,dx
            int 21h

            mov ah,3Eh              ;Close the file
            int 21h

            mov ax,4C00h            ;Return
            int 21h

;---------------------------------------------------------------------

InFile      db 'TETRIS.FNT',0
OutFile     db 'TETRIS.FN1',0

Buffer      db 3584 dup(?)
OutBuf:

End Start
