/*Copyright (C) 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* apled.h APL2 V1.0.0 **************************************************
* This structure it used in the DEL editor to represent the doubly      *
* linked list of structures for function statements.                    *
************************************************************************/
#if !defined(APLED_INCL)
#define APLED_INCL
typedef struct apled *Apled;
struct apled {
	Apled aplednxt;	/* Next in doubly-linked list.   		*/
	Apled apledlst;	/* Prior in doubly-linked list.   		*/
	double apledst;	/* Statement number. Header is always zero.	*/
	int apledtm;		/* =1 if apledhd tokens are freed with apled.*/
	int apledcn;		/* Count of tokens in statement.			*/
	Apltoken apledhd;	/* Ptr to rightmost token for stmt.	*/
	char *apledch;		/* Formatted statement. Used in apledfx.	*/
};
/* apledst **************************************************************
* This structure it used in the DEL editor to contain various things    *
* in common to all the DEL editor subroutines.                          *
************************************************************************/
typedef struct apledst *Apledst;
struct apledst { 			/* edhdr, edlst m/b first.			*/
	Apled edhdr;			/* Statement list header.			*/
	Apled edlst;			/* Statement list tail.   			*/
	struct aplfunc *fp;		/* Temporary function definition.		*/
	Apltoken delptr;		/* Not NULL if end of line was DEL.		*/
	Apled cured;			/* Statement most recently done.		*/
	double aplstinc;		/* Statement number increment.		*/
};
#endif
