/* Copyright (C) 1995 by Thomas Glen Smith.  All Rights Reserved. */
/* formincl.h APL2 V1.0.0 **********************************************
* Generates the specified includes.                                    *
***********************************************************************/
#if !defined(FORM_INCL)
#define FORM_INCL
/***********************************************************************
* bca is an array of character pointers passed as an argument to       *
* formats.                                                             *
***********************************************************************/
#define BCALEN 8 /* number of pointers in array bca */
#define SOF 0
#define START_OF_FIELD(A)   (*(A + SOF)) /* Start of string. */
#define Start_Of_Field      (*(bca + SOF))
#define ENF 1
#define END_OF_FIELD(A)     (*(A + ENF)) /* End of string. */
#define End_Of_Field        (*(bca + ENF))
#define FDI 2
#define FIRST_DIGIT(A)      (*(A + FDI)) /* First digit. */
#define First_Digit         (*(bca + FDI))
#define DPA 3
#define DECIMAL_POINT(A)    (*(A + DPA)) /* Decimal point. */
#define Decimal_Point       (*(bca + DPA))
#define EFS 4
#define E_FORMAT_SYMBOL(A)  (*(A + EFS)) /* E-format symbol. */
#define E_Format_Symbol     (*(bca + EFS))
#define LPZ 5
#define LEFT_PAD_ZEROS(A)   (*(A + LPZ)) /* Leftmost 9, 0 left of DP */
#define Left_Pad_Zeros      (*(bca + LPZ))
#define RPZ 6
#define RIGHT_PAD_ZEROS(A)  (*(A + RPZ)) /* Rightmost 9, 0 right of DP */
#define Right_Pad_Zeros     (*(bca + RPZ))
#define LDI 7
#define LAST_DIGIT(A)       (*(A + LDI)) /* Last digit. */
#define Last_Digit          (*(bca + LDI))
/***********************************************************************
* bia is an array of integers passed as an argument to formats.        *
***********************************************************************/
#define BIALEN 4 /* number of integers in array bia */
#define FLE 0
#define FIELD_LENGTH(A)     (*(A + FLE)) /* Length of string. */
#define Field_Length        *(bia + FLE)
#define DIG 1
#define DIGITS(A)           (*(A + DIG)) /* Digits left of decimal point. */
#define DIgits              (*(bia + DIG))
#define PLA 2
#define PLACES(A)           (*(A + PLA)) /* Digits right of decimal point. */
#define PLAces              (*(bia + PLA))
#define FCF 3
#define FCCFLAGS(A)         (*(A + FCF)) /* Format Control Character flags.*/
#define Fccflags            (*(bia + FCF))
/***********************************************************************
* Format Control Character (FCC) flags definitions.                    *
***********************************************************************/
#define FC0           1
     /* Pad with 0's to the position of the outermost 0. If the value
        is zero, the position is filled with 0's.
     */
#define FC1L          2
     /* Format Control Character '1' applies to the left side of the
        decimal point: Float the decorator against the number only if
        the value is negative.
     */
#define FC1R          4
     /* Format Control Character '1' applies to the right side of the
        decimal point: Float the decorator against the number only if
        the value is negative.
     */
#define FC2L          8
     /* Format Control Character '2' applies to the left side of the
        decimal point: Float the decorator against the number only if
        the value is positive.
     */
#define FC2R         16
     /* Format Control Character '2' applies to the right side of the
        decimal point: Float the decorator against the number only if
        the value is positive.
     */
#define FC3L         32
     /* Format Control Character '3' applies to the left side of the
        decimal point: Float the decorator against the number.
     */
#define FC3R         64
#define FC4L        128
     /* Any decorator on the same side as the '4' displays as is.
     */
#define FC4R        256
     /* Format Control Character '3' applies to the right side of the
        decimal point: Float the decorator against the number.
     */
#define FC8         512
     /* Format Control Character '8' applies:  Fill empty portions of
        the field with the character defined by Lfc[3].  The default
        is *.
     */
#define FC9        1024
     /* Pad with 0's to the position of the outermost 0. If the value
        is zero, the position is filled with blanks.
     */
/***********************************************************************
* cba is an array of Aplcb pointers for various integer vectors        *
* describing the input.                                                *
***********************************************************************/
#define CBALEN 9 /* number of pointers in array bca */
#define SIGNCB 0 /* 1 if input column contains a minus sign. */
#define Signcb (cba->aplptr.aplint + SIGNCB*(*(cba->apldim + 1)))
#define DIGICB 1 /* Maximum digits left of decimal point. */
#define Digicb (cba->aplptr.aplint + DIGICB*(*(cba->apldim + 1)))
#define FRACCB 2 /* Maximum places right of decimal point. */
#define Fraccb (cba->aplptr.aplint + FRACCB*(*(cba->apldim + 1)))
#define PRECB  3 /* Maximum places right of decimal point. */ 
#define Precb  (cba->aplptr.aplint + PRECB*(*(cba->apldim + 1)))
			/* ---------------------------------------------------- *
			* Formatj sets both fraccb and precb to the same value. *
			* Fraccb is referenced only in formatj and formatc.     *
			* Formatc, which is called from format when the left    *
			*	argument is NULL, i.e. no widths or precisions     *
			*	were specified by the caller, sets precb to -6 for *
			*	each column it determines should be formatted in   *
			*    e-notation.                                        *
			* Formate, which is called by formatm to fill in default*
			*	e-notation widths, tests precb for negative value  *
			*	to see if a column is e- or f-notation.            *
			* Formatf, which is called by formatm to fill in default*
			*	f-notation widths, tests precb for negative value  *
			*	to see if a column is e- or f-notation.            *
			* Formatg, which is called from form after widths and   *
			*	and precisions have been determined, passes a ptr  *
			*	to a precb column value to either formath or       *
			*	formatz, depending on whether the next value to be *
			*	formatted is respectively either a simple double,  *
			*	or a nested variable.                              *
			* Formatm, which is called by formatd to fill in any    *
			*	missing widths or precisions, fills in the precb   *
			*	column value from the left argument to format      *
			*	before calling formate and formatf to fill in      *
			*	missing values.                                    *
			* ---------------------------------------------------- */
#define WIDCB  4 /* Width of each output column. */
#define Widcb  (cba->aplptr.aplint + WIDCB*(*(cba->apldim + 1)))
#define CHRCB  5 /* Maximum character vector length in column. */
#define Chrcb  (cba->aplptr.aplint + CHRCB*(*(cba->apldim + 1)))
#define BIXCB  6 /* Index vector = 1, 2, 3,... Set in formatm. */
#define Bixcb  (cba->aplptr.aplint + BIXCB*(*(cba->apldim + 1)))
#define ZIXCB  7 /* Which formats have widths of 0. Set in formatm.*/
#define Zixcb  (cba->aplptr.aplint + ZIXCB*(*(cba->apldim + 1)))
#define CHRCOL 8 /* 1 if entire column is char, 0 otherwise. */
#define Chrcol (cba->aplptr.aplint + CHRCOL*(*(cba->apldim + 1)))
#endif
