/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* funassgs.h - APL2 V1.0.0 ********************************************
* Assignment statements included in funinit.c for scalar functions.    *
***********************************************************************/
#if !defined(FUNASSGS_INCL)
#define FUNASSGS_INCL
/* SCDO - Rela (boolean) */
  rela_init(x03, iand    , dbland  , and     ,
                 iandp   , dblandp , andp    , NULL    , NULL    );
  rela_init(x23, inand   , dblnand , nand    ,
                 inandp  , dblnandp, nandp   , NULL    , NULL    );
  rela_init(x28, ior     , dblor   , or      ,
                 iorp    , dblorp  , orp     , NULL    , NULL    );
  rela_init(x37, inor    , dblnor  , nor     ,
                 inorp   , dblnorp , norp    , NULL    , NULL    );
/* SCDO - Rela (relationals) */
  rela_init(x07, ilt     , dbllt   , lt      ,
                 iltp    , dblltp  , ltp     , NULL    , NULL    );
  rela_init(x09, igt     , dblgt   , gt      ,
                 igtp    , dblgtp  , gtp     , NULL    , NULL    );
  rela_init(x19, ile     , dblle   , le      ,
                 ilep    , dbllep  , lep     , NULL    , NULL    );
  rela_init(x32, ige     , dblge   , ge      ,
                 igep    , dblgep  , gep     , NULL    , NULL    );
/* SCMD - Scalars */
  scalars_init(x01, ifactorl, factorl , NULL    ,
                    NULL    , factorlp, NULL    , factorlx,
                    NULL    , binom   , NULL    ,
                    NULL    , binomp  , NULL    ,
                    NULL    , binomx  , NULL);
  scalars_init(x02, NULL    , recip   , NULL    ,
                    NULL    , recipp  , NULL    , recipx  ,
                    NULL    , divide  , NULL    ,
                    NULL    , dividep , NULL    ,
                    NULL    , dividex , NULL);
  scalars_init(x05, iconjug , conjug  , NULL    ,
                    NULL    , conjugp , NULL    , conjugx ,
                    NULL    , plus    , NULL    ,
                    NULL    , plusp   , NULL    ,
                    NULL    , plusx   , NULL);
  scalars_init(x15, iconjug , floor   , NULL    ,
                    NULL    , floorp  , NULL    , floorx  ,
                    imin    , dblmin  , NULL    ,
                    iminp   , dblminp , NULL    ,
                    NULL    , NULL    , NULL);
  scalars_init(x25, NULL    , ceil    , NULL    ,
                    NULL    , ceilp   , NULL    , ceilx   ,
                    imax    , dblmax  , NULL    ,
                    imaxp   , dblmaxp , NULL    ,
                    NULL    , NULL    , NULL);
  scalars_init(x30, isign   , signdbl , NULL    ,
                    NULL    , signdblp, NULL    , signdblx,
                    NULL    , times   , NULL    ,
                    NULL    , timesp  , NULL    ,
                    NULL    , timesx  , NULL);
  scalars_init(x34, inegativ, negative, NULL    ,
                    NULL    , negativp, NULL    , negativx,
                    NULL    , minus   , NULL    ,
                    NULL    , minusp  , NULL    ,
                    NULL    , minusx  , NULL);
  scalars_init(x40, iabs    , dabs    , NULL    ,
                    NULL    , dabsp   , NULL    , dabsx   ,
                    NULL    , residue , NULL    ,
                    NULL    , residuep, NULL    ,
                    NULL    , residuex, NULL);
/* SCMD - Scalars (but integer not supported) */
  scalars_init(x04, NULL    , exp     , NULL    ,
                    NULL    , expp    , NULL    , expx    ,
                    NULL    , power   , NULL    ,
                    NULL    , powerp  , NULL    ,
                    NULL    , powerx  , NULL);
  scalars_init(x11, NULL    , log     , NULL    ,
                    NULL    , logp    , NULL    , logx    ,
                    NULL    , logrithm, NULL    ,
                    NULL    , logrithp, NULL    ,
                    NULL    , logrithx, NULL);
  scalars_init(x22, NULL    , pitimes , NULL    ,
                    NULL    , pitimesp, NULL    , pitimesx,
                    NULL    , circular, NULL    ,
                    NULL    , circulap, NULL    ,
                    NULL    , circulax, NULL);
  scalars_init(x53, NULL    , NULL    , NULL    ,
                    NULL    , NULL    , NULL    , logamma ,
                    NULL    , NULL    , NULL    ,
                    NULL    , NULL    , NULL    ,
                    NULL    , NULL    , NULL);
#endif
