" <-APL2-------------------- graph.txt ----------------------------->
" Legend describing various global values:
"
" World coordinates(wc) are those of the real data.
" Graph coordinates(gc) are those of the graph.
"
" caption - Override to text for graph caption.  If null, a caption
"           will be generated.  The graph function resets the global
"           caption variable to null at the end of its processing.
"
" hk ------ Constant coefficient of input.  If xr=1 (see below) then
"           hk becomes the constant imaginary coefficient for all
"           values of x on the graph.  If xr=0, hk will be the constant
"           real coefficient.
"
" htl ----- 0 = both, 1 = headers, 2 = trailers, 3 = neither.
"
" maxx ---- Maximum x axis value in world coordinates.
"
" maxy ---- Maximum y axis value in world coordinates.
"
" minx ---- Minimum x axis value in world coordinates.
"
" miny ---- Minimum y axis value in world coordinates.
"
" mgc ----- Vertical margin in graphic coordinates.
"
" n ------- Synonymous with hk (see above).  The x values to which
"           the function is applied to obtain y values are derived
"           by first creating xwc as a vector of integers uniformly
"           distributed between minx and maxx inclusive.  Then, either
"           'x#(nX0j1)+xwc' or 'x#n+0j1Xxwc' is evaluated.
"
" nlb ----- 1 = Label the curve with the n value.
"
" points -- Number of points to generate.
"
" xgc ----- Array of x values for data points in graph coordinates.
"
" xiv ----- x axis marker interval in world coordinates.
"
" xlin ---- Width of graph in inches.
"
" xpg ----- Divide xwc by xpg to get xgc.
"
" xpi ----- Array of three values for minx, maxx, and xiv, used when
"           invoking the graph function and the array of x values
"           spans -pi to +pi.
"
" xr ------ 1=vary real x coefficient, 0=vary imaginary coefficient,
"           holding the other coefficient to the constant hk (see above.).
"
" xt ------ Used in a variety of places to temporarily generate
"           graphics coordinates.
"
" xwc ----- Array of x values in world coordinates.
"
" yadj ---- Adjustment down to print text below a line.
"
" yabm ---- Maximum absolute value (|y) to appear on graph.
"
" ygc ----- Array of y values for data points in graph coordinates.
"
" ylin ---- Height of graph in inches.
"
" ymgn ---- Margin in inches at top and bottom of y axis.
"
" ypg ----- Divide ywc by ypg to get ygc.
"
" yt ------ Used in a variety of places to temporarily generate
"           graphics coordinates.
"
" ywc ----- Array of y values for data points in world coordinates.
"
" Set global values. -------------------------------------------->
"
caption#'' " Empty caption causes one to be generated.
i#11 " Circle function code to extract imag. coef. of complex number.
points#200 " Number of data points to generate on graph.
r#9 " Circle function code to extract real coef. of complex number.
xlin#4.5 " Width of graph in inches.
"  minx = -3.14159....
"  |     maxx = 3.14159....
"  |     |     xiv
"  |     |     |
"  V     V     V
xpi#(O-1),(O1),O.25
ylin#6 " Height of graph in inches.
ymgn#.2 " Margin in inches at top and bottom of y axis.
"
" <----------------------------------------------------------------->
" Generates the LaTeX \put statements for the data points to appear
" on the graph.
"
Lex 'dodata'
Gdodata
xgc#(xwc_minx)%xpg " xgc=x graphic coordinates for data points.
ygc#mgc+(ywc_miny)%ypg " ygc=y graphic coordinates for data points.
$bylabXI0=nlb " Branch if the curve is not to be labelled.
'%Label the curve'
xt#1Y(u=S/u#|ywc)/xgc " x coord where maximum/mininum occurs
yt#(_yadjX0>vs/ywc)+(vs#xt=xgc)/ygc " y coord of maximum/minimum
" Note: Calculation for yt works only if all minima occur below
" y axis, and all maxima occur above.
pcon,(xt,',',[1.5]yt),`Z'){n\#',(Fhk),'}'
bylab:'%Draw the data points'
pcon,((xgc#-1U1Uxgc),',',[1.5](ygc#-1U1Uygc)),circon
G
" <----------------------------------------------------------------->
" Generate xwc and ywc, the arrays of x/y coordinates for the data
" points to appear on the graph.
"
Lex 'genxy'
Ggenxy
xwc#minx+(xlwc#maxx_minx)X(-1+Ipoints+1)%points
$varyrealXIxr
x#hk+0j1Xxwc " real part is constant, imaginary varies.
$calcy " Branch to compute values of y for data points.
varyreal:x#(hkX0j1)+xwc " Imaginary is constant, real varies.
calcy:ywc#eOCfun " Compute values of y for data points
ywcm#yabm>|ywc " Mask of keepers, magnitudes of y < yabm.
xwc#ywcm/xwc " Pick the keepers.
ywc#ywcm/ywc " Pick the keepers.
G
"
" <----------------------------------------------------------------->
" Main graph routine.
"
Lex 'graph'
Gfun graph a
"Graphs the imaginary or real coefficient of result of fun.
" fun = expression to evaluate.
(htl nlb xr e yabm minx maxx xiv hk yiv yca)#a
genxy " Generate the data points.
$dataXIhtl>1 " Branch if htl greater than 1.
scale " Calculate global scaling values.
headers " Generate LaTeX figure headers.
data:dodata " Process and graph data points.
trailers " Generate Latex figure trailers, maybe.
G
"
" <----------------------------------------------------------------->
" Generates the LaTeX statements to begin the graph.
"
Lex 'headers'
Gheaders
'\begin{figure}[tbh]'
$gencapXI0=Rcaption " Branch if no caption override.
'\caption{',caption,'}'
$begin
gencap:$realcapXI(xr=1)&hk=0 " Branch if x data are not complex.
$ncaptionXInlb=0 " Branch if curves are not labelled with n value.
'\caption{Graph of y\#',(Fe),'O',fun,'+nX0j1}'
$begin
ncaption:$cplxcapXIxr " Branch if varying real coefficient.
'\caption{Graph of y\#',(Fe),'O',(-1Ufun),(Fhk),'+xX0j1}'
$begin
cplxcap:'\caption{Graph of y\#',(Fe),'O',fun,'+(n\#',(Fhk),')X0j1}'
$begin
realcap:'\caption{Graph of y\#',fun,'}'
begin:'\begin{center}'
'\setlength{\unitlength}{',(Flin),'in}'
'\begin{picture}(',(Fxlin%lin),',',(Fylin%lin),')'
'%Draw a frame around the picture'
' \put(0,0){\line(1,0){',(Fxlgc),'}}% bottom'
' \put(0,0){\line(0,1){',(Fylgc),'}}% left'
' \put(0,',(Fylgc),'){\line(1,0){',(Fxlgc),'}}% top'
' \put(',(Fxlgc),',0){\line(0,1){',(Fylgc),'}}% right'
'%Draw the x axis'
' \put(0,',(Fxax),'){\line(1,0){',(Fxlgc),'}}%x axis'
xt#xoff%xpg
pcon,((xt,[1.5]','),xax),circon " Draw the x axis markers.
xt#xt_xpgX.1Xxmk<0
yt#xax+((.05%lin)Xxax=mgc)_yadjXxax>mgc
$dopaxXIpix
'%Draw the x axis marker values'
pcon,xt,',',yt,econ,xmk,[1.5]scon
$doyax
dopax:'%Draw the x axis marker values in pi'
picon#(`Z'\frac{') ,`1 '\pi}{4}' '\pi}{2}' '3\pi}{4}'
picon#('-',`1`Rpicon),'0',picon
pcon,xt,',',yt,econ,picon,[1.5]scon
doyax:'%Draw the y axis'
$putymkXI(yax=0)
' \put(',(Fyax),',0){\line(0,1){',(Fylgc),'}}%y axis'
putymk:'%Draw the y axis markers'
ymask#ymk^=0
yt#ymask/mgc+(ymk_miny)%ypg
pcon,yax,',',yt,[1.5]circon
'%Draw the y axis marker values'
xt#yax+.05%lin
yt#yt_ypgX.1X(ymask/ymk)<0
pcon,xt,',',yt,econ,(ymask/ymk),[1.5]scon
G
"
" <----------------------------------------------------------------->
" Calculates a variety of values needed to produce the graph.
"
Lex 'scale'
Gscale
$byyXIyca " Branch if ylwc, maxy, miny are precalculated.
ylwc#(maxy#S/ywc)_miny#D/ywc
byy:ylap#ylin_2Xymgn " ylap=height allowed for data points.
lin#(xlin%xlwc)Dylap%ylwc " unitlength in inches.
yadj#.14%lin " y graphic coordinate adjustment to print text below line.
mgc#ymgn%lin " Margin in graph coordinates.
xpg#xlwc%xlgc#xlin%lin " Divide xwc by xpg to get gc.
ypg#ylwc%(_2Xymgn%lin)+ylgc#ylin%lin " Divide ywc by ypg to get gc.
xax#(yz#(minyK0)&maxyZ0)Xmgc+(|miny)%ypg " xaxis in graph coordinates.
yax#(xz#(minx<0)&maxx>0)X(|minx)%xpg " yaxis in graph coordinates.
$piaxisXIpix#(minx=O-1)&maxx=O1 " branch if pi units on x axis.
xic#(yax=0)+Dxlwc%xiv
$doyiv
piaxis:xic#Dxlwc%xiv#O.25
doyiv:$doyicXIyiv^=0
yiv#10*D10@ylwc
doyic:yic#yic+0=2|yic#Dylwc%yiv
xoff#(I-1+xic)Xxiv " Offset from minx in world coord. of x markers.
yoff#(_yiv)+(Iyic)Xyiv " Offset from miny in world coord. of y markers.
$yoffplusXIminy>0
ymk#yoff+miny+yiv||miny
$yoffdone
yoffplus:ymk#yoff+miny_yiv|miny " y for y axis markers in world coord.
yoffdone:xmk#minx+xoff " x for x axis markers in world coord.
circon#`Z'){\circle*{',(F.0205%lin),'}}'
scon#`Z'$}'
econ#`Z'){$'
pcon#`Z' \put('
G
"
" <----------------------------------------------------------------->
" Generates the LaTeX statements to finish the graph.
"
Lex 'trailers'
Gtrailers
$epicXIhtl=0 " Branch if both headers and trailers.
$eojckXInlb " Branch if graph already labelled.
pcon,(1Yxgc+xpgX.1),',',(1Yygc),'){',fun,'}' " Label the graph.
eojck:$eojXI(htl=1)+htl=3 " br if headers only, or neither.
epic:'\end{picture}'
'\end{center}'
eoj:'%Finis.'
caption#'' " Reset global caption
G
