/*Copyright (C) 1997 by Thomas Glen Smith.  All Rights Reserved.*/
/* acoshx APL2 V1.0.0 **************************************************
* Hyperbolic arc-cosine for complex numbers.                           *
***********************************************************************/
#define INCLUDES MATH
#include "includes.h"
void acoshx(rrr,ret)
double *rrr,*ret;
{	/* acosh r = @(r+-4Or) = @r+(-1+r*2)*.5 */
	Logx; Plusx; Powerx; Timesx;
	double wa[2],wb[2];
	static double
		half[2]={0.5,0.0},
		negone[2]={-1.0,0.0};

	timesx(rrr,rrr,wa);		/* r*2 */
	plusx(negone,wa,wb);	/* -1+r*2 */
	powerx(wb,half,wa);		/* (-1+r*2)*.5 */
	plusx(rrr,wa,wb);		/* r+(-1+r*2)*.5 */
	logx(wb,ret);			/* @r+(-1+r*2)*.5 */
}

