/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* apledit APL2 V1.0.0 *************************************************
* Called from funcsusq.                                                *
* The APL function editor.  Process commands beginning with a DEL.     *
***********************************************************************/
#define MAXLINE 1024
#define INCLUDES APLCB+APLCHDEF+APLED+APLFUNCI+APLTOKEN
#include "includes.h"
Aplcb apledit(rite,cp,cpend)
Aplcb rite;	/* Aplcb for command text.				*/
char *cp;			/* Pointer to char immediately after DEL.	*/
char *cpend;		/* Pointer to end of command text.			*/
{	Apledfr;Apledfx;Aplediu;Aplediv;Endoper;Execfree;Execmsg;Execpars;
	Execpop;Execqfxa;Execqfxj;Execqfxk;Execqfxl;Expunge;Pop;
	struct apledst e;
	extern int aplerr;
	void *v;
	Apltoken nametok,tokhdr;
	int stmtlen;

	e.edhdr = e.edlst = e.cured = NULL;
	e.fp = NULL;
	e.delptr = NULL;
	e.aplstinc = 1.0; /* statement increment */
	stmtlen = cpend - cp;
	tokhdr = execpars(cp,stmtlen); /* tokenize initial input */
	if (aplerr == 0) {
		while (tokhdr != NULL) { /* while allows break to be used */
			if (tokhdr->token_code == DEL)
				e.delptr = pop(&tokhdr); /* pop DEL token */
			e.fp = execqfxa(NULL); /* go initialize function struct */
			if (aplerr) break; /* probably a memory problem */		
			e.fp->funcstmt = 1; /* lie: function is 1 statement */
			execqfxj(e.fp); /* initialize arrays dep. on stmtcnt */
			if (aplerr) break; /* probably a memory problem */
			*(e.fp->functokp) = tokhdr; /* potential function hdr */
			tokhdr = NULL;
			execqfxk(e.fp); /* count tokens,transform to contig. blk */
			nametok = execqfxl(e.fp); /* function name */
			if (aplerr == 27) break; /* memory problem */
			if (aplerr || e.fp->functype & NILAD && 1 == e.fp->functotl)
				aplediu(&e,cp,stmtlen); /* not header, probably */
			else aplediv(&e);
			if (aplerr == 0)
				apledfx(&e); /* go fix function */
		}
		if (aplerr)
			execmsg(cp,stmtlen,0,NULL); /* print error message */
	}
	apledfr(&e); /* free apled list */
	v = expunge(e.fp); /* free temporary function definition */
	execpop(&tokhdr); /* pop/free any tokens on stack */
	execfree(e.delptr); /* free terminating DEL token */
	endoper(rite); /* free rite */
	return(NULL);
}
