/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplediy APL2 V1.0.0 *************************************************
* Called from aplediu to process the current DEL editor input.         *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLED+APLFUNCI+APLMEM+APLTOKEN+TREE
#include "includes.h"
void aplediy(e,cp,stmtlen,cpn,tokcnt)
struct apledst *e;		/* Edit common area.					*/
char *cp;				/* Pointer to current input.				*/
int stmtlen;			/* Length of current input.				*/
char *cpn;			/* Ptr to cap null, if stmt is comment.		*/
int tokcnt;			/* Count of tokens remaining to process.	*/
{
	Apledcl; Apleddl; Apledmd; Apledqu; Execmsg; Execqfxe; Expungf;
	Apltoken tokhdr;
	int newstmt;

	tokhdr = *(e->fp->functokp); /* token list from temp. hdr. */
	if (NULL == execqfxe(tokhdr + tokcnt - 1,LEFT_BRACKET,0))
		execmsg(cp,stmtlen,0,"Bracket not found where expected.");
	else if (tokcnt < 3)
		execmsg(cp,stmtlen,0,"No value in brackets.");
	else switch((tokhdr + tokcnt - 2)->token_code) {
		case OPERAND_TOKEN:
			apleddl(e,cp,stmtlen,tokcnt); /* delete */
			break;
		case QUAD:
			apledqu(e,cp,stmtlen,tokcnt); /* display */
			break;
		case VECTOR_TOKEN:
			if (tokcnt == 4 && tokhdr->token_code == RIGHT_BRACKET
				&& (tokhdr + 1)->token_code == QUAD) /* [nL] */
				apledqu(e,cp,stmtlen,tokcnt); /* display */
			else
				apledmd(e,cp,stmtlen,cpn,tokcnt); /* modify */
			break;
		default:
			execmsg(cp,stmtlen,0,"Bad syntax in brackets.");
			break;
	} /* end switch */
	apledcl(e); /* free tokens */
}
