/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplediz APL2 V1.0.0 *************************************************
* Called from aplediu and aplediv to get DEL editor requests from the  *
* user, calling aplediy with them, returning control to the caller     *
* when a closing DEL is entered.                                       *
***********************************************************************/
#define MAXLINE 1024
#define INCLUDES APLCB+APLCHDEF+APLED+APLFUNCI+APLTOKEN+STDIO+STRING+TREE
#include "includes.h"
void aplediz(e)
struct apledst *e;		/* Edit common area.					*/
{
	Apledfm; Aplednn; Apledrc; Codechar; Execmsg; Getchrv;
	extern int aplerr;
	extern double fuzz;
	char *cp,*cpend,line[MAXLINE],prompt[20],*tp;
	double newno;
	Aplcb out;

	while (e->delptr == NULL) {
		newno = aplednn(e); /* determine new prompt */
		strcpy(prompt,apledfm(newno)); /* prompt == bracketed stmtno */
		out = getchrv(prompt); /* get input */
		if (aplerr) {
			execmsg(prompt,strlen(prompt),0,NULL); /* print error */
			aplerr = 0; /* reset aplerr */
		}
		else {
			cp = tp = out->aplptr.aplchar; /* point to input line */
			cpend = cp + out->aplcount;
			switch (aplscan(&tp,cpend)) { /* find first token code */	
				case DEL: /* all done */
				case LEFT_BRACKET: /* user bracketed stmtno */
					strcpy(line,cp);
					break;
				default: /* I must supply bracketed stmtno */
					strcpy(line,prompt);
					strcat(line,cp);
					break;
			} /* end switch */
			apledrc(e,line); /* parse and process input */
		}
		endoper(out);
	}
}
