/* Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved. */
/* apledps APL2 V1.0.0 *************************************************
* Called from apledfx to format for display a statement.  The          *
* line prefix is assumed to already be stored.                         *
***********************************************************************/
#define INCLUDES STDIO+STRING+APLCB+APLCHDEF+APLTOKEN+APLED
#include "includes.h"
void apledps(ed,line)
struct apled *ed;        /* Statement to be formatted. */
char *line;              /* String in which to store formatted stmt. */
{
     Apledfm; Apledpq; Codechar; Endoper; Execmsg; Form; Quoteit;
     extern int aplerr;
     Apltoken curtok,tokhdr;
     Aplcb wrk;
     char *str;
     int i,oplast,opnext,tokcnt;

     tokcnt = ed->apledcn;
     tokhdr = ed->apledhd;
     if (!(tokcnt > 2 && (tokhdr + tokcnt - 2)->token_code == COLON
          || (tokhdr + tokcnt - 1)->token_code == CAP_NULL))
          strcat(line," "); /* indent non-labelled, non-comments */
     opnext = 0; /* indicates whether last token was operand */
     while (tokcnt--) {
          curtok = tokhdr + tokcnt;
          oplast = opnext;
          opnext = 0; /* next oplast value */
          switch (i = curtok->token_code) {
               case QUOTE:
                    if (oplast) /* was last token for operand/vector? */
                         strcat(line," "); /* delimit with a blank */
                    opnext = 1;
                    quoteit(line+strlen(line),
                         curtok->token_ptr.token_vector ->
                         aplptr.aplchar);
                    break;
               case VECTOR_TOKEN:
                    if (oplast) /* was last token for operand/vector? */
                         strcat(line," "); /* delimit with a blank */
                    opnext = 1;
                    wrk = form(NULL,curtok->token_ptr.token_vector);
                    strcat(line,wrk->aplptr.aplchar);
                    endoper(wrk);
                    break;
               case OPERAND_TOKEN:
                    if (oplast) /* was last token for operand? */
                         strcat(line," "); /* delimit with a blank */
                    opnext = 1;
                    strcat(line,curtok->token_ptr.token_string);
                    break;
               case CAP_NULL: /* comment */
                    strcat(line,ed->apledch+curtok->token_offset);
                    break;
               default:
                    if (i <= QUAD_AI && i > QUAD_ZZ)
                         apledpq(i,line);
                    else
                         strcat(line,codechar(i));
                    break;
          } /* end switch */
     }
}
