/* Copyright (C) 1992 by Thomas Glen Smith.  All Rights Reserved. */
/* aplmall APL2 V1.0.0 *************************************************
* Called by getcb, newtok, treeroot, and without.                      *
* APL interface to malloc.  Expedites debugging.                       *
***********************************************************************/
#define TGS_DEBUG 0
#define INCLUDES APLDEBUG+STDIO
#include "includes.h"
#if APL_DEBUG
#define malloc mem_malloc
#endif
#include <stdlib.h>
void *aplmall(size)
int size; /* size of storage to obtain */
{
     extern int aplerr;
     void *ret;
#if APL_DEBUG
static int bugcnt=0;
void mem_check(void);
void *mem_malloc();
mem_check();
#endif
     ret = (void *)malloc(size);
     if (ret == NULL) aplerr = 27; /* out of memory */

#if APL_DEBUG
#if TGS_DEBUG
     if (
     ret == (void *)0x62770016 && size == 64
     ){
     	++bugcnt;
		printf("bug found in aplmall, bugcnt=%d\n",bugcnt);
          if (bugcnt == 1)
          	printf("big bug, aplmall\n");
     }
#endif
#endif

     return(ret);
}
