/* Copyright (C) 1993, 1998 by Thomas Glen Smith.  All Rights Reserved. */
/* aplmatch APL2 V1.0.1 ************************************************
* Called by aplmatck and memixe.                                       *
* Yields 1 if left and rite are identical in shape and value.          *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
int aplmatch(Aplcb left, Aplcb rite)
{
     Aplmatci; Eq;
     extern int aplerr;
     int lefttype,ritetype;
     Apluptr ld,rd;
     int i,*leftdim,*ritedim;

     if (left == NULL && rite == NULL) return(1);
     if (left == NULL || rite == NULL) return(0);
     if (left->aplrank != rite->aplrank) return(0);
     if (left->aplcount != rite->aplcount) return(0);
     if (left->aplrank) {
          leftdim = left->apldim;
          ritedim = rite->apldim;
          for (i = left->aplrank; i; i--)
               if (*leftdim++ != *ritedim++) return(0);
     }
     lefttype = left->aplflags & (APLMASK + APLAPL);
     ritetype = rite->aplflags & (APLMASK + APLAPL);
     if (lefttype != ritetype &&
         !((lefttype | ritetype) & APL_NUMERIC)) return(0);
     ld.aplchar = left->aplptr.aplchar;
     rd.aplchar = rite->aplptr.aplchar;
     for (i = left->aplcount; i; i--) {
          if (!aplmatci(ld,rd,lefttype,ritetype)) return(0);
          ld.aplchar += left->aplsize;
          rd.aplchar += rite->aplsize;
     }
     return(1);
}
