/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplname APL2 V1.0.0 *************************************************
* Called by namelen.                                                   *
* Called to determine a well-formed apl name.  The two arguments are   *
* which points to the first character of a potential well-formed name, *
* and spend, which points to the character to the right of the last    *
* character to be considered when looking for the end of the name.  The*
* returned value is a pointer to the character to the right of the     *
* last one which is part of a well-formed name.                        *
***********************************************************************/
#define INCLUDES APLCHDEF
#include "includes.h"
char *aplname(sp,spend)
char *sp,*spend;
{
	Aplnamsb; Aplscan;
	char *t;
	int code;

	t = sp; /* save start of name */
	code = aplscan(&sp,spend); /* determine next char code */
	if (!(code >= ALPHAONE && code <= ALPHATWO)) return(t); /*notname*/
	return(aplnamsb(sp,spend)); /* go find end of name */
}
