/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplparfn APL2 V1.0.0 ************************************************
* Called from aplsave and aplloae to parse a file name.                *
***********************************************************************/
#define INCLUDES APLMEM+APLCHDEF
#include "includes.h"
char *aplparfn(cp,cpend)
char *cp; /* Pointer to start to string containing file name */
char *cpend; /* Pointer to end of string */
{
	Aplscan;
	char *r,*s,*t,*u;
	int code,i;

	if (cp == cpend) return(NULL); /* no file name supplied */
	s = cp; /* save possible pointer to 1st nonblank */
	if (SPACE != (code = aplscan(&s,cpend)))
		s = cp; /* s == 1st nonblank */
	else if (s == cpend) return(NULL); /* no file name supplied */
	for ( u = t = s ; u < cpend ; u = t )
		code = aplscan(&t,cpend);
	if (SPACE == code)
		t = u; /* u == end of filename */
	if (NULL == (r = u = malloc(5 + (i = t - s))))
		return(NULL); /* out of memory */
	while(i--)
		*u++ = *s++; /* copy file name */
	*u++ = '.';
	*u++ = 'a';
	*u++ = 'p';
	*u++ = 'l';
	*u = '\0'; /* delimiter */
	return(r); /* return pointer to file name string */
}
