/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* aplparse APL2 V1.0.0 ************************************************
* Called by execpars.                                                  *
* Aplparse returns a pointer to a lifo stack of token elements parsed  *
* from the APL statement pointed to by *sp.  If the statement is       *
* syntactically correct, i.e. no UNKNOWN characters or unmatched       *
* parentheses, brackets, or quotes, the top token on the stack will be *
* NO_MORE_TOKENS.  Otherwise, it will be a special message token       *
* describing the error.  This source differs from the CAP source only  *
* in that it handles statements ending with a CAP_NULL (comment).      *
***********************************************************************/
#define INCLUDES APLCHDEF+APLTOKEN
#include "includes.h"
Apltoken aplparse(sp,splen)
char *sp; /* string to be tokenized */
int splen; /* length(string to be tokenized) */
{
     Aplparsf; Aplparsg; Aplscan; Lifo; Newtok;
     extern int aplerr; /* global error code */
     Apltoken hdr = NULL, cur = NULL;
     char *s, *t, *u;
     int bracket_count=0,i,next_code,paren_count=0;

     if (aplerr) return(NULL);
     s = sp; /* point to input string */
     u = s + splen; /* point to after end of string */
     while (s < u) { /* do while not end of string */
          t = s; /* save current location */
          next_code = aplscan(&s,u); /* get next token code */
          if (next_code == CAP_NULL)
               s = u; /* it is comment */
          if (next_code != SPACE) { /* ignore white space */
               cur = lifo(&hdr,newtok(0, 0, t - sp, NULL, 0));
               if (cur == NULL) return(hdr); /* out of storage */
               cur->token_code = aplparsg(next_code);
               aplparsf(cur,&s,t,u,&bracket_count,&paren_count);
               if (cur->token_code == MESSAGE_TOKEN)
                    return(hdr); /* syntax error of some sort */
     }    }
     cur = lifo(&hdr,newtok(NO_MORE_TOKENS, 0, s - sp, NULL, 0));
     if (cur == NULL) return(hdr); /* out of storage */
     if (bracket_count) {
          cur->token_code = MESSAGE_TOKEN;
          cur->token_ptr.token_string = "unbalanced brackets";
     }
     if (paren_count) {
          cur->token_code = MESSAGE_TOKEN;
          cur->token_ptr.token_string = "unbalanced parentheses";
     }
     return(hdr);
}
