/* Copyright (C) 1992 by Thomas Glen Smith.  All Rights Reserved. */
/* aplpnum - APL2 V1.0.0 ***********************************************
* Called from aplparsf when the current character is potentially the   *
* start of a numeric constant.                                         *
***********************************************************************/
#define INCLUDES APLMEM+APLTOKEN+APLCB
#include "includes.h"
void aplpnum(cur,sp,spend)
Apltoken cur;
char *sp[]; /* pointer to pointer to string being parsed */
char *spend; /* pointer to after end of string */
{
     Vector;
     extern int aplerr;
     Aplcb concb;
     char *s;
     int i,j;

     s = sp[0] - 1; /* point to possible start of numeric constant(s) */
     concb = vector(&s,spend,1); /* arg #3=0 for APL, 1 for APL2 */
     if (concb == NULL)
          return; /* no constant found */
     if (0 == concb->aplcount) {
          endoper(concb); /* no constant found */
          return;
     }
     if (1 == concb->aplcount) {
          concb->apldim = NULL; /* it'll get freed later - the APLCB    */
                                 /* and the dimension array are obtained */
                                 /* as a single unit of memory.          */
          concb->aplrank = 0; /* make it a scalar */
     }
     cur->token_code = VECTOR_TOKEN; /* indicate constant found */
     cur->token_ptr.token_vector = concb; /* save aplcb pointer */
     sp[0] = s; /* update text pointer */
}
