/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/*quadinit APL2 V1.0.0 ************************************************
* Called from execasgn to set the Random Link seed.  Rite is not freed.*
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
void aplsrand(rite)
Aplcb rite; /* Seed. */
{
	Dabsx;
	unsigned int seed=1;
	double *fin,fwrk[2];

	if (rite->aplcount)
		switch(rite->aplflags & APL_NUMERIC) {
			case APLINT:
				seed = *(rite->aplptr.aplint);
				break;
			case APLNUMB:
				seed = *(rite->aplptr.apldata);
				break;
			case APLCPLX:
                   	dabsx(rite->aplptr.apldata, fwrk);
				seed = fwrk[1];
				break;
			default: /* No error for now. */
				break;
		}
	srand(seed);
}
