/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* aplstr APL2 V1.0.0 **************************************************
* Called by aplgrous to copy a string to a new location, less          *
* delimiting '\0', and padded with blanks to a specified length.       *
***********************************************************************/
#define INCLUDES STRING
#include "includes.h"
char *aplstr(to,from,cols)
char *to; /* location to copy to */
char *from; /* location to copy from, delimited with '\0' */
int cols; /* length of to-location.  Padding w/b done, if necessary */
{
	Chrcopy;
	int len,pad;
	static char blank[]=" ";

	len = strlen(from);
	to = chrcopy(to,from,len,1); /* copy name, less '\0' */
	pad = cols - len;
	if (pad)
		to = chrcopy(to,blank,pad,0); /* pad with blanks */
	return(to); /* return new location */
}
