/*Copyright (C) 1997 by Thomas Glen Smith.  All Rights Reserved.*/
/* asinhx APL2 V1.0.0 **************************************************
* Hyperbolic arc-sine for complex numbers.                             *
***********************************************************************/
#define INCLUDES MATH
#include "includes.h"
void asinhx(rrr,ret)
double *rrr,*ret;
{	/* asinh r = @r+(1+r*2)*.5 */
	Logx; Plusx; Powerx; Timesx;
	double wa[2],wb[2];
	static double 
		half[2]={0.5,0.0},
		one[2]={1.0,0.0};

	timesx(rrr,rrr,wa);		/* wa = r*2			*/
	plusx(one,wa,wb);		/* wb = 1+r*2			*/
	powerx(wb,half,wa);		/* wa = (1+r*2)*.5		*/
	plusx(rrr,wa,wb);		/* wb = r+(1+r*2)*.5	*/
	logx(wb,ret);			/*ret = @r+(1+r*2)*.5	*/
}
