/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* circular APL2 V1.0.0 ************************************************
* Implementation of the APL circular, hyperbolic, and Pythagorean      *
* functions for real numbers.                                          *
***********************************************************************/
#define INCLUDES MATH+TRIGKEYS
#include "includes.h"
double circular(left,rite)
double left,rite;
{
	Acosh; Asinh; Atanh;
	extern int aplerr;

	switch ((int) left) {
		case ATANH: return(atanh(rite));
		case ACOSH: return(acosh(rite));
		case ASINH: return(asinh(rite));
		case -4: return(sqrt(-1.0+rite*rite));
		case ATAN: return(atan(rite)); /* Arctan */
		case ACOS: return(acos(rite)); /* Arccos */
		case ASIN: return(asin(rite)); /* Arcsin */
		case  0: return(sqrt(1-rite*rite));
		case  SIN: return(sin(rite)); /* Sine */
		case  COS: return(cos(rite)); /* Cosine */
		case  TAN: return(tan(rite)); /* Tangent */
		case  4: return(sqrt(1+rite*rite));
		case  SINH: return(sinh(rite)); /* Hyperbolic sine */
		case  COSH: return(cosh(rite)); /* Hyperbolic cosine */
		case  TANH: return(tanh(rite)); /* Hyperbolic tangent */
		default: aplerr = 85; return(0.0); /* left invalid */
	} /* end switch */
}
