/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* dublins APL2 V1.0.0 **************************************************
* Called by dublin to determine the sign of the current constant.       *
* - *valp will contain the constant, converted from ASCII to double.    *
* - *divp will contain the factor by which to divide *valp to obtain    *
*   the true real number constant.                                      *
************************************************************************/
#define INCLUDES APLCHDEF+LIMITS+STRING
#include "includes.h"
int dublins(a,e,sp,signp,valp,divp)
char *a,*e,**sp;
int *signp;
double *divp,*valp;
{
	extern char *aplchar[]; /* global APL character array */
	int sw=0; /* set to 1 if constant found */
     char *s;

	for (s = a; s < e
		&& *s == *(aplchar[SPACE])
		|| *s == '\n' 
		|| *s == '\t'; s++) {} /* white space */
	*signp = 1; /* default sign is plus */
	if (s < e && *s == *(aplchar[OVERBAR])) {
		*signp = -1;
		s++;
	}
	for (*valp = 0.0; s < e
		&& *s >= *(aplchar[APL_0])
          && *s <= *(aplchar[APL_9]); s++) {
		sw=1; /* constant found */
		*valp = 10.0 * *valp + (*s - *(aplchar[APL_0]));
	}
	if (s < e && *s == *(aplchar[DOT])) {
		s++;
		if (sw == 1)
			sw = 2; /* real number */
	}
	if ((*signp == +1 && *valp > INT_MAX) || 
		(*signp == -1 && *valp > INT_MIN))
          sw = 2; /* real number */
	for (*divp = 1.0; s < e
		&& *s >= *(aplchar[APL_0])
          && *s <= *(aplchar[APL_9]); s++) {
		sw=2; /* constant found */
		*valp = 10.0 * *valp + (*s - *(aplchar[APL_0]));
		*divp *= 10.0;
	}
     *sp = s;
     return(sw);
}
