/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* eachdyad APL2 V1.0.0 ************************************************
* Called from each to handle a dyadic derived function.			 *
***********************************************************************/
#define INCLUDES APLDERIV+APLCB+FUNCODES
#include "includes.h"
Aplcb eachdyad(dp,left,rite)
Aplderiv dp; /* function describing derived function */
Aplcb left,rite; /* arguments */
{
	Axisdft; Eachdyae; Eachdyaf; Errstop; Execdyan; Execdyas; Laminate;
	Mod;
	Aplcb out=NULL;
	int i=NO_TYPE;

	if (DERIVED_FUNCTION == dp->deriv_left.funcode) {
		dp->deriv_left.type = DRV;
		dp->deriv_left.func.drv =
			((Aplderiv)(dp->deriv_left.fun))->deriv_func;
	}
	else {
		i = ((Codes *)(dp->deriv_left.fun))->funky_flags;
		if (i & SCALAR) /* each is spurious for builtin scalars */
			return(execdyan(dp->deriv_left.funcode, dp->deriv_left.fun,
				left,rite));
	}
	if (mod(dp->deriv_axis_dbl,1.0) != 0.0)
		if (i == MIXC) {
			dp->deriv_left.type = DBX;
			dp->deriv_left.func.dbx = laminate;
		}
		else return(errstop(9,left,rite,NULL)); /* invalid axis */
	else if (DERIVED_FUNCTION != dp->deriv_left.funcode) {
		dp->deriv_left.type = execdyas(dp->deriv_left.fun,
			&(dp->deriv_left.sdp),&(dp->deriv_left.func));
		switch (dp->deriv_left.type) {
			case DOX:
			case DIX:
			case DNL:
				break;
			case WAX:
				if (dp->deriv_axis_int < 0)
					dp->deriv_axis_int =
						axisdft((Codes *)(dp->deriv_left.fun),
							((left->aplrank > rite->aplrank)
							? left : rite));
				break;
			case NO_TYPE:
			default:
				return(errstop(65,left,rite,NULL)); /* unknown */
		} /* end switch */
	}
	if (left->aplcount && rite->aplcount)
		return(eachdyaf(dp,left,rite)); /* neither argument is empty */
	else return(eachdyae(dp,left,rite)); /* one or both empty */
}
