/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* eachtran - APL2 V1.0.0 **********************************************
* x48.eptok is set by funinit (see funassgo.h) to point to eachtran.   *
* Called from execexee via "noexit = fun->eptok(tok)".                 *
* Transforms an EACH token to a derived function.                      *
***********************************************************************/
#define INCLUDES APLCHDEF+APLTOKEN+FUNSTRUC+APLDERIV+APLCB+FUNCODES
#include "includes.h"
int eachtran(tok)
Apltoken tok; /* token for dieresis */
{
     Chrcopy; Each; Execaxit; Execfree; Execnext; Getcode; Newderiv;
     Slasherr;
     extern int aplerr;
     Apltoken axistok=NULL,funtok=NULL,op=NULL;
     Aplderiv dp;
     int code,i,noexit;
     void *funhold; /* hold area for funstruc ptr set by getcode */
     Aplcb axcb;

     for (;;) { /* lets me use break */
          noexit = execnext(&funtok,&axistok,&op,NULL);
          if (aplerr) break;
          if (funtok == NULL || op)
               { aplerr = 63; /* missing operator */ break; }
          code = getcode(&funhold, funtok);
          if (aplerr) break;
          if (axistok)
               axcb = execaxit(axistok);
          else axcb = NULL;
          dp = newderiv(axcb,NULL,NULL);
          if (aplerr) break;
          execfree(funtok);
          dp->deriv_func = each;
          dp->deriv_left.funcode = code;
          dp->deriv_left.fun = funhold;
          tok->token_code = DERIVED_FUNCTION;
          tok->token_ptr.token_function = dp;
          return(noexit);
     }
     slasherr(funtok,op,axistok,dp);
     return(noexit);
}
