/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* endoper APL2 V1.0.0 *************************************************
* Called to free memory for an aplcb.                                  *
***********************************************************************/
#define INCLUDES APLMEM+APLCB+APLFUNCI
#include "includes.h"
void endoper(op)
Aplcb op;
{
     Expunge; Temp;
     Aplcb *dp;
     void *v;
     int i;

     if (op == NULL)
          return; /* nothing to free */
     if (op->aplflags & APLFUNC) {
          v = expunge((Aplfunc)op); /* expunge function definition */
          return;
     }
     if (!(op->aplflags & APLTEMP))
          return; /* nothing to free */
     dp = op->aplptr.aplapl; /* point to first aplcb */
     if (op->aplflags & APLAPL)
          if (op->aplflags & APLINDX)
               if (i = op->aplcount)
                    while (i--)
                         endoper(*dp++); /* free only if temporary */
               else;
          else {
               i = op->aplcount ? op->aplcount : 1; /* free one */
               while (i--)
                    endoper(temp(*dp++)); /* free regardless */
         }
     free(op);
}
