/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execmonh - APL2 V1.0.0 **********************************************
* Called from execmona to perform a monadic function expected to be on *
* the function stack.                                                  *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLDERIV+APLTOKCD+APLTOKEN\
+FUNCODES+FUNSTRUC+TREE
#include "includes.h"
void execmonh(void)
{
     Axistest; Dervfree; Execaxis; Execfun; Execgeto;
	Execmonj; Execmons; Execout;
	extern int aplerr;
     extern Treelist treehdr;
     Aplcb axcb, out, rite;
     void *arg=NULL, *fun;
     int code, funtype, offset;
     sub_dyad ep;
	deriv_type ptype;

     code = execfun(&fun); /* pop operator/function */
     if (aplerr) return;
     if (NULL == (rite = execgeto(&(treehdr->avlexec->avloprst)))) {
		if (code == DERIVED_FUNCTION)
			dervfree(fun); /* Free aplderiv struct, if any. */
          aplerr = 70; /* indicate missing right operand */
          return;
     }
     offset = treehdr->avloff;
     if (axistest(treehdr->avlexec->avlfunst)) {
     	if (code != FUNCTION_TOKEN) aplerr = 89; /* axis out of place */
          else if (!(((Codes *)fun)->funky_flags &
          	(AXIS | AXES | AXEM))) aplerr = 89;
          else axcb = execaxis(&(treehdr->avlexec->avlfunst));
     }
     else axcb = NULL; /* no axis supplied */
     if (aplerr) return;
     ptype = execmons(code,fun,&arg,&ep);
     if (aplerr) return;
     if (code == FUNCTION_TOKEN &&
     	((Codes *)fun)->funky_code == UP_ARROW)
		treehdr->treeflag |= NOT_WHOLE_ARRAY;
     out = execmonj(ptype, fun, arg, ep, rite, axcb);
     if (out) execout(out,offset); /* put result on stack */
}
