/* Copyright (C) 1996 by Thomas Glen Smith.	All Rights Reserved. */
/* execnexs APL2 V1.0.0 ************************************************
* called by execnext for main processing loop.                         *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLTOKEN+STDIO+TREE
#include "includes.h"
int execnexs(pfun,parg,op,varcnt,pnoexit,savelast,varsw)
Apltoken *pfun; /* w/b = next function token, or null. */
Apltoken *parg; /* w/b = next argument token, or null. */
Apltoken op;	 /* Working token. */
int *varcnt;	 /* w/b > 0 if simple variable name list. */
int *pnoexit;	 /* Initialized. */
int savelast;	 /* Initialized. */
int varsw;	 /* Initialized. */
{
	Axistest; Execindx; Execnexu; Lifo; Pop;
	extern Treelist treehdr;
	extern int aplerr;
	Apltoken tok,wrk;

	wrk = NULL; /* initialize */
	if (op != NULL)
		while (axistest(treehdr->avlexec->avloprst)) {
			varsw = 0; /* not common variable name list */
			op = execindx(op); /* handle indexing */
		}
	if (treehdr->avlexec->avloprst != NULL && savelast == LEFT_ARROW) {
		tok = lifo(&wrk,pop(&(treehdr->avlexec->avloprst)));
		if (varcnt != NULL && varsw) {
			if (tok->token_code != OPERAND_TOKEN) varsw = 0;
			else (*varcnt)++; /* count of names in list */
		}
	}
	if (op != NULL) {
		if (varcnt != NULL && varsw) {
			if (op->token_code != OPERAND_TOKEN) varsw = 0;
			else (*varcnt)++; /* count of names in list */
		}
		op = lifo(&wrk,op); /* push on holding stack */
		op = NULL;
	}
	return(execnexu(pfun,parg,&wrk,varcnt,pnoexit,varsw));
}
