/* Copyright (C) 1996 by Thomas Glen Smith.	All Rights Reserved. */
/* execnexu APL2 V1.0.0 ************************************************
* called by execnexs.                                                  *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLTOKEN+STDIO+TREE
#include "includes.h"
int execnexu(pfun,parg,pwrk,varcnt,pnoexit,varsw)
Apltoken *pfun; /* w/b = next function token, or null. */
Apltoken *parg; /* w/b = next argument token, or null. */
Apltoken *pwrk; /* work stack. */
int *varcnt;	 /* w/b > 0 if simple variable name list. */
int *pnoexit;	 /* Initialized. */
int varsw;	 /* Initialized. */
{
	Axistest; Execexee; Execindx; Execpop; Lifo; Pop; Popnest;
	extern Treelist treehdr;
	extern int aplerr;
	Apltoken op,tck,tok;

	if (*pnoexit && *pwrk != NULL)
		for (;;) {
			if ( varcnt == NULL &&
				(NULL != (tck = treehdr->avltokhd)) &&
				tck->token_code == LEFT_PAREN) break;
			if (0 == (*pnoexit = execexee(pfun,&op))) break;
			if (op == NULL) break;
			while (axistest(treehdr->avlexec->avloprst)) {
				varsw = 0; /* not common variable name list */
				op = execindx(op); /* handle indexing */
			}
			if (varcnt != NULL && varsw) {
				if (op->token_code != OPERAND_TOKEN) varsw = 0;
				else (*varcnt)++; /* count of names in list */
			}
			op = lifo(pwrk,op); /* push on holding stack */
		}
	if (*pfun != NULL) {
		varsw = 0; /* it is not name list */
		*pnoexit = 1;
		tok = lifo(&(treehdr->avltokhd),*pfun); /* return to input */
		*pfun = NULL;
		if (axistest(treehdr->avlexec->avloprst))
			tok = lifo(&(treehdr->avltokhd),
				pop(&(treehdr->avlexec->avloprst)));
	}
	if (aplerr) { execpop(pwrk); return(0); /* all done */ }
	if (varsw)
		*parg = *pwrk; /* return stack of variable names */
	else {
		if (*pwrk != NULL) { /* did execexee find any operands? */
			*parg = popnest(pwrk); /* handle vector notation */
			if (aplerr)
				execpop(pwrk);
		}
		if (varcnt != NULL) *varcnt = 0;
	}
	return(varsw);
}
