/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* exectok APL2 V1.0.0 *************************************************
* Called by execexef, execindx, and popnest.                           *
* Builds a token structure for a new operand.                          *
***********************************************************************/
#define INCLUDES APLTOKEN+APLCB
#include "includes.h"
Apltoken exectok(out,offset)
Aplcb out; /* result */
int offset; /* offset for potential error messages */
{
     Endoper; Newtok;
     extern int aplerr;
     Apltoken outtok;

     if (out == NULL) return(NULL); /* some sort of error has occurred */
     outtok = newtok(VECTOR_TOKEN, 0, offset, NULL, 0);
     if (NULL == outtok) {
          aplerr = 27; /* out of storage */
          endoper(out); /* free aplcb */
          return(NULL);
     }
     outtok->token_queue.token_next_ptr = NULL; /* being tidy */
     outtok->token_ptr.token_vector = out; /* result aplcb ptr */
     return(outtok);
}

