/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* executg APL2 V1.0.0 *************************************************
* Called by executf and execalt to parse and execute an APL stmt.      *
***********************************************************************/
#define INCLUDES APLTOKEN+APLCHDEF+APLCB+TREE
#include "includes.h"
Aplcb executg(rite)
Aplcb rite;
{
	Errinit; Errstop; Execexec; Execfree; Execgetp; Execpars; Execpop;
	Pop;
	extern Treelist treehdr;
	extern int aplerr;
	Apltoken tok,tokhdr,toksave;
	Aplcb out=NULL;
	int i=0;

	for (;;) { /* to use break */
		if (errinit()) break;
		if (rite == NULL) {
			i = 999;
			break; /* internal error */
		}
		if (rite->aplrank > 1) {
			i = 56;
			break; /* m/v vec/sca */
		}
		if (!(rite->aplflags & APLCHAR)) {
			i = 57;
			break; /* m/b char */
		}
		tokhdr = execpars(rite->aplptr.aplchar,rite->aplcount);
		while (tokhdr != NULL && tokhdr->token_code == CAP_NULL)
			execfree(pop(&tokhdr)); /* pop/free input */
		toksave = treehdr->avltokhd;
		treehdr->avltokhd = tokhdr;
		if (aplerr || tokhdr == NULL) break;
		out = execgetp(execexec());
		execpop(&treehdr->avltokhd); /* clean up input stack */
		treehdr->avltokhd = toksave;
		break;
	}
	return(errstop(i,NULL,NULL,out));
}
