/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* expx APL2 V1.0.0 ****************************************************
* Exponential for complex numbers.  For any complex number s#a + bXi,  *
* where i is the square root of -1, e*s = (e*a)X(2Ob)+iX1Ob.           *
***********************************************************************/
#define INCLUDES MATH
#include "includes.h"
void expx(num, ret)
double *num, *ret;
{
	Timesx;
	double a,b,z,wa[2],wb[2];
	static double iii[2]={0.0,1.0};

	a = *num;				/* real part coefficient. */
     b = *(num+1);			/* Imaginary part coefficient. */
     *wa = sin(b);
     *(wa+1) = 0;			/* wa = 1Ob. */
	timesx(iii,wa,wb);		/* wb = iX1Ob. */
	*wb += cos(b);			/* wb = (2Ob)+iX1Ob. */
	*wa = exp(a);			/* wa = (e*a). */
	timesx(wa,wb,ret);		/* ret= (e*a)X(2Ob)+iX1Ob. */
}

